/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.RoutingDebug;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableDouble;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ClickZoomWireListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener {
    private static Preferences prefs = Preferences.userNodeForPackage(ClickZoomWireListener.class);
    private long cancelMoveDelayMillis;
    private long zoomInDelayMillis;
    private boolean interactiveDRCDrag;
    private static final boolean debug = false;
    public static ClickZoomWireListener theOne = new ClickZoomWireListener();
    private int clickX;
    private int clickY;
    private int lastX;
    private int lastY;
    private Cell startCell;
    private double dbMoveStartX;
    private double dbMoveStartY;
    private double lastdbMouseX;
    private double lastdbMouseY;
    private Mode modeLeft = Mode.none;
    private Mode modeRight = Mode.none;
    private Mode modeMiddle = Mode.none;
    private boolean specialSelect = false;
    private boolean invertSelection = false;
    private boolean another;
    private long leftMousePressedTimeStamp;
    private long rightMousePressedTimeStamp;
    private ElectricObject wiringTarget;
    private InteractiveRouter router;
    private ElectricObject startObj;
    private ElectricObject endObj;
    private ArcProto currentArcWhenWiringPressed;
    private int mouseX;
    private int mouseY;
    private Highlight moveDelta;
    private Highlight moveDRC;
    private EventListener oldListener;
    private ArcInst dragArc;
    private PortInst dragArcPort;
    private PortInst dragArcOtherPort;
    private PortInst dragBestOtherPort;
    private Highlight dragArcHigh;
    private Set<PortInst> dragArcPossiblePorts;
    private Set<ArcInst> dragArcSeenArcs;
    private List<Highlight> dragLandingHighlights;
    private static final boolean isMac = ClientOS.isOSMac();
    private static final String cancelMoveDelayMillisPref = "cancelMoveDelayMillis";
    private static final String zoomInDelayMillisPref = "zoomInDelayMillis";

    private ClickZoomWireListener() {
        this.readPrefs();
    }

    public void setSpecialSelect() {
        this.specialSelect = true;
    }

    public void clearSpecialSelect() {
        this.specialSelect = false;
    }

    public boolean getStickyMove() {
        return false;
    }

    public void setRouter(InteractiveRouter router) {
        this.router = router;
    }

    public boolean getStickyWiring() {
        return true;
    }

    public Point2D getLastMouse() {
        return new Point2D.Double(this.mouseX, this.mouseY);
    }

    public void zoomBoxSingleShot(EventListener oldListener) {
        this.modeRight = Mode.zoomBoxSingleShot;
        this.modeLeft = Mode.zoomBoxSingleShot;
        this.modeMiddle = Mode.none;
        this.oldListener = oldListener;
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return isMac ? !evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16 : (evt.getModifiers() & 0x10) == 16;
    }

    public static boolean isRightMouse(InputEvent evt) {
        if (isMac) {
            if (evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16) {
                return true;
            }
            if ((evt.getModifiers() & 4) == 4) {
                return true;
            }
        } else if ((evt.getModifiers() & 4) == 4) {
            return true;
        }
        return false;
    }

    public static boolean isMiddleMouse(InputEvent evt) {
        return (evt.getModifiers() & 8) == 8;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            this.dragArc = null;
            this.startCell = wnd.getCell();
            if (this.startCell == null) {
                return;
            }
            this.clickX = evt.getX();
            this.clickY = evt.getY();
            Point2D dbClick = wnd.screenToDatabase(this.clickX, this.clickY);
            this.lastdbMouseX = dbClick.getX();
            this.lastdbMouseY = dbClick.getY();
            boolean ctrlPressed = (evt.getModifiersEx() & 0x80) != 0;
            this.invertSelection = (evt.getModifiersEx() & 0x40) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.rightMousePressedTimeStamp = currentTime;
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (User.isRoutingMode()) {
                    return;
                }
                if (!this.invertSelection) {
                    ElectricObject eobj1;
                    Highlight h1;
                    ArrayList<Highlight> highlights = new ArrayList<Highlight>();
                    for (Highlight h : highlighter.getHighlights()) {
                        ElectricObject eobj;
                        if (!h.isHighlightEOBJ() || !((eobj = h.getElectricObject()) instanceof PortInst) && !(eobj instanceof NodeInst) && !(eobj instanceof ArcInst)) continue;
                        highlights.add(h);
                    }
                    Iterator hIt = highlights.iterator();
                    if (highlights.size() == 2) {
                        h1 = (Highlight)hIt.next();
                        Highlight h2 = (Highlight)hIt.next();
                        ElectricObject eobj12 = h1.getElectricObject();
                        ElectricObject eobj2 = h2.getElectricObject();
                        if (eobj12 != null && eobj2 != null) {
                            this.modeRight = Mode.wiringConnect;
                            this.wiringTarget = null;
                            this.startObj = h1.getElectricObject();
                            this.endObj = h2.getElectricObject();
                            this.currentArcWhenWiringPressed = User.getUserTool().getCurrentArcProto();
                            EditWindow.gridAlign(dbClick);
                            this.router.highlightRoute(wnd, this.startCell, h1.getElectricObject(), h2.getElectricObject(), dbClick);
                            return;
                        }
                    }
                    if (highlights.size() == 1 && (eobj1 = (h1 = (Highlight)hIt.next()).getElectricObject()) != null) {
                        this.modeRight = Mode.wiringFind;
                        this.endObj = null;
                        this.wiringTarget = null;
                        this.startObj = h1.getElectricObject();
                        this.router.startInteractiveRoute(wnd);
                        Highlight h2 = null;
                        if (!ctrlPressed) {
                            h2 = highlighter.findObject(dbClick, wnd, false, false, false, true, false, this.specialSelect, false, true);
                        }
                        if (h2 == null) {
                            this.endObj = null;
                            this.wiringTarget = null;
                        } else {
                            this.endObj = h2.getElectricObject();
                        }
                        this.currentArcWhenWiringPressed = User.getUserTool().getCurrentArcProto();
                        EditWindow.gridAlign(dbClick);
                        this.router.highlightRoute(wnd, this.startCell, h1.getElectricObject(), this.endObj, dbClick);
                        return;
                    }
                    System.out.println("Must start new arc from one node or arc; or wire two node/arcs together");
                    this.modeRight = Mode.none;
                    return;
                }
                wnd.setStartDrag(this.clickX, this.clickY);
                wnd.setEndDrag(this.clickX, this.clickY);
                wnd.setDoingAreaDrag();
                if (this.invertSelection && !ctrlPressed) {
                    this.modeRight = Mode.zoomOut;
                }
                if (ctrlPressed && this.invertSelection) {
                    highlighter.clear();
                    this.modeRight = Mode.drawBox;
                }
                return;
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (this.modeLeft == Mode.stickyMove && !User.isRoutingMode()) {
                    if (ctrlPressed) {
                        EDimension alignment = wnd.getEditingPreferences().getAlignmentToGrid();
                        dbClick = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbClick, highlighter, alignment);
                    }
                    Point2D.Double dbDelta = new Point2D.Double(dbClick.getX() - this.dbMoveStartX, dbClick.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                        highlighter.setHighlightOffset(0, 0);
                        CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                        wnd.fullRepaint();
                    }
                    this.modeLeft = Mode.none;
                    return;
                }
                this.leftMousePressedTimeStamp = evt.getWhen();
                if (evt.getClickCount() == 2 && !ctrlPressed && !this.invertSelection && highlighter.getNumHighlights() >= 1) {
                    EditMenu.getInfoCommand(true);
                    return;
                }
                if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    highlighter.clear();
                    this.modeLeft = Mode.drawBox;
                    return;
                }
                if (User.isRoutingMode()) {
                    SeaOfGatesEngine.SearchVertex sv = RoutingDebug.findDebugSearchVertex(evt);
                    if (sv != null) {
                        RoutingDebug.showSelectedSV(sv);
                        return;
                    }
                    highlighter.clear();
                    Cell cell = wnd.getCell();
                    Point2D extra = wnd.deltaScreenToDatabase(5, 5);
                    double directHitDist = Math.abs(extra.getX());
                    Rectangle2D.Double searchArea = new Rectangle2D.Double(dbClick.getX() - directHitDist, dbClick.getY() - directHitDist, directHitDist * 2.0, directHitDist * 2.0);
                    Rectangle2D.Double hitBound = new Rectangle2D.Double(dbClick.getX(), dbClick.getY(), 0.0, 0.0);
                    double bestDist = Double.MAX_VALUE;
                    ArcInst bestArc = null;
                    Iterator<Geometric> it = cell.searchIterator(searchArea);
                    while (it.hasNext()) {
                        Poly poly;
                        double dist;
                        Geometric geom = it.next();
                        if (!(geom instanceof ArcInst)) continue;
                        ArcInst ai = (ArcInst)geom;
                        long gridWid = ai.getGridBaseWidth();
                        if (gridWid == 0L) {
                            gridWid = DBMath.lambdaToSizeGrid(1.0);
                        }
                        if (!((dist = (poly = ai.makeLambdaPoly(gridWid, Poly.Type.FILLED)).polyDistance(hitBound)) <= directHitDist) || !(dist < bestDist)) continue;
                        bestDist = dist;
                        bestArc = ai;
                    }
                    if (bestArc != null) {
                        highlighter.addElectricObject(bestArc, cell);
                        this.dragArc = bestArc;
                        this.dragBestOtherPort = null;
                        double distHead = this.dragArc.getHeadLocation().distance(dbClick);
                        double distTail = this.dragArc.getTailLocation().distance(dbClick);
                        if (distHead < distTail) {
                            this.dragArcPort = this.dragArc.getHeadPortInst();
                            this.dragArcOtherPort = this.dragArc.getTailPortInst();
                        } else {
                            this.dragArcPort = this.dragArc.getTailPortInst();
                            this.dragArcOtherPort = this.dragArc.getHeadPortInst();
                        }
                        this.dragArcPossiblePorts = new HashSet<PortInst>();
                        this.dragArcSeenArcs = new HashSet<ArcInst>();
                        this.followEnd(this.dragArcPort, this.dragArc);
                        this.dragLandingHighlights = null;
                    }
                    highlighter.finished();
                    return;
                }
                if (!ctrlPressed && !this.invertSelection && highlighter.overHighlighted(wnd, this.clickX, this.clickY, true) != null) {
                    highlighter.finished();
                    this.dbMoveStartX = dbClick.getX();
                    this.dbMoveStartY = dbClick.getY();
                    this.moveDRC = null;
                    this.moveDelta = null;
                    this.modeLeft = Mode.move;
                } else {
                    Highlight h = highlighter.findObject(dbClick, wnd, false, ctrlPressed, this.invertSelection, true, false, this.specialSelect, true, true);
                    if (h == null) {
                        wnd.setStartDrag(this.clickX, this.clickY);
                        wnd.setEndDrag(this.clickX, this.clickY);
                        wnd.setDoingAreaDrag();
                        this.modeLeft = Mode.selectBox;
                    } else {
                        this.dbMoveStartX = dbClick.getX();
                        this.dbMoveStartY = dbClick.getY();
                        this.moveDRC = null;
                        this.moveDelta = null;
                        this.modeLeft = Mode.move;
                    }
                    this.mouseOver(dbClick, wnd);
                }
                return;
            }
            if (ClickZoomWireListener.isMiddleMouse(evt)) {
                if (this.invertSelection) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    this.modeMiddle = Mode.selectBox;
                    return;
                }
                this.lastX = evt.getX();
                this.lastY = evt.getY();
                this.modeMiddle = Mode.pan;
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            int mouseX = evt.getX();
            int mouseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(mouseX, mouseY);
            this.lastdbMouseX = (int)dbMouse.getX();
            this.lastdbMouseY = (int)dbMouse.getY();
            boolean ctrlPressed = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    if (!wnd.isDoingAreaDrag()) {
                        wnd.setStartDrag(mouseX, mouseY);
                        wnd.setEndDrag(mouseX, mouseY);
                        wnd.setDoingAreaDrag();
                    }
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.zoomOut && currentTime - this.rightMousePressedTimeStamp > this.zoomInDelayMillis) {
                    this.modeRight = Mode.zoomBox;
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox) {
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    Highlight h3 = null;
                    if (!ctrlPressed) {
                        h3 = highlighter.findObject(dbMouse, wnd, false, false, false, true, false, this.specialSelect, false, true);
                    }
                    if (h3 == null) {
                        EditWindow.gridAlign(dbMouse);
                        this.endObj = null;
                        this.wiringTarget = null;
                    } else {
                        Iterator<Highlight> hIt;
                        this.endObj = null;
                        if (this.wiringTarget != null) {
                            EditWindow.gridAlign(dbMouse);
                            List<Highlight> underCursor = Highlighter.findAllInArea(highlighter, cell, false, true, false, this.specialSelect, false, new Rectangle2D.Double(dbMouse.getX(), dbMouse.getY(), 0.0, 0.0), wnd);
                            for (Highlight h : underCursor) {
                                ElectricObject eobj = h.getElectricObject();
                                if (eobj != this.wiringTarget) continue;
                                this.endObj = this.wiringTarget;
                                break;
                            }
                            if (this.endObj == null) {
                                this.wiringTarget = null;
                            }
                        }
                        if (this.endObj == null && (hIt = highlighter.getHighlights().iterator()).hasNext()) {
                            Highlight h2 = hIt.next();
                            this.endObj = h2.getElectricObject();
                        }
                        EditWindow.gridAlign(dbMouse);
                    }
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, null, dbMouse);
                }
            }
            if (this.isLeftMouse(evt)) {
                if (User.isRoutingMode() && this.dragArc != null) {
                    if (this.dragArcHigh != null) {
                        highlighter.remove(this.dragArcHigh);
                    }
                    if (this.dragLandingHighlights == null) {
                        Highlight h;
                        this.dragLandingHighlights = new ArrayList<Highlight>();
                        Point2D extra = wnd.deltaScreenToDatabase(4, 4);
                        double dotSize = Math.abs(extra.getX());
                        Rectangle2D bounds = wnd.getDisplayedBounds();
                        for (PortInst pi : this.dragArcPossiblePorts) {
                            EPoint ctr;
                            if (pi == this.dragArcPort || pi == this.dragArcOtherPort || (ctr = pi.getCenter()).getX() < bounds.getMinX() || ctr.getX() > bounds.getMaxX() || ctr.getY() < bounds.getMinY() || ctr.getY() > bounds.getMaxY()) continue;
                            Poly poly = new Poly(Poly.from(ctr), Poly.fromLambda(ctr.getX() + dotSize, ctr.getY()));
                            poly.setStyle(Poly.Type.DISC);
                            h = highlighter.addPoly(poly, cell, Color.RED);
                            this.dragLandingHighlights.add(h);
                        }
                        for (ArcInst ai : this.dragArcSeenArcs) {
                            if (ai == this.dragArc) continue;
                            EPoint ctr1 = ai.getHeadLocation();
                            EPoint ctr2 = ai.getTailLocation();
                            if (Math.max(ctr1.getX(), ctr2.getX()) < bounds.getMinX() || Math.min(ctr1.getX(), ctr2.getX()) > bounds.getMaxX() || Math.max(ctr1.getY(), ctr2.getY()) < bounds.getMinY() || Math.min(ctr1.getY(), ctr2.getY()) > bounds.getMaxY()) continue;
                            h = highlighter.addLine(ctr1, ctr2, cell, false, Color.RED, false);
                            this.dragLandingHighlights.add(h);
                        }
                    }
                    double bestDist = Double.MAX_VALUE;
                    this.dragBestOtherPort = null;
                    Point2D extra = wnd.deltaScreenToDatabase(10, 10);
                    double directHitDist = Math.abs(extra.getX());
                    for (PortInst pi : this.dragArcPossiblePorts) {
                        double dist;
                        if (pi == this.dragArcPort || pi == this.dragArcOtherPort || (dist = pi.getCenter().distance(dbMouse)) > directHitDist || !(dist < bestDist)) continue;
                        bestDist = dist;
                        this.dragBestOtherPort = pi;
                    }
                    this.dragArcHigh = this.dragBestOtherPort != null ? highlighter.addLine(this.dragBestOtherPort.getCenter(), this.dragArcOtherPort.getCenter(), cell, true, Color.RED, false) : highlighter.addLine(dbMouse, this.dragArcOtherPort.getCenter(), cell, false, false);
                    wnd.repaint();
                    return;
                }
                if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.zoomBoxSingleShot) {
                    wnd.setEndDrag(mouseX, mouseY);
                    wnd.repaint();
                }
                if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                    if (ctrlPressed) {
                        EDimension alignment = wnd.getEditingPreferences().getAlignmentToGrid();
                        dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse, highlighter, alignment);
                    }
                    Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    Point screenDelta = wnd.deltaDatabaseToScreen(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                    highlighter.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                    WorstSpacing ws = new WorstSpacing();
                    List<Geometric> selected = highlighter.getHighlightedEObjs(true, true);
                    if (this.interactiveDRCDrag && selected.size() == 1) {
                        int i;
                        Poly[] polys;
                        Geometric g = selected.get(0);
                        Netlist nl = g.getParent().getNetlist();
                        if (g instanceof ArcInst) {
                            ArcInst ai = (ArcInst)g;
                            Network net = nl.getNetwork(ai, 0);
                            if (net != null) {
                                polys = ai.getProto().getTechnology().getShapeOfArc(ai);
                                for (i = 0; i < polys.length; ++i) {
                                    ws.findWorstSpacing(g, polys[i], net, dbDelta, nl);
                                }
                            }
                        } else {
                            NodeInst ni = (NodeInst)g;
                            if (!ni.isCellInstance()) {
                                FixpTransform trans = ni.rotateOut();
                                polys = ni.getProto().getTechnology().getShapeOfNode(ni, true, true, null);
                                for (i = 0; i < polys.length; ++i) {
                                    Network net;
                                    PortInst pi;
                                    PortProto pp = polys[i].getPort();
                                    if (pp == null || (pi = ni.findPortInstFromEquivalentProto(pp)) == null || (net = nl.getNetwork(pi)) == null) continue;
                                    polys[i].transform(trans);
                                    ws.findWorstSpacing(g, polys[i], net, dbDelta, nl);
                                }
                            }
                        }
                    }
                    if (this.moveDelta != null) {
                        highlighter.remove(this.moveDelta);
                    }
                    if (this.moveDRC != null) {
                        highlighter.remove(this.moveDRC);
                    }
                    Technology tech = wnd.getCell().getTechnology();
                    String deltaMessage = "Moved (" + TextUtils.formatDistance(((Point2D)dbDelta).getX(), tech) + "," + TextUtils.formatDistance(((Point2D)dbDelta).getY(), tech) + ")";
                    WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                    StatusBar.setCoordinates(deltaMessage, wf);
                    if (ws.validSpacing()) {
                        Poly hPoly;
                        Geometric g;
                        boolean tooClose = ws.getSeparation() < ws.getMinSpacing();
                        String message = ws.getOneLayer().getName();
                        if (ws.getOneLayer() != ws.getOtherLayer()) {
                            message = message + " to " + ws.getOtherLayer().getName();
                        }
                        message = message + " spacing is " + TextUtils.formatDistance(ws.getSeparation(), tech);
                        if (tooClose) {
                            message = "ERROR! " + message + " MINIMUM IS " + TextUtils.formatDistance(ws.getMinSpacing(), tech);
                        }
                        if ((g = selected.get(0)) instanceof NodeInst) {
                            hPoly = Highlight.getNodeInstOutline((NodeInst)g);
                        } else {
                            ArcInst ai = (ArcInst)g;
                            hPoly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
                        }
                        double minX = 0.0;
                        double maxY = 0.0;
                        PolyBase.Point[] points = hPoly.getPoints();
                        for (int i = 0; i < points.length; ++i) {
                            if (i == 0 || ((Point2D)points[i]).getX() < minX) {
                                minX = ((Point2D)points[i]).getX();
                            }
                            if (i != 0 && !(((Point2D)points[i]).getY() > maxY)) continue;
                            maxY = ((Point2D)points[i]).getY();
                        }
                        this.moveDelta = highlighter.addMessage(cell, message, new Point2D.Double(minX + ((Point2D)dbDelta).getX(), maxY + ((Point2D)dbDelta).getY()));
                        Point2D.Double end1 = new Point2D.Double(ws.getOnePoint().getX() - ((Point2D)dbDelta).getX(), ws.getOnePoint().getY() - ((Point2D)dbDelta).getY());
                        Point2D.Double end2 = new Point2D.Double(ws.getOtherPoint().getX() - ((Point2D)dbDelta).getX(), ws.getOtherPoint().getY() - ((Point2D)dbDelta).getY());
                        this.moveDRC = highlighter.addLine(end1, end2, cell, tooClose, true);
                    }
                    wnd.repaint();
                }
            }
            if (ClickZoomWireListener.isMiddleMouse(evt)) {
                if (this.modeMiddle == Mode.selectBox) {
                    wnd.setEndDrag(mouseX, mouseY);
                    wnd.repaint();
                    return;
                }
                if (this.modeMiddle == Mode.pan) {
                    int newX = evt.getX();
                    int newY = evt.getY();
                    Point2D pt = wnd.getScheduledOffset();
                    double scale = wnd.getScale();
                    wnd.setOffset(new Point2D.Double(pt.getX() - (double)(newX - this.lastX) / scale, pt.getY() + (double)(newY - this.lastY) / scale));
                    wnd.getSavedFocusBrowser().updateCurrentFocus();
                    wnd.fullRepaint();
                    this.lastX = newX;
                    this.lastY = newY;
                    return;
                }
            }
            wnd.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            double maxSelY;
            double minSelY;
            double maxSelX;
            double minSelX;
            Point2D end;
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (cell != this.startCell) {
                this.escapePressed(wnd);
                return;
            }
            int releaseX = evt.getX();
            int releaseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(releaseX, releaseY);
            boolean ctrlPressed = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                double scale;
                if (this.modeRight == Mode.zoomIn) {
                    scale = wnd.getScale();
                    wnd.setScale(scale * 2.0);
                    wnd.clearDoingAreaDrag();
                    wnd.getSavedFocusBrowser().saveCurrentFocus();
                    wnd.fullRepaint();
                }
                if (this.modeRight == Mode.zoomOut) {
                    scale = wnd.getScale();
                    wnd.setScale(scale / 2.0);
                    if (wnd.isInPlaceEdit()) {
                        wnd.getInPlaceTransformOut().transform(dbMouse, dbMouse);
                    }
                    wnd.setOffset(dbMouse);
                    wnd.clearDoingAreaDrag();
                    wnd.getSavedFocusBrowser().saveCurrentFocus();
                    wnd.fullRepaint();
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot) {
                    Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                    end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                    minSelX = Math.min(start.getX(), end.getX());
                    maxSelX = Math.max(start.getX(), end.getX());
                    minSelY = Math.min(start.getY(), end.getY());
                    maxSelY = Math.max(start.getY(), end.getY());
                    boolean onePoint = true;
                    Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                    if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                        onePoint = false;
                    }
                    if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                        onePoint = false;
                    }
                    if (this.modeRight == Mode.drawBox) {
                        highlighter.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                    }
                    if (this.modeRight == Mode.zoomBoxSingleShot) {
                        if (!onePoint) {
                            wnd.focusScreen(bounds);
                        }
                        WindowFrame.setListener(this.oldListener);
                        if (this.modeLeft == Mode.zoomBoxSingleShot) {
                            this.modeLeft = Mode.none;
                        }
                    }
                    if (this.modeRight == Mode.zoomBox) {
                        if (onePoint) {
                            double scale2 = wnd.getScale();
                            wnd.setScale(scale2 / 2.0);
                            wnd.clearDoingAreaDrag();
                            wnd.getSavedFocusBrowser().saveCurrentFocus();
                            wnd.fullRepaint();
                        } else {
                            wnd.focusScreen(bounds);
                        }
                    }
                    highlighter.finished();
                    wnd.clearDoingAreaDrag();
                    wnd.repaint();
                }
                if (!(User.isRoutingMode() || this.modeRight != Mode.wiringFind && this.modeRight != Mode.stickyWiring)) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, null, dbMouse);
                    this.wiringTarget = null;
                }
                this.modeRight = Mode.none;
            }
            if (this.isLeftMouse(evt)) {
                if (User.isRoutingMode()) {
                    if (this.dragArcHigh != null) {
                        this.clearArcDragHighlighting(highlighter);
                        if (this.dragArc != null && this.dragBestOtherPort != null) {
                            new MoveArcEnd(this.dragArc, this.dragBestOtherPort, this.dragArcOtherPort);
                        }
                        wnd.repaint();
                    }
                    return;
                }
                long curTime = evt.getWhen();
                if ((this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) && curTime - this.leftMousePressedTimeStamp < this.cancelMoveDelayMillis) {
                    highlighter.setHighlightOffset(0, 0);
                    this.modeLeft = Mode.none;
                    if (this.moveDelta != null) {
                        highlighter.remove(this.moveDelta);
                    }
                    if (this.moveDRC != null) {
                        highlighter.remove(this.moveDRC);
                    }
                    wnd.repaint();
                    return;
                }
                if (this.getStickyMove() && this.modeLeft == Mode.move) {
                    this.modeLeft = Mode.stickyMove;
                } else {
                    if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.zoomBoxSingleShot) {
                        Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                        Point2D end2 = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                        double minSelX2 = Math.min(start.getX(), end2.getX());
                        double maxSelX2 = Math.max(start.getX(), end2.getX());
                        double minSelY2 = Math.min(start.getY(), end2.getY());
                        double maxSelY2 = Math.max(start.getY(), end2.getY());
                        boolean onePoint = true;
                        Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX2, minSelY2, maxSelX2 - minSelX2, maxSelY2 - minSelY2);
                        if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                            onePoint = false;
                        }
                        if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                            onePoint = false;
                        }
                        if (this.modeLeft == Mode.selectBox) {
                            if (!this.invertSelection) {
                                highlighter.clear();
                            }
                            highlighter.selectArea(wnd, minSelX2, maxSelX2, minSelY2, maxSelY2, this.invertSelection, this.specialSelect);
                        }
                        if (this.modeLeft == Mode.drawBox) {
                            highlighter.addArea(new Rectangle2D.Double(minSelX2, minSelY2, maxSelX2 - minSelX2, maxSelY2 - minSelY2), cell);
                        }
                        if (this.modeLeft == Mode.zoomBoxSingleShot) {
                            if (!onePoint) {
                                wnd.focusScreen(bounds);
                            }
                            WindowFrame.setListener(this.oldListener);
                            if (this.modeRight == Mode.zoomBoxSingleShot) {
                                this.modeRight = Mode.none;
                            }
                        }
                        highlighter.finished();
                        wnd.clearDoingAreaDrag();
                        wnd.repaint();
                    }
                    if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                        if (ctrlPressed) {
                            EDimension alignment = wnd.getEditingPreferences().getAlignmentToGrid();
                            dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse, highlighter, alignment);
                        }
                        Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                        EditWindow.gridAlign(dbDelta);
                        if (this.moveDelta != null) {
                            highlighter.remove(this.moveDelta);
                        }
                        if (this.moveDRC != null) {
                            highlighter.remove(this.moveDRC);
                        }
                        if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                            highlighter.setHighlightOffset(0, 0);
                            CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                            wnd.fullRepaint();
                        }
                    }
                    this.modeLeft = Mode.none;
                }
            }
            if (ClickZoomWireListener.isMiddleMouse(evt)) {
                if (this.modeMiddle == Mode.selectBox) {
                    Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                    end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                    minSelX = Math.min(start.getX(), end.getX());
                    maxSelX = Math.max(start.getX(), end.getX());
                    minSelY = Math.min(start.getY(), end.getY());
                    maxSelY = Math.max(start.getY(), end.getY());
                    highlighter.clear();
                    highlighter.selectArea(wnd, minSelX, maxSelX, minSelY, maxSelY, false, this.specialSelect);
                    highlighter.finished();
                    wnd.clearDoingAreaDrag();
                    wnd.repaint();
                }
                this.modeMiddle = Mode.none;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (User.isRoutingMode()) {
                SeaOfGatesEngine.SearchVertex sv = RoutingDebug.findDebugSearchVertex(evt);
                if (sv != null) {
                    RoutingDebug.previewSelectedSV(sv, false);
                }
                return;
            }
            this.specialSelect = ToolBar.isSelectSpecial();
            Point2D dbMouse = wnd.screenToDatabase(this.mouseX, this.mouseY);
            if (this.modeLeft == Mode.stickyMove) {
                if (this.another) {
                    EDimension alignment = wnd.getEditingPreferences().getAlignmentToGrid();
                    dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse, highlighter, alignment);
                }
                Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                EditWindow.gridAlign(dbDelta);
                Point screenDelta = wnd.deltaDatabaseToScreen((int)((Point2D)dbDelta).getX(), (int)((Point2D)dbDelta).getY());
                highlighter.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                wnd.repaint();
            }
            this.mouseOver(dbMouse, wnd);
        }
    }

    private void mouseOver(Point2D dbMouse, EditWindow wnd) {
        if (!User.isMouseOverHighlightingEnabled()) {
            return;
        }
        if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
            return;
        }
        Highlight found = null;
        Highlighter highlighter = wnd.getHighlighter();
        if (!this.another && !this.invertSelection) {
            Point screenMouse = wnd.databaseToScreen(dbMouse);
            found = highlighter.overHighlighted(wnd, (int)((Point2D)screenMouse).getX(), (int)((Point2D)screenMouse).getY(), false);
        }
        if (found == null) {
            found = highlighter.findObject(dbMouse, wnd, false, this.another, this.invertSelection, true, false, this.specialSelect, true, false);
        }
        if (found != null) {
            List<Highlight> existing = highlighter.getHighlights();
            for (Highlight h : existing) {
                if (!h.sameThing(found, true)) continue;
                found = null;
                break;
            }
        }
        boolean changed = false;
        Highlighter mouseOverHighlighter = wnd.getMouseOverHighlighter();
        List<Highlight> mouseOld = mouseOverHighlighter.getHighlights();
        if (found == null) {
            if (mouseOld.size() > 0) {
                changed = true;
            }
        } else if (mouseOld.size() != 1 || !found.sameThing(mouseOld.get(0), true)) {
            changed = true;
        }
        if (changed) {
            mouseOverHighlighter.clear();
            if (found != null) {
                mouseOverHighlighter.addHighlight(found);
            }
            mouseOverHighlighter.finished();
            wnd.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof EditWindow) {
            WindowFrame.show3DHighlight();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (this.modeMiddle != Mode.none) {
                return;
            }
            boolean sideways = (evt.getModifiersEx() & 0x40) != 0;
            boolean zoom = (evt.getModifiersEx() & 0x80) != 0;
            int rotation = evt.getWheelRotation();
            if (zoom) {
                double scale = wnd.getScale();
                double dY = (double)rotation / 10.0;
                scale = dY < 0.0 ? (scale -= scale * dY) : (scale *= Math.exp(-dY));
                wnd.setScale(scale);
                wnd.getSavedFocusBrowser().updateCurrentFocus();
                wnd.fullRepaint();
            } else if (sideways) {
                ZoomAndPanListener.panXOrY(0, wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            } else {
                ZoomAndPanListener.panXOrY(1, wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean redrawMouseOver = false;
            if (chr == 27) {
                this.escapePressed(wnd);
            } else if (chr == 17) {
                if (!this.another) {
                    redrawMouseOver = true;
                }
                this.another = true;
            } else if (chr == 16) {
                if (!this.invertSelection) {
                    redrawMouseOver = true;
                }
                this.invertSelection = true;
            }
            if (redrawMouseOver) {
                this.mouseOver(wnd.screenToDatabase(this.mouseX, this.mouseY), wnd);
            }
        }
    }

    private void escapePressed(EditWindow wnd) {
        Highlighter highlighter = wnd.getHighlighter();
        if (this.modeRight == Mode.wiringConnect || this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring || this.modeRight == Mode.wiringToSpace) {
            this.router.cancelInteractiveRoute();
        }
        if (this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot || this.modeRight == Mode.zoomOut || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.selectBox) {
            wnd.clearDoingAreaDrag();
        }
        if (this.modeMiddle == Mode.selectBox) {
            wnd.clearDoingAreaDrag();
        }
        this.clearArcDragHighlighting(highlighter);
        this.modeLeft = Mode.none;
        this.modeRight = Mode.none;
        this.modeMiddle = Mode.none;
        highlighter.setHighlightOffset(0, 0);
        wnd.repaint();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean redrawMouseOver = false;
            if (chr == 17) {
                if (this.another) {
                    redrawMouseOver = true;
                }
                this.another = false;
            } else if (chr == 16) {
                if (this.invertSelection) {
                    redrawMouseOver = true;
                }
                this.invertSelection = false;
            }
            if (redrawMouseOver) {
                this.mouseOver(wnd.screenToDatabase(this.mouseX, this.mouseY), wnd);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    public static void moveSelected(double dX, double dY, boolean scaleMove, boolean scaleMove2) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        EDimension arrowDistance = User.getAlignmentToGrid();
        dX *= arrowDistance.getWidth();
        dY *= arrowDistance.getHeight();
        double scaleX = User.getDefGridXBoldFrequency();
        double scaleY = User.getDefGridYBoldFrequency();
        if (scaleMove) {
            dX *= scaleX;
            dY *= scaleY;
        }
        if (scaleMove2) {
            dX *= scaleX;
            dY *= scaleY;
        }
        Point2D.Double del = new Point2D.Double(dX, dY);
        EditWindow.gridAlign(del);
        dX = ((Point2D)del).getX();
        dY = ((Point2D)del).getY();
        if (WindowFrame.getListener() == OutlineListener.theOne) {
            OutlineListener.theOne.moveSelectedPoint(dX, dY);
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.setHighlightOffset(0, 0);
        if (wnd.isInPlaceEdit()) {
            Point2D.Double delta = new Point2D.Double(dX, dY);
            FixpTransform trans = wnd.getInPlaceTransformIn();
            trans.deltaTransform(delta, delta);
            dX = ((Point2D)delta).getX();
            dY = ((Point2D)delta).getY();
        }
        CircuitChanges.manyMove(dX, dY);
        wnd.fullRepaint();
    }

    private static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint, Highlighter highlighter, EDimension alignment) {
        int orthoAngle = 90;
        List<Geometric> highObjs = highlighter.getHighlightedEObjs(true, true);
        for (Geometric geom : highObjs) {
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                Iterator<Connection> it = ni.getConnections();
                while (it.hasNext()) {
                    Connection con = it.next();
                    int thisAngle = ClickZoomWireListener.getAngleIncrement(con.getArc());
                    if (thisAngle >= orthoAngle) continue;
                    orthoAngle = thisAngle;
                }
                continue;
            }
            int thisAngle = ClickZoomWireListener.getAngleIncrement((ArcInst)geom);
            if (thisAngle >= orthoAngle) continue;
            orthoAngle = thisAngle;
        }
        if (orthoAngle == 0) {
            return mousePoint;
        }
        return InteractiveRouter.getClosestAngledPoint(startPoint, mousePoint, orthoAngle, alignment);
    }

    private static int getAngleIncrement(ArcInst ai) {
        int angle = ai.getDefinedAngle();
        if (angle % 900 == 0) {
            return 90;
        }
        if (angle % 450 == 0) {
            return 45;
        }
        if (angle % 300 == 0) {
            return 30;
        }
        return 90;
    }

    public void switchWiringTarget() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (this.modeRight == Mode.wiringToSpace) {
            this.modeRight = Mode.wiringFind;
        }
        if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
            Point2D.Double dbMouse = new Point2D.Double(DBMath.round(this.lastdbMouseX), DBMath.round(this.lastdbMouseY));
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.lastdbMouseX, this.lastdbMouseY, 0.0, 0.0);
            List<Highlight> targets = Highlighter.findAllInArea(highlighter, wnd.getCell(), false, true, false, this.specialSelect, false, bounds, wnd);
            Iterator<Highlight> it = targets.iterator();
            boolean found = false;
            if (this.wiringTarget == null) {
                this.wiringTarget = this.endObj;
            }
            while (it.hasNext()) {
                if (it.next().getElectricObject() != this.wiringTarget) continue;
                found = true;
                if (!it.hasNext()) {
                    this.modeRight = Mode.wiringToSpace;
                    this.wiringTarget = null;
                    break;
                }
                this.wiringTarget = it.next().getElectricObject();
                break;
            }
            if (!found) {
                it = targets.iterator();
                this.wiringTarget = it.hasNext() ? it.next().getElectricObject() : null;
            }
            if (this.modeRight == Mode.wiringToSpace) {
                this.endObj = null;
                System.out.println("Switching to 'ignore all wiring targets'");
                this.router.highlightRoute(wnd, cell, this.startObj, null, dbMouse);
                return;
            }
            if (this.endObj == this.wiringTarget) {
                return;
            }
            this.endObj = this.wiringTarget;
            if (this.wiringTarget == null) {
                System.out.println("Switching to wiring target 'none'");
            } else {
                System.out.println("Switching to wiring target '" + this.wiringTarget + "'");
            }
            this.router.highlightRoute(wnd, cell, this.startObj, this.wiringTarget, dbMouse);
        }
    }

    public void wireTo(int layerNumber) {
        ElectricObject obj;
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        ArcProto ap = null;
        Technology tech = Technology.getCurrent();
        boolean found = false;
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ap = it.next();
            if (ap.isNotUsed()) continue;
            switch (layerNumber) {
                case 0: {
                    if (ap.getFunction() != ArcProto.Function.POLY1) break;
                    found = true;
                    break;
                }
                case 1: {
                    if (ap.getFunction() != ArcProto.Function.METAL1) break;
                    found = true;
                    break;
                }
                case 2: {
                    if (ap.getFunction() != ArcProto.Function.METAL2 && ap.getFunction() != ArcProto.Function.BUS) break;
                    found = true;
                    break;
                }
                case 3: {
                    if (ap.getFunction() != ArcProto.Function.METAL3) break;
                    found = true;
                    break;
                }
                case 4: {
                    if (ap.getFunction() != ArcProto.Function.METAL4) break;
                    found = true;
                    break;
                }
                case 5: {
                    if (ap.getFunction() != ArcProto.Function.METAL5) break;
                    found = true;
                    break;
                }
                case 6: {
                    if (ap.getFunction() != ArcProto.Function.METAL6) break;
                    found = true;
                    break;
                }
                case 7: {
                    if (ap.getFunction() != ArcProto.Function.METAL7) break;
                    found = true;
                    break;
                }
                case 8: {
                    if (ap.getFunction() != ArcProto.Function.METAL8) break;
                    found = true;
                    break;
                }
                case 9: {
                    if (ap.getFunction() != ArcProto.Function.METAL9) break;
                    found = true;
                }
            }
            if (!found) continue;
        }
        if (!found) {
            return;
        }
        if (highlighter.getNumHighlights() == 1 && cell != null && (obj = highlighter.getOneHighlight().getElectricObject()) instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            this.router.makeVerticalRoute(wnd, pi, ap);
        }
        User.getUserTool().setCurrentArcProto(ap);
    }

    public void wireDownUp(boolean down) {
        ElectricObject obj;
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        Technology tech = cell.getTechnology();
        if (highlighter.getNumHighlights() == 1 && cell != null && (obj = highlighter.getOneHighlight().getElectricObject()) instanceof PortInst) {
            ArcProto.Function newFunc;
            PortInst pi = (PortInst)obj;
            ArcProto[] connArcs = pi.getPortProto().getBasePort().getConnections();
            if (connArcs == null || connArcs.length == 0) {
                return;
            }
            ArcProto sourceAp = null;
            for (ArcProto ap : connArcs) {
                if (ap.getTechnology() != tech || ap.isNotUsed() || !ap.getFunction().isPoly() && !ap.getFunction().isMetal()) continue;
                if (sourceAp == null) {
                    sourceAp = ap;
                    continue;
                }
                if (down && ap.getFunction().isPoly() && sourceAp.getFunction().isMetal()) {
                    sourceAp = ap;
                    continue;
                }
                if (!down && ap.getFunction().isMetal() && sourceAp.getFunction().isPoly()) {
                    sourceAp = ap;
                    continue;
                }
                if (down && ap.getFunction().getLevel() < sourceAp.getFunction().getLevel()) {
                    sourceAp = ap;
                    continue;
                }
                if (down || ap.getFunction().getLevel() <= sourceAp.getFunction().getLevel()) continue;
                sourceAp = ap;
            }
            boolean metal = sourceAp.getFunction().isMetal();
            int level = sourceAp.getFunction().getLevel();
            if (down && level == 1 && !metal) {
                return;
            }
            if (down && level == 1 && metal) {
                metal = false;
            } else if (down) {
                --level;
            } else if (!down) {
                ++level;
            }
            ArcProto.Function function = newFunc = metal ? ArcProto.Function.getMetal(level) : ArcProto.Function.getPoly(level);
            if (newFunc == null) {
                return;
            }
            ArcProto destAp = null;
            boolean found = false;
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                destAp = it.next();
                if (destAp.isNotUsed() || destAp.getFunction() != newFunc) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            this.router.makeVerticalRoute(wnd, pi, destAp);
            User.getUserTool().setCurrentArcProto(destAp);
        }
    }

    private void followEnd(PortInst end, ArcInst ai) {
        if (this.dragArcSeenArcs.contains(ai)) {
            return;
        }
        this.dragArcSeenArcs.add(ai);
        Netlist nl = ai.getParent().getNetlist();
        Network net = nl.getNetwork(end);
        NodeInst ni = end.getNodeInst();
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            if (nl.getNetwork(pi) != net) continue;
            Iterator<Connection> cIt = pi.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                ArcInst otherAI = con.getArc();
                PortInst otherPI = otherAI.getPortInst(1 - con.getEndIndex());
                this.dragArcPossiblePorts.add(otherPI);
                this.followEnd(otherPI, otherAI);
            }
        }
    }

    private void clearArcDragHighlighting(Highlighter highlighter) {
        if (this.dragArcHigh != null) {
            highlighter.remove(this.dragArcHigh);
            this.dragArcHigh = null;
        }
        if (this.dragLandingHighlights != null) {
            for (Highlight h : this.dragLandingHighlights) {
                highlighter.remove(h);
            }
        }
    }

    public JPopupMenu selectPopupMenu(List<Highlight> objects) {
        JPopupMenu popup = new JPopupMenu("Choose One");
        for (Highlight obj : objects) {
            JMenuItem m = new JMenuItem(obj.toString());
            m.addActionListener(this);
            popup.add(m);
        }
        return popup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void readPrefs() {
        this.router = new SimpleWirer(UserInterfaceMain.getEditingPreferences().withFatWires(true));
        this.router.setTool(User.getUserTool());
        this.cancelMoveDelayMillis = prefs.getLong(cancelMoveDelayMillisPref, ClickZoomWireListener.getFactoryCancelMoveDelayMillis());
        this.zoomInDelayMillis = prefs.getLong(zoomInDelayMillisPref, 120L);
        this.interactiveDRCDrag = new DRC.DRCPreferences((boolean)false).interactiveDRCDrag;
    }

    public long getCancelMoveDelayMillis() {
        return this.cancelMoveDelayMillis;
    }

    public static long getFactoryCancelMoveDelayMillis() {
        return 200L;
    }

    public void setCancelMoveDelayMillis(long delay2) {
        this.cancelMoveDelayMillis = delay2;
        prefs.putLong(cancelMoveDelayMillisPref, delay2);
    }

    public long getZoomInDelayMillis() {
        return this.zoomInDelayMillis;
    }

    public void setZoomInDelayMillis(long delay2) {
        this.zoomInDelayMillis = delay2;
        prefs.putLong(zoomInDelayMillisPref, delay2);
    }

    private static class MoveArcEnd
    extends Job {
        private ArcInst ai;
        private ArcInst newAI;
        private PortInst toPort;
        private PortInst otherEnd;

        MoveArcEnd(ArcInst ai, PortInst toPort, PortInst otherEnd) {
            super("Move Arc End", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ai = ai;
            this.toPort = toPort;
            this.otherEnd = otherEnd;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.newAI = ArcInst.makeInstance(this.ai.getProto(), this.getEditingPreferences(), this.otherEnd, this.toPort);
            this.ai.kill();
            this.fieldVariableChanged("newAI");
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd != null) {
                wnd.clearHighlighting();
                wnd.addElectricObject(this.newAI, this.newAI.getParent());
                wnd.finishedHighlighting();
            }
        }
    }

    private static class WorstSpacing {
        private boolean valid = false;
        private double separation;
        private double worstViolation;
        private double minSpacing;
        private Point2D worstFrom = new Point2D.Double(0.0, 0.0);
        private Point2D worstTo = new Point2D.Double(0.0, 0.0);
        private Layer layerFrom;
        private Layer layerTo;

        public boolean validSpacing() {
            return this.valid;
        }

        public double getSeparation() {
            return this.separation;
        }

        public double getMinSpacing() {
            return this.minSpacing;
        }

        public Layer getOneLayer() {
            return this.layerFrom;
        }

        public Layer getOtherLayer() {
            return this.layerTo;
        }

        public Point2D getOnePoint() {
            return this.worstFrom;
        }

        public Point2D getOtherPoint() {
            return this.worstTo;
        }

        public void findWorstSpacing(Geometric self, Poly poly, Network net, Point2D delta, Netlist nl) {
            Layer lay = poly.getLayer();
            if (lay == null) {
                return;
            }
            if (lay.isPseudoLayer()) {
                return;
            }
            if (lay.getFunction().isSubstrate()) {
                return;
            }
            PolyBase.Point[] points = poly.getPoints();
            for (int j = 0; j < points.length; ++j) {
                poly.setPoint(j, ((Point2D)points[j]).getX() + delta.getX(), ((Point2D)points[j]).getY() + delta.getY());
            }
            FixpRectangle bounds = poly.getBounds2D();
            double xS = ((RectangularShape)bounds).getWidth();
            double yS = ((RectangularShape)bounds).getHeight();
            double widRule = Math.min(xS, yS);
            double lenRule = Math.max(xS, yS);
            int multiCut = -1;
            MutableDouble mutableDist = new MutableDouble(0.0);
            boolean found = DRC.getMaxSurround(lay, Double.MAX_VALUE, mutableDist);
            if (!found) {
                return;
            }
            double surround = mutableDist.doubleValue();
            double worstInteractionDistance = surround * 5.0;
            Rectangle2D.Double searchBounds = new Rectangle2D.Double(((RectangularShape)bounds).getMinX() - worstInteractionDistance, ((RectangularShape)bounds).getMinY() - worstInteractionDistance, ((RectangularShape)bounds).getWidth() + worstInteractionDistance * 2.0, ((RectangularShape)bounds).getHeight() + worstInteractionDistance * 2.0);
            Iterator<Geometric> it = self.getParent().searchIterator(searchBounds);
            while (it.hasNext()) {
                Layer otherLay;
                Poly otherPoly;
                int i;
                Poly[] otherPolys;
                Geometric neighbor = it.next();
                if (neighbor == self) continue;
                if (neighbor instanceof NodeInst) {
                    NodeInst otherNi = (NodeInst)neighbor;
                    if (otherNi.isCellInstance()) continue;
                    FixpTransform trans = otherNi.rotateOut();
                    otherPolys = otherNi.getProto().getTechnology().getShapeOfNode(otherNi, true, true, null);
                    for (i = 0; i < otherPolys.length; ++i) {
                        DRCTemplate rule;
                        Network otherNet;
                        PortInst pi;
                        PortProto pp;
                        otherPoly = otherPolys[i];
                        otherLay = otherPoly.getLayer();
                        if (otherLay == null || otherLay.isPseudoLayer() || otherLay.getFunction().isSubstrate() || lay.getTechnology() != otherLay.getTechnology() || (pp = otherPoly.getPort()) == null || (pi = otherNi.findPortInstFromEquivalentProto(pp)) == null || (otherNet = nl.getNetwork(pi)) == null || net == otherNet || (rule = DRC.getSpacingRule(lay, null, otherLay, null, false, multiCut, widRule, lenRule)) == null) continue;
                        double dist = rule.getValue(0);
                        otherPoly.transform(trans);
                        double sep = poly.separation(otherPoly);
                        if (this.valid && sep - dist >= this.worstViolation) continue;
                        this.valid = true;
                        this.worstViolation = sep - dist;
                        this.separation = sep;
                        this.minSpacing = dist;
                        this.layerFrom = lay;
                        this.layerTo = otherLay;
                        this.findClosestPoints(poly, otherPoly);
                    }
                    continue;
                }
                ArcInst otherAi = (ArcInst)neighbor;
                Network otherNet = nl.getNetwork(otherAi, 0);
                if (otherNet == null || net == otherNet) continue;
                otherPolys = otherAi.getProto().getTechnology().getShapeOfArc(otherAi);
                for (i = 0; i < otherPolys.length; ++i) {
                    DRCTemplate rule;
                    otherPoly = otherPolys[i];
                    otherLay = otherPoly.getLayer();
                    if (otherLay == null || otherLay.isPseudoLayer() || otherLay.getFunction().isSubstrate() || (rule = DRC.getSpacingRule(lay, null, otherLay, null, true, multiCut, widRule, lenRule)) == null) continue;
                    double dist = rule.getValue(0);
                    double sep = poly.separation(otherPoly);
                    if (this.valid && sep - dist >= this.worstViolation) continue;
                    this.valid = true;
                    this.worstViolation = sep - dist;
                    this.separation = sep;
                    this.minSpacing = dist;
                    this.layerFrom = lay;
                    this.layerTo = otherLay;
                    this.findClosestPoints(poly, otherPoly);
                }
            }
        }

        private void findClosestPoints(Poly from2, Poly to2) {
            double pd;
            FixpRectangle fromBox = from2.getBox();
            FixpRectangle toBox = to2.getBox();
            if (fromBox != null && toBox != null) {
                if (((RectangularShape)fromBox).getMinX() < ((RectangularShape)toBox).getMaxX() && ((RectangularShape)fromBox).getMaxX() > ((RectangularShape)toBox).getMinX()) {
                    double xPos = (Math.max(((RectangularShape)fromBox).getMinX(), ((RectangularShape)toBox).getMinX()) + Math.min(((RectangularShape)fromBox).getMaxX(), ((RectangularShape)toBox).getMaxX())) / 2.0;
                    if (((RectangularShape)fromBox).getMinY() > ((RectangularShape)toBox).getMaxY()) {
                        this.worstFrom.setLocation(xPos, ((RectangularShape)fromBox).getMinY());
                        this.worstTo.setLocation(xPos, ((RectangularShape)toBox).getMaxY());
                        return;
                    }
                    if (((RectangularShape)toBox).getMinY() > ((RectangularShape)fromBox).getMaxY()) {
                        this.worstFrom.setLocation(xPos, ((RectangularShape)fromBox).getMaxY());
                        this.worstTo.setLocation(xPos, ((RectangularShape)toBox).getMinY());
                        return;
                    }
                    return;
                }
                if (((RectangularShape)fromBox).getMinY() < ((RectangularShape)toBox).getMaxY() && ((RectangularShape)fromBox).getMaxY() > ((RectangularShape)toBox).getMinY()) {
                    double yPos = (Math.max(((RectangularShape)fromBox).getMinY(), ((RectangularShape)toBox).getMinY()) + Math.min(((RectangularShape)fromBox).getMaxY(), ((RectangularShape)toBox).getMaxY())) / 2.0;
                    if (((RectangularShape)fromBox).getMinX() > ((RectangularShape)toBox).getMaxX()) {
                        this.worstFrom.setLocation(((RectangularShape)fromBox).getMinX(), yPos);
                        this.worstTo.setLocation(((RectangularShape)toBox).getMaxX(), yPos);
                        return;
                    }
                    if (((RectangularShape)toBox).getMinX() > ((RectangularShape)fromBox).getMaxX()) {
                        this.worstFrom.setLocation(((RectangularShape)fromBox).getMaxX(), yPos);
                        this.worstTo.setLocation(((RectangularShape)toBox).getMinX(), yPos);
                        return;
                    }
                    return;
                }
            }
            double minPD = 0.0;
            PolyBase.Point[] fromPoints = from2.getPoints();
            for (int f2 = 0; f2 < fromPoints.length; ++f2) {
                Point2D c = to2.closestPoint(fromPoints[f2]);
                pd = c.distance(fromPoints[f2]);
                if (f2 != 0 && pd >= minPD) continue;
                minPD = pd;
                this.worstFrom.setLocation(fromPoints[f2]);
            }
            minPD = 0.0;
            PolyBase.Point[] toPoints = to2.getPoints();
            for (int t = 0; t < toPoints.length; ++t) {
                pd = this.worstFrom.distance(toPoints[t]);
                if (t != 0 && pd >= minPD) continue;
                minPD = pd;
                this.worstTo.setLocation(toPoints[t]);
            }
        }
    }

    private static class Mode {
        private final String name;
        public static final Mode none = new Mode("none");
        public static final Mode move = new Mode("move");
        public static final Mode stickyMove = new Mode("stickyMove");
        public static final Mode drawBox = new Mode("drawBox");
        public static final Mode zoomBox = new Mode("zoomBox");
        public static final Mode pan = new Mode("pan");
        public static final Mode zoomBoxSingleShot = new Mode("zoomBoxSingleShot");
        public static final Mode zoomIn = new Mode("zoomIn");
        public static final Mode zoomOut = new Mode("zoomOut");
        public static final Mode selectBox = new Mode("selectBox");
        public static final Mode wiringConnect = new Mode("wiring");
        public static final Mode wiringFind = new Mode("wiringFind");
        public static final Mode wiringToSpace = new Mode("wiringToSpace");
        public static final Mode stickyWiring = new Mode("stickyWiring");

        public Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

