/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class ElectricPrinter
implements Printable,
ImageObserver {
    private WindowContent context;
    private EditWindow0.EditWindowSmall wnd;
    private PageFormat pageFormat;
    private PrinterJob printJob;
    private BufferedImage img = null;
    private Graphics graphics;
    private Dimension oldSize;
    private int desiredDPI = IOTool.getPrintResolution();
    private GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();
    private AbstractDrawing.DrawingPreferences dp = new AbstractDrawing.DrawingPreferences();
    private Rectangle2D renderArea;
    private int displayAlgorithm = User.getDisplayAlgorithm();
    private boolean greekImages = User.isUseCellGreekingImages();
    private double greekSizeLimit = User.getGreekSizeLimit();
    private double greekCellSizeLimit = User.getGreekCellSizeLimit();
    private String[] allStrings;
    private int startLine;
    private int startChar;
    private Font printFont;
    private int pageHeight;
    private int fontHeight;
    private int yOffset;
    private int linesPerPage;
    private int startLineAtPage;
    private int startCharAtPage;
    private int startPageNumber;
    private FontRenderContext frc;

    public ElectricPrinter(WindowContent context, PageFormat pageFormat, PrinterJob printJob) {
        if (context == null) {
            this.wnd = new EditWindow0.EditWindowSmall(null);
            this.context = null;
        } else {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                this.wnd = new EditWindow0.EditWindowSmall(wnd);
            }
            this.context = context;
        }
        this.pageFormat = pageFormat;
        this.printJob = printJob;
    }

    public BufferedImage getBufferedImage() {
        return this.img;
    }

    public void setBufferedImage(BufferedImage img) {
        this.img = img;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public PrinterJob getPrintJob() {
        return this.printJob;
    }

    public int getDesiredDPI() {
        return this.desiredDPI;
    }

    public void setOldSize(Dimension oldSize) {
        this.oldSize = oldSize;
    }

    public Dimension getOldSize() {
        return this.oldSize;
    }

    public void setRenderArea(Rectangle2D rect) {
        this.renderArea = rect;
    }

    public Rectangle2D getRenderArea() {
        return this.renderArea;
    }

    public GraphicsPreferences getGraphicsPreferences() {
        return this.gp;
    }

    public int getDisplayAlgorithm() {
        return this.displayAlgorithm;
    }

    public boolean isUseCellGreekingImages() {
        return this.greekImages;
    }

    public double getGreekSizeLimit() {
        return this.greekSizeLimit;
    }

    public double getGreekCellSizeLimit() {
        return this.greekCellSizeLimit;
    }

    public EditWindow0 getWindow() {
        return this.wnd;
    }

    public AbstractDrawing.DrawingPreferences getDrawingPreferences() {
        return this.dp;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (this.context instanceof TextWindow) {
            TextWindow tw = (TextWindow)this.context;
            if (page == 0) {
                this.allStrings = tw.convertToStrings();
                this.printFont = new Font("Helvetica", 0, 10);
                FontMetrics fm = g.getFontMetrics(this.printFont);
                this.pageHeight = (int)pf.getImageableHeight();
                this.fontHeight = fm.getHeight();
                this.yOffset = fm.getAscent();
                this.linesPerPage = this.pageHeight / this.fontHeight;
                this.startChar = 0;
                this.startLine = 0;
                this.startPageNumber = 0;
                this.startLineAtPage = this.startLine;
                this.startCharAtPage = this.startChar;
                this.frc = new FontRenderContext(null, true, true);
            }
            if (page == this.startPageNumber) {
                this.startLine = this.startLineAtPage;
                this.startChar = this.startCharAtPage;
            } else {
                this.startPageNumber = page;
                this.startLineAtPage = this.startLine;
                this.startCharAtPage = this.startChar;
            }
            if (this.startLine < this.allStrings.length) {
                g.setColor(Color.WHITE);
                g.fillRect((int)pf.getImageableX(), (int)pf.getImageableY(), (int)pf.getImageableWidth(), (int)pf.getImageableHeight());
                g.setFont(this.printFont);
                g.setColor(Color.BLACK);
                for (int i = 0; i < this.linesPerPage && this.startLine < this.allStrings.length; ++i) {
                    GlyphVector gv;
                    Rectangle2D rasRect;
                    String fullLine = this.allStrings[this.startLine];
                    int endChar = fullLine.length();
                    String theLine = null;
                    while (!((rasRect = (gv = this.printFont.createGlyphVector(this.frc, theLine = fullLine.substring(this.startChar, endChar))).getLogicalBounds()).getWidth() <= pf.getImageableWidth()) && --endChar > this.startChar) {
                    }
                    g.drawString(theLine, (int)pf.getImageableX(), (int)pf.getImageableY() + this.yOffset + i * this.fontHeight);
                    if (endChar < fullLine.length()) {
                        this.startChar = endChar;
                        continue;
                    }
                    ++this.startLine;
                    this.startChar = 0;
                }
                return 0;
            }
        } else if (this.context instanceof EditWindow && page == 0) {
            this.graphics = g;
            this.pageFormat = pf;
            if (this.context.getPrintImage(this) != null) {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x2, int y, int width, int height) {
        return false;
    }
}

