/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class SvexVar<N extends SvarName>
extends Svex<N> {
    public Svar<N> svar;

    public SvexVar(Svar<N> svar) {
        if (svar == null) {
            throw new NullPointerException();
        }
        this.svar = svar;
    }

    @Override
    public <N1 extends SvarName> Svex<N1> convertVars(Function<N, N1> rename, SvexManager<N1> sm, Map<Svex<N>, Svex<N1>> cache) {
        Svex<N1> svex = cache.get(this);
        if (svex == null) {
            SvarName newName = (SvarName)rename.apply(this.svar.getName());
            svex = sm.getSvex(newName, this.svar.getDelay(), this.svar.isNonblocking());
            cache.put(this, svex);
        }
        return svex;
    }

    @Override
    public Svex<N> addDelay(int delay, SvexManager<N> sm, Map<Svex<N>, Svex<N>> cache) {
        Svex<N> svex = cache.get(this);
        if (svex == null) {
            svex = sm.getSvex(this.svar.getName(), delay + this.svar.getDelay(), this.svar.isNonblocking());
            cache.put(this, svex);
        }
        return svex;
    }

    @Override
    protected void collectVarsRev(Set<Svar<N>> result, Set<SvexCall<N>> visited) {
        result.add(this.svar);
    }

    @Override
    public <R, D> R accept(Svex.Visitor<N, R, D> visitor, D data) {
        return visitor.visitVar(this.svar, data);
    }

    @Override
    <R> R traverse(Svex.TraverseVisitor<N, R> visitor, Map<Svex<N>, R> cache) {
        R result = cache.get(this);
        if (result == null) {
            result = visitor.visitVar(this.svar);
            cache.put(this, result);
        }
        return result;
    }

    @Override
    public Vec4 xeval(Map<Svex<N>, Vec4> memoize) {
        return Vec4.X;
    }

    @Override
    public Svex<N> patch(Map<Svar<N>, Vec4> subst, SvexManager<N> sm, Map<SvexCall<N>, SvexCall<N>> memoize) {
        Vec4 val = subst.get(this.svar);
        return val != null ? SvexQuote.valueOf(val) : this;
    }

    @Override
    public boolean isLhsUnbounded() {
        return true;
    }

    @Override
    public boolean isLhs() {
        return false;
    }

    @Override
    public Lhs<N> lhsBound(int w) {
        Lhatom<N> atom = Lhatom.valueOf(this.svar);
        Lhrange<N> range = new Lhrange<N>(w, atom);
        return new Lhs<N>(Collections.singletonList(range));
    }

    @Override
    public Lhs<N> toLhs() {
        return new Lhs(Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SvexVar) {
            SvexVar that = (SvexVar)o;
            return this.hashCode() == that.hashCode() && this.svar.equals(that.svar);
        }
        return false;
    }

    public int hashCode() {
        return this.svar.hashCode();
    }

    @Override
    public ACL2Object getACL2Object(Map<ACL2Backed, ACL2Object> backedCache) {
        return this.svar.getACL2Object(backedCache);
    }
}

