/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.tool.user.Exec;
import java.util.ArrayList;
import java.util.List;

public class ExecMulti
implements Exec.FinishedListener {
    private List<Exec> execs = new ArrayList<Exec>();
    private List<String> preRunComments = new ArrayList<String>();
    private List<String> postRunComments = new ArrayList<String>();
    private List<Exec.FinishedListener> finishedListeners = new ArrayList<Exec.FinishedListener>();
    private List<Exec.FinishedEvent> finishedEvents = new ArrayList<Exec.FinishedEvent>();
    private List<Boolean> ignoreExitValues = new ArrayList<Boolean>();
    private int nextExec = 0;

    public void addExec(Exec e) {
        this.addExec(e, "", "", false);
    }

    public void addExec(Exec e, boolean ignoreExitValue) {
        this.addExec(e, "", "", ignoreExitValue);
    }

    public void addExec(Exec e, String preRunComment, String postRunComment, boolean ignoreExitValue) {
        this.execs.add(e);
        this.preRunComments.add(preRunComment);
        this.postRunComments.add(postRunComment);
        this.ignoreExitValues.add(ignoreExitValue);
    }

    public void start() {
        this.startNext();
    }

    private void startNext() {
        if (this.execs.size() == 0) {
            return;
        }
        if (this.nextExec >= this.execs.size()) {
            this.done();
            return;
        }
        Exec e = this.execs.get(this.nextExec);
        e.addFinishedListener(this);
        String pre = this.preRunComments.get(this.nextExec);
        if (pre != null && !pre.equals("")) {
            System.out.println(pre);
        }
        e.start();
        String post = this.postRunComments.get(this.nextExec);
        if (post != null && !post.equals("")) {
            System.out.println(post);
        }
    }

    @Override
    public void processFinished(Exec.FinishedEvent e) {
        if (e.getExitValue() != 0) {
            boolean b = this.ignoreExitValues.get(this.nextExec);
            if (b) {
                e = new Exec.FinishedEvent(e.getSource(), e.getExec(), e.getWorkingDir(), 0);
            } else {
                this.finishedEvents.add(e);
                this.done();
                return;
            }
        }
        this.finishedEvents.add(e);
        ++this.nextExec;
        this.startNext();
    }

    private void done() {
        for (Exec.FinishedListener l : this.finishedListeners) {
            l.processFinished(this.finishedEvents.get(this.finishedEvents.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinishedListener(Exec.FinishedListener a) {
        List<Exec.FinishedListener> list = this.finishedListeners;
        synchronized (list) {
            this.finishedListeners.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinishedListener(Exec.FinishedListener a) {
        List<Exec.FinishedListener> list = this.finishedListeners;
        synchronized (list) {
            this.finishedListeners.remove(a);
        }
    }
}

