/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.PixelDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableDouble;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class VectorDrawing {
    private static final boolean TAKE_STATS = false;
    private static final int MAXGREEKSIZE = 25;
    private static final int SCALE_SH = 20;
    private PixelDrawing offscreen;
    private float scale;
    private float scale_;
    private float factorX;
    private float factorY;
    private int factorX_;
    private int factorY_;
    private int scale_int;
    private boolean fullInstantiate;
    private List<NodeInst> inPlaceNodePath;
    private Cell inPlaceCurrent;
    private ElapseTimer timer = ElapseTimer.createInstance();
    private boolean takingLongTime;
    private boolean stopRendering;
    private int szHalfWidth;
    private int szHalfHeight;
    private int screenLX;
    private int screenHX;
    private int screenLY;
    private int screenHY;
    private int boxCount;
    private int tinyBoxCount;
    private int lineBoxCount;
    private int lineCount;
    private int polygonCount;
    private int crossCount;
    private int textCount;
    private int circleCount;
    private int arcCount;
    private int subCellCount;
    private int tinySubCellCount;
    private int invisSubCellCount;
    private float objectVisibleThreshold;
    private float objectGreekThreshold;
    private boolean useCellGreekingImages;
    private float maxTextSize;
    private float maxCellSize;
    private Point tempPt1 = new Point();
    private Point tempPt2 = new Point();
    private Point tempPt3 = new Point();
    private Rectangle tempRect = new Rectangle();
    private FixpRectangle tempFixpRect = FixpRectangle.fromFixpDiagonal(0L, 0L, 0L, 0L);
    private static VectorDrawing topVD;
    private static int debugXP;
    private static int debugYP;

    public VectorDrawing(boolean useCellGreekingImages) {
        this.useCellGreekingImages = useCellGreekingImages;
    }

    public void render(PixelDrawing offscreen, double scale, Point2D offset, Cell cell, boolean fullInstantiate, List<NodeInst> inPlaceNodePath, Cell inPlaceCurrent, Rectangle screenLimit, VarContext context, double greekSizeLimit, double greekCellSizeLimit, LayerVisibility lv) {
        this.offscreen = offscreen;
        offscreen.highlightingLayers = false;
        Iterator<Layer> it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (!lv.isHighlighted(layer)) continue;
            offscreen.highlightingLayers = true;
            break;
        }
        Dimension sz = offscreen.getSize();
        this.scale = (float)scale;
        this.scale_ = (float)(scale / 400.0);
        this.objectGreekThreshold = (float)greekSizeLimit / this.scale;
        this.objectVisibleThreshold = 1.0f / this.scale;
        this.maxTextSize = (float)((double)this.objectGreekThreshold / PixelDrawing.dp.globalTextScale);
        double screenArea = sz.getWidth() / scale * sz.getHeight() / scale;
        this.maxCellSize = (float)(greekCellSizeLimit * screenArea);
        this.timer.start();
        long initialUsed = 0L;
        this.takingLongTime = false;
        this.polygonCount = 0;
        this.lineCount = 0;
        this.lineBoxCount = 0;
        this.tinyBoxCount = 0;
        this.boxCount = 0;
        this.arcCount = 0;
        this.circleCount = 0;
        this.textCount = 0;
        this.crossCount = 0;
        this.invisSubCellCount = 0;
        this.tinySubCellCount = 0;
        this.subCellCount = 0;
        this.fullInstantiate = fullInstantiate;
        this.inPlaceNodePath = inPlaceNodePath;
        this.inPlaceCurrent = inPlaceCurrent;
        this.szHalfWidth = sz.width / 2;
        this.szHalfHeight = sz.height / 2;
        this.screenLX = 0;
        this.screenHX = sz.width;
        this.screenLY = 0;
        this.screenHY = sz.height;
        this.factorX = (float)(offset.getX() * 400.0 - (double)((float)this.szHalfWidth / this.scale_));
        this.factorY = (float)(offset.getY() * 400.0 + (double)((float)this.szHalfHeight / this.scale_));
        this.factorX_ = (int)this.factorX;
        this.factorY_ = (int)this.factorY;
        this.scale_int = (int)(this.scale_ * 1048576.0f);
        if (screenLimit != null) {
            this.screenLX = screenLimit.x;
            if (this.screenLX < 0) {
                this.screenLX = 0;
            }
            this.screenHX = screenLimit.x + screenLimit.width;
            if (this.screenHX >= sz.width) {
                this.screenHX = sz.width - 1;
            }
            this.screenLY = screenLimit.y;
            if (this.screenLY < 0) {
                this.screenLY = 0;
            }
            this.screenHY = screenLimit.y + screenLimit.height;
            if (this.screenHY >= sz.height) {
                this.screenHY = sz.height - 1;
            }
        }
        this.stopRendering = false;
        try {
            VectorCache.VectorCell topVC = this.drawCell(cell, Orientation.IDENT, context, true);
            topVD = this;
            long startTime = 0L;
            this.render(topVC, 0L, 0L, context, 0, lv);
            this.drawList(0L, 0L, topVC.getTopOnlyShapes(), 0, false);
        }
        catch (AbortRenderingException abortRenderingException) {
            // empty catch block
        }
        topVD = null;
        if (this.takingLongTime) {
            TopLevel.setBusyCursor(false);
            System.out.println("Done");
        }
    }

    public void render(PixelDrawing offscreen, double scale, Point2D offset, VectorCache.VectorBase[] shapes) {
        PixelDrawing.textGraphics = PixelDrawing.textGraphics.withColor(PixelDrawing.gp.getColor(User.ColorPrefType.TEXT));
        this.offscreen = offscreen;
        Dimension sz = offscreen.getSize();
        this.scale = (float)scale;
        this.scale_ = (float)(scale / 400.0);
        this.szHalfWidth = sz.width / 2;
        this.szHalfHeight = sz.height / 2;
        this.screenLX = 0;
        this.screenHX = sz.width;
        this.screenLY = 0;
        this.screenHY = sz.height;
        this.factorX = (float)(offset.getX() * 400.0 - (double)((float)this.szHalfWidth / this.scale_));
        this.factorY = (float)(offset.getY() * 400.0 + (double)((float)this.szHalfHeight / this.scale_));
        this.factorX_ = (int)this.factorX;
        this.factorY_ = (int)this.factorY;
        this.scale_int = (int)(this.scale_ * 1048576.0f);
        try {
            List<VectorCache.VectorBase> shapeList = Arrays.asList(shapes);
            this.drawList(0L, 0L, shapeList, 0, true);
        }
        catch (AbortRenderingException abortRenderingException) {
            // empty catch block
        }
    }

    public void abortRendering() {
        this.stopRendering = true;
    }

    private void render(VectorCache.VectorCell vc, long oX, long oY, VarContext context, int level, LayerVisibility lv) throws AbortRenderingException {
        Iterator<VectorCache.VectorSubCell> sea;
        List<Layer> knownLayers = vc.getKnownLayers();
        Technology curTech = Technology.getCurrent();
        for (Layer lay : knownLayers) {
            if (lay.getTechnology() == curTech) continue;
            this.drawList(oX, oY, vc.getShapes(lay), level, false);
        }
        for (Layer lay : knownLayers) {
            if (lay.getTechnology() != curTech) continue;
            this.drawList(oX, oY, vc.getShapes(lay), level, false);
        }
        Cell cell = VectorCache.getCellFromId(vc.getCellDef().getCellId());
        if (vc.getSubCellTree() == null) {
            sea = vc.getSubCells().iterator();
        } else {
            long swap;
            this.screenToGrid(this.screenLX, this.screenLY, this.tempPt1);
            long dbLX = (long)this.tempPt1.x - oX;
            long dbLY = (long)this.tempPt1.y - oY;
            this.screenToGrid(this.screenHX, this.screenHY, this.tempPt1);
            long dbHX = (long)this.tempPt1.x - oX;
            long dbHY = (long)this.tempPt1.y - oY;
            if (dbLX > dbHX) {
                swap = dbLX;
                dbLX = dbHX;
                dbHX = swap;
            }
            if (dbLY > dbHY) {
                swap = dbLY;
                dbLY = dbHY;
                dbHY = swap;
            }
            ERectangle bound = ERectangle.fromGrid(dbLX, dbLY, dbHX - dbLX, dbHY - dbLY);
            vc.getOrientation().inverse().rectangleBounds(bound, EPoint.ORIGIN, this.tempFixpRect);
            sea = new RTNode.Search<VectorCache.VectorSubCell>(this.tempFixpRect, vc.getSubCellTree(), true);
        }
        while (sea.hasNext()) {
            boolean isExpanded;
            boolean expanded;
            VectorCache.VectorSubCell vsc = sea.next();
            if (this.stopRendering) {
                throw new AbortRenderingException();
            }
            ImmutableNodeInst ini = vsc.getNode();
            Cell subCell = VectorCache.getCellFromId((CellId)ini.protoId);
            ++this.subCellCount;
            long soX = vsc.getOffsetX() + oX;
            long soY = vsc.getOffsetY() + oY;
            VectorCache.VectorCell subVC = VectorCache.theCache.findVectorCell(vsc.getCellId(), vc.getOrientation().concatenate(ini.orient));
            this.gridToScreen(subVC.getLX() + soX, subVC.getHY() + soY, this.tempPt1);
            this.gridToScreen(subVC.getHX() + soX, subVC.getLY() + soY, this.tempPt2);
            long lX = this.tempPt1.x;
            long lY = this.tempPt1.y;
            long hX = this.tempPt2.x;
            long hY = this.tempPt2.y;
            if (vc.getSubCellTree() == null && (hX < (long)this.screenLX || lX >= (long)this.screenHX || hY < (long)this.screenLY || lY >= (long)this.screenHY)) continue;
            if (subVC.getCellDef().getMinimumSize() < this.objectVisibleThreshold) {
                ++this.invisSubCellCount;
                continue;
            }
            if (subVC.getCellDef().getMinimumSize() < this.objectGreekThreshold) {
                Orientation thisOrient = ini.orient;
                Orientation recurseTrans = vc.getOrientation().concatenate(thisOrient);
                VarContext subContext = context.push(cell, ini);
                VectorCache.VectorCell subVC_ = this.drawCell(subCell, recurseTrans, subContext, false);
                assert (subVC_ == subVC);
                this.makeGreekedImage(subVC, lv);
                int fadeColor = this.getFadeColor(subVC, subContext, lv);
                this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                ++this.tinySubCellCount;
                continue;
            }
            boolean onPathDown = false;
            if (this.inPlaceNodePath != null) {
                for (NodeInst niOnPath : this.inPlaceNodePath) {
                    if (niOnPath.getProto().getId() != vsc.getCellId()) continue;
                    onPathDown = true;
                    break;
                }
            }
            boolean bl = expanded = (isExpanded = cell.isExpanded(ini.nodeId)) || this.fullInstantiate;
            if (!expanded && onPathDown) {
                expanded = true;
            }
            if (expanded) {
                int subLevel;
                Orientation thisOrient = ini.orient;
                Orientation recurseTrans = vc.getOrientation().concatenate(thisOrient);
                VarContext subContext = null;
                if (context != null) {
                    subContext = context.push(cell, ini);
                }
                VectorCache.VectorCell subVC_ = this.drawCell(subCell, recurseTrans, subContext, false);
                assert (subVC_ == subVC);
                if (!subCell.isIcon()) {
                    boolean smallerThanGreek;
                    boolean allFeaturesTiny = subVC.getMaxFeatureSize() > 0.0f && subVC.getMaxFeatureSize() < this.objectGreekThreshold && subVC.getCellDef().getArea() < this.maxCellSize && this.isContentsTiny(subCell, subVC, recurseTrans, context);
                    boolean bl2 = smallerThanGreek = this.useCellGreekingImages && hX - lX <= 25L && hY - lY <= 25L;
                    if (allFeaturesTiny || smallerThanGreek) {
                        this.makeGreekedImage(subVC, lv);
                        int fadeColor = this.getFadeColor(subVC, context, lv);
                        this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                        ++this.tinySubCellCount;
                        continue;
                    }
                }
                if ((subLevel = level) == 0) {
                    subLevel = 1;
                }
                this.render(subVC, soX, soY, subContext, subLevel, lv);
            } else {
                long[] op = subVC.getOutlinePoints();
                long p1x = op[0] + soX;
                long p1y = op[1] + soY;
                long p2x = op[2] + soX;
                long p2y = op[3] + soY;
                long p3x = op[4] + soX;
                long p3y = op[5] + soY;
                long p4x = op[6] + soX;
                long p4y = op[7] + soY;
                this.gridToScreen(p1x, p1y, this.tempPt1);
                this.gridToScreen(p2x, p2y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, PixelDrawing.instanceGraphics, 0, false);
                this.gridToScreen(p2x, p2y, this.tempPt1);
                this.gridToScreen(p3x, p3y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, PixelDrawing.instanceGraphics, 0, false);
                this.gridToScreen(p3x, p3y, this.tempPt1);
                this.gridToScreen(p4x, p4y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, PixelDrawing.instanceGraphics, 0, false);
                this.gridToScreen(p1x, p1y, this.tempPt1);
                this.gridToScreen(p4x, p4y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, PixelDrawing.instanceGraphics, 0, false);
                if (PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) {
                    this.tempRect.setBounds((int)lX, (int)lY, (int)(hX - lX), (int)(hY - lY));
                    TextDescriptor descript = ini.protoDescriptor;
                    this.offscreen.drawText(this.tempRect, Poly.Type.TEXTBOX, descript, subCell.describe(false), null, PixelDrawing.textGraphics, false);
                }
            }
            if (level != 0 && !onPathDown && this.inPlaceCurrent != cell) continue;
            this.drawPortList(vsc, subVC, soX, soY, expanded, onPathDown);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawList(long oX, long oY, List<VectorCache.VectorBase> shapes, int level, boolean forceVisible) throws AbortRenderingException {
        if (shapes == null) {
            return;
        }
        for (k = shapes.size() - 1; k >= 0; --k) {
            block47: {
                vb = shapes.get(k);
                if (this.stopRendering) {
                    throw new AbortRenderingException();
                }
                layer = vb.getLayer();
                dimmed = false;
                if (layer != null) {
                    if (level < 0 && ((fun = layer.getFunction()).isContact() || fun.isWell() || fun.isSubstrate())) continue;
                    if (!forceVisible) {
                        if (!PixelDrawing.lv.isVisible(layer)) continue;
                        dimmed = PixelDrawing.lv.isHighlighted(layer) == false;
                    }
                }
                layerBitMap = null;
                graphics = vb.getGraphics();
                if (graphics == null && layer != null) {
                    graphics = PixelDrawing.gp.getGraphics(layer);
                }
                if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.offscreen.numLayerBitMaps) {
                    layerBitMap = this.offscreen.getLayerBitMap(layerNum);
                }
                if (vb instanceof VectorCache.VectorManhattan) {
                    ++this.boxCount;
                    vm = (VectorCache.VectorManhattan)vb;
                    maxSize = (double)this.objectGreekThreshold * 400.0;
                    fadeCol = -1;
                    if (layer != null) {
                        fun = layer.getFunction();
                        if (fun.isImplant() || fun.isSubstrate()) {
                            if (!vm.isPureLayer()) {
                                maxSize *= 10.0;
                            }
                        } else if (graphics != null) {
                            fadeCol = graphics.getRGB();
                        }
                    }
                    coords = vm.getCoords();
                    for (i = 0; i < coords.length; i += 4) {
                        c1X = coords[i];
                        c1Y = coords[i + 1];
                        c2X = coords[i + 2];
                        c2Y = coords[i + 3];
                        dX = c2X - c1X;
                        dY = c2Y - c1Y;
                        if ((double)dX < maxSize || (double)dY < maxSize) {
                            if (fadeCol < 0) continue;
                            if ((double)dX < maxSize && (double)dY < maxSize) {
                                this.gridToScreen(c1X + oX, c1Y + oY, this.tempPt1);
                                x = this.tempPt1.x;
                                y = this.tempPt1.y;
                                if (x < this.screenLX || x >= this.screenHX || y < this.screenLY || y >= this.screenHY) continue;
                                this.offscreen.drawPoint(x, y, null, fadeCol);
                                ++this.tinyBoxCount;
                                continue;
                            }
                            this.gridToScreen(c1X + oX, c2Y + oY, this.tempPt1);
                            this.gridToScreen(c2X + oX, c1Y + oY, this.tempPt2);
                            if (!(VectorDrawing.$assertionsDisabled || this.tempPt1.x <= this.tempPt2.x && this.tempPt1.y <= this.tempPt2.y)) {
                                throw new AssertionError();
                            }
                            lX = this.tempPt1.x;
                            hX = this.tempPt2.x;
                            lY = this.tempPt1.y;
                            hY = this.tempPt2.y;
                            if (hX < this.screenLX || lX >= this.screenHX || hY < this.screenLY || lY >= this.screenHY) continue;
                            this.drawTinyBox(lX, hX, lY, hY, fadeCol, null);
                            ++this.lineBoxCount;
                            continue;
                        }
                        this.gridToScreen(c1X + oX, c2Y + oY, this.tempPt1);
                        this.gridToScreen(c2X + oX, c1Y + oY, this.tempPt2);
                        if (!(VectorDrawing.$assertionsDisabled || this.tempPt1.x <= this.tempPt2.x && this.tempPt1.y <= this.tempPt2.y)) {
                            throw new AssertionError();
                        }
                        lX = this.tempPt1.x;
                        hX = this.tempPt2.x;
                        lY = this.tempPt1.y;
                        hY = this.tempPt2.y;
                        if (hX < this.screenLX || lX >= this.screenHX || hY < this.screenLY || lY >= this.screenHY) continue;
                        if (lX < this.screenLX) {
                            lX = this.screenLX;
                        }
                        if (hX >= this.screenHX) {
                            hX = this.screenHX - 1;
                        }
                        if (lY < this.screenLY) {
                            lY = this.screenLY;
                        }
                        if (hY >= this.screenHY) {
                            hY = this.screenHY - 1;
                        }
                        this.offscreen.drawBox(lX, hX, lY, hY, layerBitMap, graphics, dimmed);
                    }
                    continue;
                }
                if (vb instanceof VectorCache.VectorLine) {
                    ++this.lineCount;
                    vl = (VectorCache.VectorLine)vb;
                    this.gridToScreen(vl.getFromX() + oX, vl.getFromY() + oY, this.tempPt1);
                    this.gridToScreen(vl.getToX() + oX, vl.getToY() + oY, this.tempPt2);
                    this.offscreen.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, vl.getTexture(), dimmed);
                    continue;
                }
                if (vb instanceof VectorCache.VectorPolygon) {
                    ++this.polygonCount;
                    vp = (VectorCache.VectorPolygon)vb;
                    oldPoints = vp.getPoints();
                    intPoints = new Point[oldPoints.length];
                    for (i = 0; i < oldPoints.length; ++i) {
                        intPoints[i] = new Point();
                        this.gridToScreen(oldPoints[i].getGridX() + oX, oldPoints[i].getGridY() + oY, intPoints[i]);
                    }
                    clippedPoints = GenMath.clipPoly(intPoints, this.screenLX, this.screenHX - 1, this.screenLY, this.screenHY - 1);
                    if (clippedPoints.length < 2) continue;
                    this.offscreen.drawPolygon(clippedPoints, layerBitMap, graphics, dimmed);
                    continue;
                }
                if (vb instanceof VectorCache.VectorCross) {
                    ++this.crossCount;
                    vcr = (VectorCache.VectorCross)vb;
                    this.gridToScreen(vcr.getCenterX() + oX, vcr.getCenterY() + oY, this.tempPt1);
                    size = 5;
                    if (vcr.isSmall()) {
                        size = 3;
                    }
                    this.offscreen.drawLine(new Point(this.tempPt1.x - size, this.tempPt1.y), new Point(this.tempPt1.x + size, this.tempPt1.y), null, graphics, 0, dimmed);
                    this.offscreen.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size), new Point(this.tempPt1.x, this.tempPt1.y + size), null, graphics, 0, dimmed);
                    continue;
                }
                if (!(vb instanceof VectorCache.VectorText)) break block47;
                vt = (VectorCache.VectorText)vb;
                switch (vt.getTextType()) {
                    case 4: {
                        if (!PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC)) {
                            break;
                        }
                        ** GOTO lbl134
                    }
                    case 3: {
                        if (!PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) {
                            break;
                        }
                        ** GOTO lbl134
                    }
                    case 1: {
                        if (!PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL)) {
                            break;
                        }
                        ** GOTO lbl134
                    }
                    case 2: {
                        if (!PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT)) {
                            break;
                        }
                        ** GOTO lbl134
                    }
                    case 5: {
                        if (!PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ANNOTATION)) break;
                    }
lbl134:
                    // 6 sources

                    default: {
                        if (vt.getHeight() < this.maxTextSize || vt.isTempName() && !PixelDrawing.gp.isShowTempNames()) break;
                        drawString = vt.getString();
                        lX = vt.getCX();
                        lY = vt.getCY();
                        hX = lX + vt.getWid();
                        hY = lY + vt.getHei();
                        this.gridToScreen(lX + oX, hY + oY, this.tempPt1);
                        this.gridToScreen(hX + oX, lY + oY, this.tempPt2);
                        lX = this.tempPt1.x;
                        lY = this.tempPt1.y;
                        hX = this.tempPt2.x;
                        hY = this.tempPt2.y;
                        if (vt.getTextType() == 2 && vt.getBasePort() != null) {
                            if (!PixelDrawing.lv.isVisible(vt.getBasePort().getParent())) break;
                            graphics = PixelDrawing.textGraphics;
                            exportDisplayLevel = PixelDrawing.gp.exportDisplayLevel;
                            if (exportDisplayLevel == 2) {
                                cX = (int)((lX + hX) / 2L);
                                cY = (int)((lY + hY) / 2L);
                                size = 3;
                                this.offscreen.drawLine(new Point(cX - size, cY), new Point(cX + size, cY), null, graphics, 0, false);
                                this.offscreen.drawLine(new Point(cX, cY - size), new Point(cX, cY + size), null, graphics, 0, false);
                                ++this.crossCount;
                                break;
                            }
                            if (exportDisplayLevel == 1) {
                                drawString = Export.getShortName(drawString);
                            }
                            layerBitMap = null;
                        }
                        ++this.textCount;
                        this.tempRect.setBounds((int)lX, (int)lY, (int)(hX - lX), (int)(hY - lY));
                        this.offscreen.drawText(this.tempRect, vt.getStyle(), vt.getTextDescriptor(), drawString, layerBitMap, graphics, dimmed);
                        break;
                    }
                }
                continue;
            }
            if (vb instanceof VectorCache.VectorCircle) {
                ++this.circleCount;
                vci = (VectorCache.VectorCircle)vb;
                this.gridToScreen(vci.getCenterX() + oX, vci.getCenterY() + oY, this.tempPt1);
                this.gridToScreen(vci.getEdgeX() + oX, vci.getEdgeY() + oY, this.tempPt2);
                switch (vci.getNature()) {
                    case 0: {
                        this.offscreen.drawCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                        break;
                    }
                    case 1: {
                        this.offscreen.drawThickCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                        break;
                    }
                    case 2: {
                        this.offscreen.drawDisc(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                    }
                }
                continue;
            }
            if (!(vb instanceof VectorCache.VectorCircleArc)) continue;
            ++this.arcCount;
            vca = (VectorCache.VectorCircleArc)vb;
            this.gridToScreen(vca.getCenterX() + oX, vca.getCenterY() + oY, this.tempPt1);
            this.gridToScreen(vca.getEdge1X() + oX, vca.getEdge1Y() + oY, this.tempPt2);
            this.gridToScreen(vca.getEdge2X() + oX, vca.getEdge2Y() + oY, this.tempPt3);
            this.offscreen.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, vca.isThick(), vca.isBigArc(), layerBitMap, graphics, dimmed);
        }
    }

    private void drawPortList(VectorCache.VectorSubCell vsc, VectorCache.VectorCell subVC_, long oX, long oY, boolean expanded, boolean onPathDown) throws AbortRenderingException {
        if (!PixelDrawing.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT)) {
            return;
        }
        List<VectorCache.VectorCellExport> portShapes = subVC_.getCellDef().getPortShapes();
        int[] portCenters = subVC_.getPortCenters();
        assert (portShapes.size() * 2 == portCenters.length);
        for (int i = 0; i < portShapes.size(); ++i) {
            EGraphics portGraphics;
            VectorCache.VectorCellExport vce = portShapes.get(i);
            if (this.stopRendering) {
                throw new AbortRenderingException();
            }
            if (!onPathDown && vsc.isPortShown(vce.getChronIndex()) || vce.getHeight() < this.maxTextSize) continue;
            int cX = portCenters[i * 2];
            int cY = portCenters[i * 2 + 1];
            this.gridToScreen((long)cX + oX, (long)cY + oY, this.tempPt1);
            cX = this.tempPt1.x;
            cY = this.tempPt1.y;
            int portDisplayLevel = PixelDrawing.gp.portDisplayLevel;
            EGraphics eGraphics = portGraphics = expanded ? PixelDrawing.textGraphics : this.offscreen.getPortGraphics(vce.getBasePort());
            if (portDisplayLevel == 2) {
                int size = 3;
                this.offscreen.drawLine(new Point(cX - size, cY), new Point(cX + size, cY), null, portGraphics, 0, false);
                this.offscreen.drawLine(new Point(cX, cY - size), new Point(cX, cY + size), null, portGraphics, 0, false);
                ++this.crossCount;
                continue;
            }
            boolean shortName = portDisplayLevel == 1;
            String drawString = vce.getName(shortName);
            ++this.textCount;
            this.tempRect.setBounds(cX, cY, 0, 0);
            this.offscreen.drawText(this.tempRect, vce.getStyle().transformAnchorOfType(subVC_.getOrientation()), vce.getTextDescriptor(), drawString, null, portGraphics, false);
        }
    }

    private void gridToScreen(long dbX, long dbY, Point result) {
        double scrX = ((float)dbX - this.factorX) * this.scale_;
        double scrY = (this.factorY - (float)dbY) * this.scale_;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    void screenToGrid(long scrX, long scrY, Point result) {
        double dbX = (float)scrX / this.scale_ + this.factorX;
        double dbY = this.factorY - (float)scrY / this.scale_;
        result.x = (int)(dbX >= 0.0 ? dbX + 0.5 : dbX - 0.5);
        result.y = (int)(dbY >= 0.0 ? dbY + 0.5 : dbY - 0.5);
    }

    private void drawTinyBox(long lX, long hX, long lY, long hY, int col, VectorCache.VectorCell greekedCell) {
        if (lX < (long)this.screenLX) {
            lX = this.screenLX;
        }
        if (hX >= (long)this.screenHX) {
            hX = this.screenHX - 1;
        }
        if (lY < (long)this.screenLY) {
            lY = this.screenLY;
        }
        if (hY >= (long)this.screenHY) {
            hY = this.screenHY - 1;
        }
        if (this.useCellGreekingImages && greekedCell != null && greekedCell.getFadeColors() != null) {
            int backgroundColor = PixelDrawing.gp.getColor(User.ColorPrefType.BACKGROUND).getRGB();
            int backgroundRed = backgroundColor >> 16 & 0xFF;
            int backgroundGreen = backgroundColor >> 8 & 0xFF;
            int backgroundBlue = backgroundColor & 0xFF;
            int greekWid = greekedCell.getFadeImageWidth();
            int greekHei = greekedCell.getFadeImageHeight();
            long wid = hX - lX;
            long hei = hY - lY;
            float xInc = (float)greekWid / (float)wid;
            float yInc = (float)greekHei / (float)hei;
            float yPos = 0.0f;
            int y = 0;
            while ((long)y < hei) {
                float yEndPos = yPos + yInc;
                int yS = (int)yPos;
                int yE = (int)yEndPos;
                float xPos = 0.0f;
                int x = 0;
                while ((long)x < wid) {
                    float xEndPos = xPos + xInc;
                    int xS = (int)xPos;
                    int xE = (int)xEndPos;
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    float totalArea = 0.0f;
                    for (int yGrab = yS; yGrab <= yE; ++yGrab) {
                        if (yGrab >= greekHei) continue;
                        float yArea = 1.0f;
                        if (yGrab == yS) {
                            yArea = 1.0f - (yPos - (float)yS);
                        }
                        if (yGrab == yE) {
                            yArea *= yEndPos - (float)yE;
                        }
                        for (int xGrab = xS; xGrab <= xE; ++xGrab) {
                            if (xGrab >= greekWid) continue;
                            int index = xGrab + yGrab * greekedCell.getFadeImageWidth();
                            int[] colors = greekedCell.getFadeColors();
                            if (colors == null || index >= colors.length) continue;
                            int value = colors[index];
                            int red = value >> 16 & 0xFF;
                            int green = value >> 8 & 0xFF;
                            int blue = value & 0xFF;
                            float area = yArea;
                            if (xGrab == xS) {
                                area *= 1.0f - (xPos - (float)xS);
                            }
                            if (xGrab == xE) {
                                area *= xEndPos - (float)xE;
                            }
                            if (area <= 0.0f) continue;
                            r += (float)red * area;
                            g += (float)green * area;
                            b += (float)blue * area;
                            totalArea += area;
                        }
                    }
                    if (totalArea > 0.0f) {
                        int blue;
                        int green;
                        int red = (int)(r / totalArea);
                        if (red > 255) {
                            red = 255;
                        }
                        if ((green = (int)(g / totalArea)) > 255) {
                            green = 255;
                        }
                        if ((blue = (int)(b / totalArea)) > 255) {
                            blue = 255;
                        }
                        if (Math.abs(backgroundRed - red) > 2 || Math.abs(backgroundGreen - green) > 2 || Math.abs(backgroundBlue - blue) > 2) {
                            this.offscreen.drawPoint((int)(lX + (long)x), (int)(lY + (long)y), null, red << 16 | green << 8 | blue);
                        }
                    }
                    xPos = xEndPos;
                    ++x;
                }
                yPos = yEndPos;
                ++y;
            }
            return;
        }
        int y = (int)lY;
        while ((long)y <= hY) {
            int x = (int)lX;
            while ((long)x <= hX) {
                this.offscreen.drawPoint(x, y, null, col);
                ++x;
            }
            ++y;
        }
    }

    private boolean isContentsTiny(Cell cell, VectorCache.VectorCell vc, Orientation trans, VarContext context) throws AbortRenderingException {
        if (vc.getMaxFeatureSize() > this.objectGreekThreshold) {
            return false;
        }
        Iterator<VectorCache.VectorSubCell> sea = vc.getSubCellTree() == null ? vc.getSubCells().iterator() : new RTNode.Search<VectorCache.VectorSubCell>(vc.getSubCellTree());
        while (sea.hasNext()) {
            VectorCache.VectorSubCell vsc = sea.next();
            ImmutableNodeInst ini = vsc.getNode();
            boolean isExpanded = cell.isExpanded(ini.nodeId);
            VectorCache.VectorCell subVC = VectorCache.theCache.findVectorCell(vsc.getCellId(), vc.getOrientation().concatenate(ini.orient));
            if (isExpanded || this.fullInstantiate) {
                Orientation thisOrient = ini.orient;
                Orientation recurseTrans = trans.concatenate(thisOrient);
                VarContext subContext = context.push(cell, ini);
                Cell subCell = VectorCache.getCellFromId(vsc.getCellId());
                VectorCache.VectorCell subVC_ = this.drawCell(subCell, recurseTrans, subContext, false);
                assert (subVC_ == subVC);
                boolean subCellTiny = this.isContentsTiny(subCell, subVC, recurseTrans, subContext);
                if (subCellTiny) continue;
                return false;
            }
            if (!(subVC.getCellDef().getMinimumSize() > this.objectGreekThreshold)) continue;
            return false;
        }
        return true;
    }

    private void makeGreekedImage(VectorCache.VectorCell subVC, LayerVisibility lv) throws AbortRenderingException {
        if (subVC.isFadeImage()) {
            return;
        }
        if (!this.useCellGreekingImages) {
            return;
        }
        ERectangle cellBounds = subVC.getCellDef().getBounds();
        Rectangle2D.Double ownBounds = new Rectangle2D.Double(((RectangularShape)cellBounds).getMinX(), ((RectangularShape)cellBounds).getMinY(), ((RectangularShape)cellBounds).getWidth(), ((RectangularShape)cellBounds).getHeight());
        FixpTransform trans = subVC.getOrientation().rotateAbout(0.0, 0.0);
        DBMath.transformRect(ownBounds, trans);
        double greekScale = 25.0 / ((RectangularShape)ownBounds).getHeight();
        if (((RectangularShape)ownBounds).getWidth() > ((RectangularShape)ownBounds).getHeight()) {
            greekScale = 25.0 / ((RectangularShape)ownBounds).getWidth();
        }
        int lX = (int)Math.floor(((RectangularShape)cellBounds).getMinX() * greekScale);
        int hX = (int)Math.ceil(((RectangularShape)cellBounds).getMaxX() * greekScale);
        int lY = (int)Math.floor(((RectangularShape)cellBounds).getMinY() * greekScale);
        int hY = (int)Math.ceil(((RectangularShape)cellBounds).getMaxY() * greekScale);
        if (hX <= lX) {
            hX = lX + 1;
        }
        int greekWid = hX - lX;
        if (hY <= lY) {
            hY = lY + 1;
        }
        int greekHei = hY - lY;
        Rectangle screenBounds = new Rectangle(lX, lY, greekWid, greekHei);
        PixelDrawing offscreen = new PixelDrawing(greekScale, screenBounds);
        Point2D.Double cellCtr = new Point2D.Double(ownBounds.getCenterX(), ownBounds.getCenterY());
        VectorDrawing subVD = new VectorDrawing(this.useCellGreekingImages);
        subVC.setFadeOffset(debugXP, debugYP);
        if (topVD != null && (debugXP += 30) + 25 + 2 >= VectorDrawing.topVD.offscreen.getSize().width) {
            debugXP = 0;
            debugYP += 30;
        }
        subVD.offscreen = offscreen;
        subVD.screenLX = 0;
        subVD.screenHX = greekWid;
        subVD.screenLY = 0;
        subVD.screenHY = greekHei;
        subVD.szHalfWidth = greekWid / 2;
        subVD.szHalfHeight = greekHei / 2;
        subVD.objectGreekThreshold = 0.0f;
        subVD.objectVisibleThreshold = 0.0f;
        subVD.maxTextSize = 0.0f;
        subVD.scale = (float)greekScale;
        subVD.scale_ = (float)(greekScale / 400.0);
        subVD.factorX = (float)(((Point2D)cellCtr).getX() * 400.0 - (double)((float)subVD.szHalfWidth / subVD.scale_));
        subVD.factorY = (float)(((Point2D)cellCtr).getY() * 400.0 + (double)((float)subVD.szHalfHeight / subVD.scale_));
        subVD.factorX_ = (int)subVD.factorX;
        subVD.factorY_ = (int)subVD.factorY;
        subVD.scale_int = (int)(subVD.scale_ * 1048576.0f);
        subVD.fullInstantiate = true;
        subVD.takingLongTime = true;
        subVD.offscreen.clearImage(null, null);
        subVD.render(subVC, 0L, 0L, VarContext.globalContext, -1, lv);
        subVD.offscreen.composite(null);
        int[] img = offscreen.getOpaqueData();
        subVC.setFadeImageSize(greekWid, greekHei);
        int[] colors = new int[greekWid * greekHei];
        int i = 0;
        for (int y = 0; y < greekHei; ++y) {
            for (int x = 0; x < greekWid; ++x) {
                int value = img[i];
                colors[i++] = value & 0xFFFFFF;
            }
        }
        subVC.setFadeColors(colors);
        subVC.setFadeImage(true);
    }

    private int getFadeColor(VectorCache.VectorCell vc, VarContext context, LayerVisibility lv) throws AbortRenderingException {
        if (vc.hasFadeColor()) {
            return vc.getFadeColor();
        }
        HashMap<Layer, MutableDouble> layerAreas = new HashMap<Layer, MutableDouble>();
        this.gatherContents(vc, layerAreas, context);
        Set keys = layerAreas.keySet();
        double totalArea = 0.0;
        for (Layer layer : keys) {
            if (!lv.isVisible(layer)) continue;
            MutableDouble md = (MutableDouble)layerAreas.get(layer);
            totalArea += md.doubleValue();
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (totalArea == 0.0) {
            vc.setFadeColor(PixelDrawing.gp.getColor(User.ColorPrefType.BACKGROUND).getRGB());
        } else {
            for (Layer layer : keys) {
                if (!lv.isVisible(layer)) continue;
                MutableDouble md = (MutableDouble)layerAreas.get(layer);
                double portion = md.doubleValue() / totalArea;
                EGraphics desc = PixelDrawing.gp.getGraphics(layer);
                Color col = desc.getColor();
                r += (double)col.getRed() * portion;
                g += (double)col.getGreen() * portion;
                b += (double)col.getBlue() * portion;
            }
            if (r < 0.0) {
                r = 0.0;
            }
            if (r > 255.0) {
                r = 255.0;
            }
            if (g < 0.0) {
                g = 0.0;
            }
            if (g > 255.0) {
                g = 255.0;
            }
            if (b < 0.0) {
                b = 0.0;
            }
            if (b > 255.0) {
                b = 255.0;
            }
            vc.setFadeColor((int)r << 16 | (int)g << 8 | (int)b);
        }
        vc.setHasFadeColor(true);
        return vc.getFadeColor();
    }

    private void gatherContents(VectorCache.VectorCell vc, Map<Layer, MutableDouble> layerAreas, VarContext context) throws AbortRenderingException {
        List<Layer> knownLayers = vc.getKnownLayers();
        for (Layer layer : knownLayers) {
            Layer.Function fun;
            if (layer == null || (fun = layer.getFunction()).isImplant() || fun.isSubstrate()) continue;
            List<VectorCache.VectorBase> shapesOnLayer = vc.getShapes(layer);
            for (VectorCache.VectorBase vb : shapesOnLayer) {
                double area = 0.0;
                if (vb instanceof VectorCache.VectorManhattan) {
                    VectorCache.VectorManhattan vm = (VectorCache.VectorManhattan)vb;
                    long[] coords = vm.getCoords();
                    for (int i = 0; i < coords.length; i += 4) {
                        double c1X = coords[i];
                        double c1Y = coords[i + 1];
                        double c2X = coords[i + 2];
                        double c2Y = coords[i + 3];
                        area += (c1X - c2X) * (c1Y - c2Y);
                    }
                } else if (vb instanceof VectorCache.VectorPolygon) {
                    VectorCache.VectorPolygon vp = (VectorCache.VectorPolygon)vb;
                    area = GenMath.getAreaOfPoints(vp.getPoints());
                } else if (vb instanceof VectorCache.VectorCircle) {
                    VectorCache.VectorCircle vci = (VectorCache.VectorCircle)vb;
                    double radius = new Point2D.Double(vci.getCenterX(), vci.getCenterY()).distance(new Point2D.Double(vci.getEdgeX(), vci.getEdgeY()));
                    area = radius * radius * Math.PI;
                }
                if (area == 0.0) continue;
                MutableDouble md = layerAreas.get(layer);
                if (md == null) {
                    md = new MutableDouble(0.0);
                    layerAreas.put(layer, md);
                }
                md.setValue(md.doubleValue() + area);
            }
        }
        Cell cell = VectorCache.getCellFromId(vc.getCellDef().getCellId());
        Iterator<VectorCache.VectorSubCell> sea = vc.getSubCellTree() == null ? vc.getSubCells().iterator() : new RTNode.Search<VectorCache.VectorSubCell>(vc.getSubCellTree());
        while (sea.hasNext()) {
            VectorCache.VectorSubCell vsc = sea.next();
            VectorCache.VectorCellDef vcd = VectorCache.theCache.findCellGroup(vsc.getCellId());
            VectorCache.VectorCell subVC = vcd.getAnyCell();
            ImmutableNodeInst ini = vsc.getNode();
            VarContext subContext = context.push(cell, ini);
            if (subVC == null) {
                Cell nodeProto = VectorCache.getCellFromId((CellId)ini.protoId);
                subVC = this.drawCell(nodeProto, Orientation.IDENT, subContext, false);
            }
            this.gatherContents(subVC, layerAreas, subContext);
        }
    }

    private VectorCache.VectorCell drawCell(Cell cell, Orientation prevTrans, VarContext context, boolean makeTopLevel) throws AbortRenderingException {
        if (this.stopRendering) {
            throw new AbortRenderingException();
        }
        if (!this.takingLongTime && this.timer.currentTimeLong() > 1000L) {
            System.out.print("Display caching, please wait...");
            TopLevel.setBusyCursor(true);
            this.takingLongTime = true;
        }
        return VectorCache.theCache.drawCell(cell.getId(), prevTrans, context, this.scale, makeTopLevel);
    }

    class AbortRenderingException
    extends Exception {
        AbortRenderingException() {
        }
    }
}

