/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected1.PlacementForceDirectedTeam5;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import com.sun.electric.tool.placement.genetic2.PlacementGenetic;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import com.sun.electric.tool.placement.simulatedAnnealing2.PlacementSimulatedAnnealing;
import com.sun.electric.util.CollectionFactory;
import java.util.Map;

public abstract class PlacementParameterSetter {
    public static Map<String, PlacementParameterSetter> algorithmMapping = CollectionFactory.createHashMap();

    public abstract void setParameter(Placement.PlacementPreferences var1, int var2, int var3, PlacementFrame var4, boolean var5);

    private static void makeTempValuesReal(Placement.PlacementPreferences prefs, PlacementFrame.PlacementParameter param, int value, boolean regression) {
        prefs.setParameter(param, value);
    }

    static {
        algorithmMapping.put("Simulated-Annealing-1", new SimulatedAnnealing1Setter());
        algorithmMapping.put("Simulated-Annealing-2", new SimulatedAnnealing2Setter());
        algorithmMapping.put("Genetic-1", new Genetic1Setter());
        algorithmMapping.put("Genetic-2", new Genetic2Setter());
        algorithmMapping.put("Force-Directed-1", new ForceDirected1Setter());
        algorithmMapping.put("Force-Directed-2", new ForceDirected2Setter());
    }

    public static class SimulatedAnnealing1Setter
    extends PlacementParameterSetter {
        @Override
        public void setParameter(Placement.PlacementPreferences prefs, int numOfThreads, int runtime, PlacementFrame placement, boolean regression) {
            SimulatedAnnealing tool = (SimulatedAnnealing)placement;
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxThreadsParam, numOfThreads, regression);
        }
    }

    public static class SimulatedAnnealing2Setter
    extends PlacementParameterSetter {
        @Override
        public void setParameter(Placement.PlacementPreferences prefs, int numOfThreads, int runtime, PlacementFrame placement, boolean regression) {
            PlacementSimulatedAnnealing tool = (PlacementSimulatedAnnealing)placement;
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.numThreadsParam, numOfThreads, regression);
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxRuntimeParam, runtime, regression);
        }
    }

    public static class Genetic1Setter
    extends PlacementParameterSetter {
        @Override
        public void setParameter(Placement.PlacementPreferences prefs, int numOfThreads, int runtime, PlacementFrame placement, boolean regression) {
            GeneticPlacement tool = (GeneticPlacement)placement;
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxThreadsParam, numOfThreads, regression);
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxRuntimeParam, runtime, regression);
        }
    }

    public static class Genetic2Setter
    extends PlacementParameterSetter {
        @Override
        public void setParameter(Placement.PlacementPreferences prefs, int numOfThreads, int runtime, PlacementFrame placement, boolean regression) {
            PlacementGenetic tool = (PlacementGenetic)placement;
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxThreadsParam, numOfThreads, regression);
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxRuntimeParam, runtime, regression);
        }
    }

    public static class ForceDirected1Setter
    extends PlacementParameterSetter {
        @Override
        public void setParameter(Placement.PlacementPreferences prefs, int numOfThreads, int runtime, PlacementFrame placement, boolean regression) {
            PlacementForceDirectedTeam5 tool = (PlacementForceDirectedTeam5)placement;
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxThreadsParam, numOfThreads, regression);
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxRuntimeParam, runtime, regression);
        }
    }

    public static class ForceDirected2Setter
    extends PlacementParameterSetter {
        @Override
        public void setParameter(Placement.PlacementPreferences prefs, int numOfThreads, int runtime, PlacementFrame placement, boolean regression) {
            PlacementForceDirectedStaged tool = (PlacementForceDirectedStaged)placement;
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxThreadsParam, numOfThreads, regression);
            PlacementParameterSetter.makeTempValuesReal(prefs, tool.maxRuntimeParam, runtime, regression);
        }
    }
}

