/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.IntSequence;
import gnu.lists.IntVector;
import gnu.lists.Sequences;
import gnu.math.UInt;

public class U32Vector
extends IntVector<UInt> {
    public U32Vector() {
        this.data = empty;
    }

    public U32Vector(int size, int value) {
        int[] array = new int[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public U32Vector(int size) {
        this(new int[size]);
    }

    public U32Vector(int[] data) {
        this.data = data;
    }

    public U32Vector(int[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public U32Vector(int[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final long longAtBuffer(int index) {
        return (long)this.data[index] & 0xFFFFFFFFL;
    }

    @Override
    public final UInt get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return UInt.valueOf(this.data[index]);
    }

    @Override
    public final UInt getBuffer(int index) {
        return UInt.valueOf(this.data[index]);
    }

    @Override
    public final void setBuffer(int index, UInt value) {
        this.data[index] = value.intValue();
    }

    protected U32Vector withIndexes(IntSequence ind) {
        return new U32Vector(this.data, ind);
    }

    @Override
    public U32Vector subList(int fromIx, int toIx) {
        return new U32Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 21;
    }

    @Override
    public String getTag() {
        return "u32";
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = this.nextIndex(iposEnd);
        for (int i = this.nextIndex(iposStart); i < end; ++i) {
            Sequences.writeUInt(this.intAt(i), out);
        }
    }

    public int compareTo(Object obj) {
        return U32Vector.compareToInt(this, (U32Vector)obj);
    }
}

