/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** Commercial Usage
**
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://qt.nokia.com/contact.
**
**************************************************************************/

#include <QtCore/QtDebug>
#include <string.h>
#include "javascriptengine_p.h"
#include "javascriptlexer_p.h"
#include "javascriptast_p.h"
#include "javascriptnodepool_p.h"

#define J_SCRIPT_UPDATE_POSITION(node, startloc, endloc) do { \
    node->startLine = startloc.startLine; \
    node->startColumn = startloc.startColumn; \
    node->endLine = endloc.endLine; \
    node->endColumn = endloc.endColumn; \
} while (0)



#include "javascriptparser_p.h"

//
// This file is automatically generated from javascript.g.
// Changes will be lost.
//

QT_BEGIN_NAMESPACE

inline static bool automatic(JavaScriptEnginePrivate *driver, int token)
{
    return token == JavaScriptGrammar::T_RBRACE
        || token == 0
        || driver->lexer()->prevTerminator();
}


JavaScriptParser::JavaScriptParser():
    tos(0),
    stack_size(0),
    sym_stack(0),
    state_stack(0),
    location_stack(0),
    first_token(0),
    last_token(0)
{
}

JavaScriptParser::~JavaScriptParser()
{
    if (stack_size) {
        qFree(sym_stack);
        qFree(state_stack);
        qFree(location_stack);
    }
}

static inline JavaScriptParser::Location location(JavaScript::Lexer *lexer)
{
    JavaScriptParser::Location loc;
    loc.startLine = lexer->startLineNo();
    loc.startColumn = lexer->startColumnNo();
    loc.endLine = lexer->endLineNo();
    loc.endColumn = lexer->endColumnNo();
    return loc;
}

bool JavaScriptParser::parse(JavaScriptEnginePrivate *driver)
{
    JavaScript::Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    int yytoken = -1;
    int action = 0;

    first_token = last_token = 0;

    tos = -1;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
                yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->dval();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yylloc = first_token->loc;
                ++first_token;
            }
        }

        action = t_action(action, yytoken);
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yytoken = -1;
                sym(1).dval = yylval;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

          switch (r) {

case 0: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ThisExpression> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 1: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::IdentifierExpression> (driver->nodePool(), sym(1).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 2: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::NullExpression> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 3: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::TrueLiteral> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 4: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FalseLiteral> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 5: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::NumericLiteral> (driver->nodePool(), sym(1).dval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 6: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::StringLiteral> (driver->nodePool(), sym(1).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 7: {
  bool rx = lexer->scanRegExp(JavaScript::Lexer::NoPrefix);
  if (!rx) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, lexer->startLineNo(),
        lexer->startColumnNo(), lexer->errorMessage()));
      return false;
  }
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::RegExpLiteral> (driver->nodePool(), lexer->pattern, lexer->flags);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 8: {
  bool rx = lexer->scanRegExp(JavaScript::Lexer::EqualPrefix);
  if (!rx) {
    diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error, lexer->startLineNo(),
        lexer->startColumnNo(), lexer->errorMessage()));
      return false;
  }
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::RegExpLiteral> (driver->nodePool(), lexer->pattern, lexer->flags);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 9: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArrayLiteral> (driver->nodePool(), sym(2).Elision);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 10: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArrayLiteral> (driver->nodePool(), sym(2).ElementList->finish ());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 11: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArrayLiteral> (driver->nodePool(), sym(2).ElementList->finish (), sym(4).Elision);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 12: {
  if (sym(2).Node)
    sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ObjectLiteral> (driver->nodePool(), sym(2).PropertyNameAndValueList->finish ());
  else
    sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ObjectLiteral> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 13: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ObjectLiteral> (driver->nodePool(), sym(2).PropertyNameAndValueList->finish ());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 14: {
  sym(1) = sym(2);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 15: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ElementList> (driver->nodePool(), sym(1).Elision, sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 16: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ElementList> (driver->nodePool(), sym(1).ElementList, sym(3).Elision, sym(4).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 17: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Elision> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 18: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Elision> (driver->nodePool(), sym(1).Elision);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 19: {
  sym(1).Node = 0;
} break;

case 20: {
  sym(1).Elision = sym(1).Elision->finish ();
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 21: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::PropertyNameAndValueList> (driver->nodePool(), sym(1).PropertyName, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 22: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::PropertyNameAndValueList> (driver->nodePool(), sym(1).PropertyNameAndValueList, sym(3).PropertyName, sym(5).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 23: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::IdentifierPropertyName> (driver->nodePool(), sym(1).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 24: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::StringLiteralPropertyName> (driver->nodePool(), sym(1).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 25: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::NumericLiteralPropertyName> (driver->nodePool(), sym(1).dval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 26: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::IdentifierPropertyName> (driver->nodePool(), sym(1).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 27:

case 28:

case 29:

case 30:

case 31:

case 32:

case 33:

case 34:

case 35:

case 36:

case 37:

case 38:

case 39:

case 40:

case 41:

case 42:

case 43:

case 44:

case 45:

case 46:

case 47:

case 48:

case 49:

case 50:

case 51:

case 52:

case 53:

case 54:

case 55:

case 56:

case 57:
{
  sym(1).sval = driver->intern(lexer->characterBuffer(), lexer->characterCount());
} break;

case 62: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArrayMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 63: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FieldMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 64: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::NewMemberExpression> (driver->nodePool(), sym(2).Expression, sym(3).ArgumentList);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 66: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::NewExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 67: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CallExpression> (driver->nodePool(), sym(1).Expression, sym(2).ArgumentList);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 68: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CallExpression> (driver->nodePool(), sym(1).Expression, sym(2).ArgumentList);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 69: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArrayMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 70: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FieldMemberExpression> (driver->nodePool(), sym(1).Expression, sym(3).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 71: {
  sym(1).Node = 0;
} break;

case 72: {
  sym(1).Node = sym(2).ArgumentList->finish ();
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 73: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArgumentList> (driver->nodePool(), sym(1).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 74: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ArgumentList> (driver->nodePool(), sym(1).ArgumentList, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 78: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::PostIncrementExpression> (driver->nodePool(), sym(1).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 79: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::PostDecrementExpression> (driver->nodePool(), sym(1).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 81: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::DeleteExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 82: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VoidExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 83: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::TypeOfExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 84: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::PreIncrementExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 85: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::PreDecrementExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 86: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::UnaryPlusExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 87: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::UnaryMinusExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 88: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::TildeExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 89: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::NotExpression> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 91: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Mul, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 92: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Div, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 93: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Mod, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 95: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Add, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 96: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Sub, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 98: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::LShift, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 99: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::RShift, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 100: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::URShift, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 102: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Lt, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 103: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Gt, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 104: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Le, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 105: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Ge, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 106: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::InstanceOf, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 107: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::In, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 109: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Lt, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 110: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Gt, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 111: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Le, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 112: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Ge, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 113: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::InstanceOf, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 115: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Equal, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 116: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::NotEqual, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 117: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::StrictEqual, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 118: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::StrictNotEqual, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 120: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Equal, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 121: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::NotEqual, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 122: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::StrictEqual, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 123: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::StrictNotEqual, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 125: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 127: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 129: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 131: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 133: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 135: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 137: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::And, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 139: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::And, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 141: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Or, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 143: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, QSOperator::Or, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 145: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ConditionalExpression> (driver->nodePool(), sym(1).Expression, sym(3).Expression, sym(5).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 147: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ConditionalExpression> (driver->nodePool(), sym(1).Expression, sym(3).Expression, sym(5).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 149: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, sym(2).ival, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 151: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BinaryExpression> (driver->nodePool(), sym(1).Expression, sym(2).ival, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 152: {
  sym(1).ival = QSOperator::Assign;
} break;

case 153: {
  sym(1).ival = QSOperator::InplaceMul;
} break;

case 154: {
  sym(1).ival = QSOperator::InplaceDiv;
} break;

case 155: {
  sym(1).ival = QSOperator::InplaceMod;
} break;

case 156: {
  sym(1).ival = QSOperator::InplaceAdd;
} break;

case 157: {
  sym(1).ival = QSOperator::InplaceSub;
} break;

case 158: {
  sym(1).ival = QSOperator::InplaceLeftShift;
} break;

case 159: {
  sym(1).ival = QSOperator::InplaceRightShift;
} break;

case 160: {
  sym(1).ival = QSOperator::InplaceURightShift;
} break;

case 161: {
  sym(1).ival = QSOperator::InplaceAnd;
} break;

case 162: {
  sym(1).ival = QSOperator::InplaceXor;
} break;

case 163: {
  sym(1).ival = QSOperator::InplaceOr;
} break;

case 165: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Expression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 166: {
  sym(1).Node = 0;
} break;

case 169: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Expression> (driver->nodePool(), sym(1).Expression, sym(3).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 170: {
  sym(1).Node = 0;
} break;

case 187: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Block> (driver->nodePool(), sym(2).StatementList);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 188: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::StatementList> (driver->nodePool(), sym(1).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 189: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::StatementList> (driver->nodePool(), sym(1).StatementList, sym(2).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 190: {
  sym(1).Node = 0;
} break;

case 191: {
  sym(1).Node = sym(1).StatementList->finish ();
} break;

case 193: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableStatement> (driver->nodePool(), sym(2).VariableDeclarationList->finish (/*readOnly=*/sym(1).ival == T_CONST));
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 194: {
  sym(1).ival = T_CONST;
} break;

case 195: {
  sym(1).ival = T_VAR;
} break;

case 196: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclaration);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 197: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclarationList, sym(3).VariableDeclaration);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 198: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclaration);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 199: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableDeclarationList> (driver->nodePool(), sym(1).VariableDeclarationList, sym(3).VariableDeclaration);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 200: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableDeclaration> (driver->nodePool(), sym(1).sval, sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 201: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::VariableDeclaration> (driver->nodePool(), sym(1).sval, sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 202: {
  sym(1) = sym(2);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 203: {
  sym(1).Node = 0;
} break;

case 205: {
  sym(1) = sym(2);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 206: {
  sym(1).Node = 0;
} break;

case 208: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::EmptyStatement> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 210: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ExpressionStatement> (driver->nodePool(), sym(1).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 211: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::IfStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement, sym(7).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(7));
} break;

case 212: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::IfStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 214: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::DoWhileStatement> (driver->nodePool(), sym(2).Statement, sym(5).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(7));
} break;

case 215: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::WhileStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 216: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ForStatement> (driver->nodePool(), sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(9));
} break;

case 217: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::LocalForStatement> (driver->nodePool(), sym(4).VariableDeclarationList->finish (/*readOnly=*/false), sym(6).Expression, sym(8).Expression, sym(10).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(10));
} break;

case 218: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ForEachStatement> (driver->nodePool(), sym(3).Expression, sym(5).Expression, sym(7).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(7));
} break;

case 219: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::LocalForEachStatement> (driver->nodePool(), sym(4).VariableDeclaration, sym(6).Expression, sym(8).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(8));
} break;

case 221: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ContinueStatement> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 223: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ContinueStatement> (driver->nodePool(), sym(2).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 225: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BreakStatement> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 227: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::BreakStatement> (driver->nodePool(), sym(2).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 229: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ReturnStatement> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 230: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::WithStatement> (driver->nodePool(), sym(3).Expression, sym(5).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 231: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::SwitchStatement> (driver->nodePool(), sym(3).Expression, sym(5).CaseBlock);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 232: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CaseBlock> (driver->nodePool(), sym(2).CaseClauses);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 233: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CaseBlock> (driver->nodePool(), sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 234: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CaseClauses> (driver->nodePool(), sym(1).CaseClause);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 235: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CaseClauses> (driver->nodePool(), sym(1).CaseClauses, sym(2).CaseClause);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 236: {
  sym(1).Node = 0;
} break;

case 237: {
  sym(1).Node = sym(1).CaseClauses->finish ();
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 238: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::CaseClause> (driver->nodePool(), sym(2).Expression, sym(4).StatementList);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 239: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::DefaultClause> (driver->nodePool(), sym(3).StatementList);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 240: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::LabelledStatement> (driver->nodePool(), sym(1).sval, sym(3).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 242: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::ThrowStatement> (driver->nodePool(), sym(2).Expression);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 243: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::TryStatement> (driver->nodePool(), sym(2).Statement, sym(3).Catch);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 244: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::TryStatement> (driver->nodePool(), sym(2).Statement, sym(3).Finally);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 245: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::TryStatement> (driver->nodePool(), sym(2).Statement, sym(3).Catch, sym(4).Finally);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(4));
} break;

case 246: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Catch> (driver->nodePool(), sym(3).sval, sym(5).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(5));
} break;

case 247: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Finally> (driver->nodePool(), sym(2).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 249: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::DebuggerStatement> (driver->nodePool());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 250: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FunctionDeclaration> (driver->nodePool(), sym(2).sval, sym(4).FormalParameterList, sym(7).FunctionBody);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(8));
} break;

case 251: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FunctionExpression> (driver->nodePool(), sym(2).sval, sym(4).FormalParameterList, sym(7).FunctionBody);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(8));
} break;

case 252: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FormalParameterList> (driver->nodePool(), sym(1).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 253: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FormalParameterList> (driver->nodePool(), sym(1).FormalParameterList, sym(3).sval);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(3));
} break;

case 254: {
  sym(1).Node = 0;
} break;

case 255: {
  sym(1).Node = sym(1).FormalParameterList->finish ();
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 256: {
  sym(1).Node = 0;
} break;

case 258: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FunctionBody> (driver->nodePool(), sym(1).SourceElements->finish ());
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 259: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::Program> (driver->nodePool(), sym(1).SourceElements->finish ());
  driver->changeAbstractSyntaxTree(sym(1).Node);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 260: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::SourceElements> (driver->nodePool(), sym(1).SourceElement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 261: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::SourceElements> (driver->nodePool(), sym(1).SourceElements, sym(2).SourceElement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(2));
} break;

case 262: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::StatementSourceElement> (driver->nodePool(), sym(1).Statement);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 263: {
  sym(1).Node = JavaScript::makeAstNode<JavaScript::AST::FunctionSourceElement> (driver->nodePool(), sym(1).FunctionDeclaration);
  J_SCRIPT_UPDATE_POSITION(sym(1).Node, loc(1), loc(1));
} break;

case 264: {
  sym(1).sval = 0;
} break;

case 266: {
  sym(1).Node = 0;
} break;

            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of `;'
        if (t_action(errorState, T_AUTOMATIC_SEMICOLON) && automatic(driver, yytoken)) {
            SavedToken &tk = token_buffer[0];
            tk.token = yytoken;
            tk.dval = yylval;
            tk.loc = yylloc;

            const QString msg = QString::fromUtf8("Missing `;'");

            diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Warning,
                yyprevlloc.startLine, yyprevlloc.startColumn, msg));

            first_token = &token_buffer[0];
            last_token = &token_buffer[1];

            yytoken = T_SEMICOLON;
            yylval = 0;

            action = errorState;

            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken = lexer->lex();
        token_buffer[1].dval  = yylval  = lexer->dval();
        token_buffer[1].loc   = yylloc  = location(lexer);

        if (token_buffer[0].token != -1 && t_action(errorState, yytoken)) {
            QString msg = QString::fromUtf8("Removed token");
            if (const char *tokenSpell = spell[token_buffer[0].token]) {
                msg += QLatin1String(": `");
                msg += QLatin1String(tokenSpell);
                msg += QLatin1Char('\'');
            }

            diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error,
                token_buffer[0].loc.startLine, token_buffer[0].loc.startColumn, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
                QString msg = QString::fromUtf8("Inserted token");
                if (const char *tokenSpell = spell[*tk]) {
                    msg += QLatin1String(": `");
                    msg += QLatin1String(tokenSpell);
                    msg += QLatin1Char('\'');
                }

                diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error,
                    token_buffer[0].loc.startLine, token_buffer[0].loc.startColumn, msg));

                yytoken = *tk;
                yylval = 0;
                yylloc = token_buffer[0].loc;

                first_token = &token_buffer[0];
                last_token = &token_buffer[2];

                action = errorState;
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                QString msg = QString::fromUtf8("Inserted token");
                if (const char *tokenSpell = spell[tk]) {
                    msg += QLatin1String(": `");
                    msg += QLatin1String(tokenSpell);
                    msg += QLatin1Char('\'');
                }

                diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error,
                    token_buffer[0].loc.startLine, token_buffer[0].loc.startColumn, msg));

                yytoken = tk;
                yylval = 0;
                yylloc = token_buffer[0].loc;

                action = errorState;
                goto _Lcheck_token;
            }
        }

        QString msg = QString::fromUtf8("Unexpected token");
        if (const char *tokenSpell = spell[token_buffer[0].token]) {
            msg += QLatin1String(": `");
            msg += QLatin1String(tokenSpell);
            msg += QLatin1Char('\'');
        }

        diagnostic_messages.append(DiagnosticMessage(DiagnosticMessage::Error,
            token_buffer[0].loc.startLine, token_buffer[0].loc.startColumn, msg));
    }

    return false;
}

QT_END_NAMESPACE


