/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#ifndef QMAKEKITINFORMATION_H
#define QMAKEKITINFORMATION_H

#include "qmakeprojectmanager_global.h"

#include <projectexplorer/kitmanager.h>

namespace QmakeProjectManager {

class QMAKEPROJECTMANAGER_EXPORT QmakeKitInformation : public ProjectExplorer::KitInformation
{
    Q_OBJECT

public:
    QmakeKitInformation();

    QVariant defaultValue(const ProjectExplorer::Kit *k) const override;

    QList<ProjectExplorer::Task> validate(const ProjectExplorer::Kit *k) const override;
    void setup(ProjectExplorer::Kit *k) override;

    ProjectExplorer::KitConfigWidget *createConfigWidget(ProjectExplorer::Kit *k) const override;

    ItemList toUserOutput(const ProjectExplorer::Kit *k) const override;

    static Core::Id id();
    static void setMkspec(ProjectExplorer::Kit *k, const Utils::FileName &fn);
    static Utils::FileName mkspec(const ProjectExplorer::Kit *k);
    static Utils::FileName effectiveMkspec(const ProjectExplorer::Kit *k);
    static Utils::FileName defaultMkspec(const ProjectExplorer::Kit *k);
};

} // namespace QmakeProjectManager

#endif // QMAKEKITINFORMATION_H
