import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: buttonMid
    width: 100
    height: 100
    color: "transparent"
    property alias labelText: label.text

    Rectangle {
        id: hole
        color: "#181614"
        radius: 3
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
    }

    Rectangle {
        id: button
        radius: 9
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 3
        anchors.rightMargin: 4
        anchors.topMargin: 2
        anchors.bottomMargin: 2
        gradient: Gradient {
            id: button_Gradient
            GradientStop {
                id: button_GradientStop_0
                position: 0
                color: "#ff4c4c4c"
            }

            GradientStop {
                id: button_GradientStop_1
                position: 1
                color: "#ff4b4b4b"
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: button_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: button_DesignDropShadow_0
                    visible: true
                    color: "#6e000000"
                    spread: 0
                    offsetY: 11
                    offsetX: 8
                    blur: 18
                },
                DesignInnerShadow {
                    id: button_DesignInnerShadow_1
                    visible: true
                    color: "#7a000000"
                    spread: 0
                    offsetY: -2
                    offsetX: -2
                    blur: 3
                },
                DesignInnerShadow {
                    id: button_DesignInnerShadow_2
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 2
                    blur: 3
                }
            ]
        }
    }

    Text {
        id: label
        color: "#d6d6d6"
        text: qsTr("A")
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 13
        anchors.rightMargin: 23
        anchors.topMargin: 2
        anchors.bottomMargin: 39
        font.pixelSize: 31
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        font.weight: Font.Bold
        font.family: "DIN Alternate"
        DesignEffect {
            id: label_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"aaa8c3ed-eff8-5987-b702-24fbd33bd576"}D{i:1;uuid:"db4232b5-e1fd-5983-ac3c-4980014cd47c"}
D{i:2;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831"}D{i:6;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_DesignEffect"}
D{i:7;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_DesignDropShadow_0"}D{i:8;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_DesignInnerShadow_1"}
D{i:9;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_DesignInnerShadow_2"}D{i:3;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_Gradient"}
D{i:4;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_GradientStop_0"}D{i:5;uuid:"2fcb7cce-15b9-58ba-a53e-3f37bd4a2831_GradientStop_1"}
D{i:10;uuid:"e5e0a9af-58eb-58cf-bd00-bb2a51699bbe"}D{i:11;uuid:"e5e0a9af-58eb-58cf-bd00-bb2a51699bbe_DesignEffect"}
}
##^##*/

