import QtQuick
import QtQuick.Controls
import QtQuick.Studio.Components 1.0
import QtQuick.Shapes 1.0
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: dialWhite
    width: 100
    height: 100
    color: "transparent"

    ArcItem {
        id: dialBottom
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#dedad7"
        end: 450.00001
        DesignEffect {
            id: dialBottom_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: dialBottom_DesignDropShadow_0
                    visible: true
                    color: "#47000000"
                    spread: 0
                    offsetY: 4
                    offsetX: 2
                    blur: 4
                },
                DesignInnerShadow {
                    id: dialBottom_DesignInnerShadow_1
                    visible: true
                    color: "#94ffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 1
                    blur: 3
                }
            ]
        }
        begin: 90
        arcWidth: 50
        antialiasing: true
    }

    ArcItem {
        id: dialTop
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 26
        anchors.rightMargin: 24
        anchors.topMargin: 26
        anchors.bottomMargin: 24
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#e5e5e5"
        end: 450.00001
        DesignEffect {
            id: dialTop_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: dialTop_DesignDropShadow_0
                    visible: true
                    color: "#59000000"
                    spread: 0
                    offsetY: 28
                    offsetX: 18
                    blur: 18.3
                },
                DesignDropShadow {
                    id: dialTop_DesignDropShadow_1
                    visible: true
                    color: "#61525252"
                    spread: 0
                    offsetY: 1
                    offsetX: 1
                    blur: 2
                },
                DesignInnerShadow {
                    id: dialTop_DesignInnerShadow_2
                    visible: true
                    color: "#6b000000"
                    spread: 0
                    offsetY: -2
                    offsetX: -1
                    blur: 2
                },
                DesignInnerShadow {
                    id: dialTop_DesignInnerShadow_3
                    visible: true
                    color: "#99ffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 2
                    blur: 2
                }
            ]
        }
        begin: 90
        arcWidth: 25
        antialiasing: true
    }
}

/*##^##
Designer {
    D{i:0;uuid:"726e87f6-be85-5f8b-a16c-9428df3f09f6"}D{i:1;uuid:"f5fe58d1-ec77-5f79-8934-0955de92ebcb"}
D{i:2;uuid:"f5fe58d1-ec77-5f79-8934-0955de92ebcb_DesignEffect"}D{i:3;uuid:"f5fe58d1-ec77-5f79-8934-0955de92ebcb_DesignDropShadow_0"}
D{i:4;uuid:"f5fe58d1-ec77-5f79-8934-0955de92ebcb_DesignInnerShadow_1"}D{i:5;uuid:"92f2052a-b87a-5bec-8d08-7be67d4f3245"}
D{i:6;uuid:"92f2052a-b87a-5bec-8d08-7be67d4f3245_DesignEffect"}D{i:7;uuid:"92f2052a-b87a-5bec-8d08-7be67d4f3245_DesignDropShadow_0"}
D{i:8;uuid:"92f2052a-b87a-5bec-8d08-7be67d4f3245_DesignDropShadow_1"}D{i:9;uuid:"92f2052a-b87a-5bec-8d08-7be67d4f3245_DesignInnerShadow_2"}
D{i:10;uuid:"92f2052a-b87a-5bec-8d08-7be67d4f3245_DesignInnerShadow_3"}
}
##^##*/

