
/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/
import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Effects
import QtQuick3D.Helpers
import QtQuick3D.Particles3D
import Flashlight
import Generated.QtQuick3D.Flashlight
import QtQuick.Timeline
import Generated.ComponentBundles.MaterialBundle
import Generated.Effects.Glow 1.0
import QtQuick.Layouts
import Generated.QtQuick3D.ComputerScene

Rectangle {
    id: rectangle
    width: Constants.width
    height: Constants.height
    color: Constants.backgroundColor

    OrbitCameraController {
        origin: cameraNode
        camera: sceneCamera
    }

    ArcballController {
        id: arcballController
        controlledObject: flashlight
    }

    DragHandler {
        id: dragHandler
        target: null
        acceptedButtons: Qt.RightButton
    }

    Connections {
        target: dragHandler
        onCentroidChanged: {
            arcballController.mouseMoved(toNDC(dragHandler.centroid.position.x,
                                               dragHandler.centroid.position.y))
        }

        onActiveChanged: {
            if (dragHandler.active) {
                view3D.forceActiveFocus()
                arcballController.mousePressed(
                            toNDC(dragHandler.centroid.position.x,
                                  dragHandler.centroid.position.y))
            } else
                arcballController.mouseReleased(
                            toNDC(dragHandler.centroid.position.x,
                                  dragHandler.centroid.position.y))
        }

        function toNDC(x, y) {
            return Qt.vector2d((2.0 * x / width) - 1.0,
                               1.0 - (2.0 * y / height))
        }
    }

    View3D {
        id: view3D
        anchors.fill: parent
        environment: sceneEnvironment

        ExtendedSceneEnvironment {
            id: sceneEnvironment
            glowBlendMode: comboBoxBlendMode.currentIndex === 0 ? ExtendedSceneEnvironment.GlowBlendMode.Additive : comboBoxBlendMode.currentIndex === 1 ? ExtendedSceneEnvironment.GlowBlendMode.Screen : comboBoxBlendMode.currentIndex === 2 ? ExtendedSceneEnvironment.GlowBlendMode.SoftLight : comboBoxBlendMode.currentIndex === 3 ? ExtendedSceneEnvironment.GlowBlendMode.Replace : null
            probeOrientation.y: slider_hdr_rotation.value
            glowLevel: (checkBox.checked ? ExtendedSceneEnvironment.GlowLevel.One : 0)
                       | (checkBox1.checked ? ExtendedSceneEnvironment.GlowLevel.Two : 0)
                       | (checkBox2.checked ? ExtendedSceneEnvironment.GlowLevel.Three : 0)
                       | (checkBox3.checked ? ExtendedSceneEnvironment.GlowLevel.Four : 0)
                       | (checkBox4.checked ? ExtendedSceneEnvironment.GlowLevel.Five : 0)
                       | (checkBox5.checked ? ExtendedSceneEnvironment.GlowLevel.Six : 0)
                       | (checkBox6.checked ? ExtendedSceneEnvironment.GlowLevel.Seven : 0)
            probeExposure: hdrStrengthSlider.value
            glowBloom: bloomSlider.value
            glowIntensity: intensitySlider.value
            glowStrength: strengthSlider.value
            glowUseBicubicUpscale: bicubicUpsamplingSwitch.checked
            glowHDRScale: 1
            lutEnabled: false
            skyboxBlurAmount: 0
            depthOfFieldFocusDistance: 600
            depthOfFieldBlurAmount: 10
            depthOfFieldFocusRange: 1
            depthOfFieldEnabled: false
            aoStrength: 100
            aoEnabled: false
            lensFlareEnabled: false
            clearColor: "#0d0d0d"
            glowHDRMaximumValue: 10
            glowHDRMinimumValue: 1
            backgroundMode: SceneEnvironment.SkyBox
            lightProbe: moonless_golf_4k
            glowQualityHigh: true
            glowEnabled: true
            antialiasingMode: SceneEnvironment.SSAA
            antialiasingQuality: SceneEnvironment.VeryHigh
        }

        Node {
            id: scene

            Node {
                id: cameraNode

                PerspectiveCamera {
                    id: sceneCamera
                    x: -76.671
                    y: 360.403
                    z: 928.88629
                    fieldOfView: 50
                }
            }

            ComputerScene {
                id: computerScene
                x: -510.156
                y: -58.105
                z: -579.67474
                computerOn: computerCheckBox.checked
            }

            Flashlight {
                id: flashlight
                lampBrightness: lampBrightnessSlider.value
                x: -132.293
                y: 388.959
                z: 459.99136
                eulerRotation.y: -72.92974
                eulerRotation.z: 14.35545
                eulerRotation.x: 6.70334
                scale.z: 10
                scale.y: 10
                scale.x: 10

                SpotLight {
                    id: spotlight
                    x: -9.396
                    y: -0.067
                    z: 0.02136
                    eulerRotation.z: -1.50592
                    eulerRotation.y: 90.41776
                    eulerRotation.x: 0.01524
                    color: "#fce18e"
                    quadraticFade: 0.99977
                    coneAngle: lampConeAngleSlider.value
                    innerConeAngle: lampConeAngleSlider.value - 100
                    brightness: lampBrightnessSlider.value * 20
                    castsShadow: true
                }
            }

            PointLight {
                id: bigCandleLight
                x: -641.195
                y: 616.32
                z: -278.44458
                color: "#ec7904"
                brightness: candleCheckBox.checked ? 1.5 : 0
                castsShadow: true
            }

            PointLight {
                id: candleLight
                x: 261.192
                y: 361.978
                z: -247.59242
                color: "#e0d385"
                quadraticFade: 2.18894
                brightness: candleCheckBox.checked ? 3 : 0
                castsShadow: true
            }

            PointLight {
                id: monitorLight
                x: 2.718
                y: 399.139
                color: "#88bbd9"
                quadraticFade: 1.94466
                brightness: computerCheckBox.checked ? 1 : 0
                z: -162.31596
            }
        }

        ParticleSystem3D {
            id: psystem
            x: -641.196
            y: 611.46
            z: -277.76849

            SpriteParticle3D {
                id: particleFire
                sprite: Texture {
                    source: "images/sphere.png"
                }
                colorTable: Texture {
                    source: "images/colorTable.png"
                }
                maxAmount: 69
                color: "#ffffff"
                colorVariation: Qt.vector4d(0.0, 0.6, 0.8, 0.0)
                billboard: true
                blendMode: SpriteParticle3D.Screen
                fadeInDuration: 100
                castsReflections: true
            }

            ParticleEmitter3D {
                id: fireEmitter
                particle: particleFire
                enabled: candleCheckBox.checked
                particleScale: 2
                particleEndScale: 0
                particleScaleVariation: 3
                particleEndScaleVariation: 5
                velocity: VectorDirection3D {
                    direction: Qt.vector3d(0, 45, 0)
                    directionVariation: Qt.vector3d(10, 30, 0)
                }
                emitRate: 200
                lifeSpan: 1000
                lifeSpanVariation: 500
            }
        }

        ParticleSystem3D {
            id: psystem1
            x: 259.261
            y: 350
            z: -247.30052
            SpriteParticle3D {
                id: anotherParticleFire
                sprite: Texture {
                    source: "images/sphere.png"
                }
                colorTable: Texture {
                    source: "images/colorTable.png"
                }
                maxAmount: 69
                color: "#ffffff"
                colorVariation: Qt.vector4d(0.0, 0.6, 0.8, 0.0)
                billboard: true
                blendMode: SpriteParticle3D.Screen
                fadeInDuration: 100
                castsReflections: true
            }

            ParticleEmitter3D {
                id: anotherFireEmitter
                enabled: candleCheckBox.checked
                particle: anotherParticleFire
                particleScale: 0
                particleEndScale: 0
                particleScaleVariation: 5
                particleEndScaleVariation: 10
                velocity: VectorDirection3D {
                    direction: Qt.vector3d(0, 25, 0)
                    directionVariation: Qt.vector3d(10, 50, 0)
                }
                emitRate: 400
                lifeSpan: 1000
                lifeSpanVariation: 500
            }
        }
    }

    ColumnLayout {
        id: controlLayout
        spacing: 8

        Pane {
            id: lampPane
            background: null

            Column {
                id: columnLampBrightness
                Text {
                    color: "#ffffff"
                    text: qsTr("Lamp brightness")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }
                Row {
                    id: row
                    spacing: 8
                    Slider {
                        id: lampBrightnessSlider
                        value: 3.5
                        to: 10
                        from: 0
                        stepSize: 0.01
                    }
                    Text {
                        id: lampBrightnessValueID
                        color: "#ffffff"
                        text: lampBrightnessSlider.value.toFixed(1)
                        anchors.verticalCenter: parent.verticalCenter
                        font.pixelSize: 18
                    }
                }
                Text {
                    color: "#ffffff"
                    text: qsTr("Lamp cone angle")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }
                Row {
                    Slider {
                        id: lampConeAngleSlider
                        value: 25
                        to: 100
                        from: 0
                        stepSize: 0.1
                    }
                    Text {
                        color: "#ffffff"
                        text: lampConeAngleSlider.value.toFixed(1)
                        anchors.verticalCenter: parent.verticalCenter
                        font.pixelSize: 18
                    }
                }
            }
        }

        Pane {
            id: hdrPane
            background: null

            ColumnLayout {
                Column {
                    id: columnHDRBrightness

                    Text {
                        id: environmentBrightnessLabelID
                        width: 150
                        color: "#ffffff"
                        text: qsTr("Environment brightness")
                        font.pixelSize: 18
                        wrapMode: Text.NoWrap
                    }
                    Row {
                        spacing: 8
                        Slider {
                            id: hdrStrengthSlider
                            from: 0
                            value: 0.2
                            stepSize: 0.01
                            to: 5
                        }
                        Text {
                            id: environmentBrightnessValueID
                            color: "#ffffff"
                            text: (sceneEnvironment.probeExposure).toFixed(2)
                            font.pixelSize: 18
                        }
                    }
                }
                Column {
                    id: columnHDRRotation
                    Text {
                        id: environmentRotationLabelID
                        width: 150
                        color: "#ffffff"
                        text: qsTr("Environment rotation")
                        font.pixelSize: 18
                        wrapMode: Text.NoWrap
                    }
                    Row {

                        Slider {
                            id: slider_hdr_rotation
                            value: 0
                            stepSize: 15
                            to: 360
                        }
                        Text {
                            id: environmentRotationValueID
                            color: "#ffffff"
                            text: slider_hdr_rotation.value.toFixed(2)
                            font.pixelSize: 18
                        }
                    }
                }
            }
        }

        Pane {
            id: glowPane
            background: null

            Column {
                id: columnGlow
                spacing: 10
                Text {
                    id: textGlowStrength
                    color: "#ffffff"
                    text: qsTr("Glow strength")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }
                Row {
                    Slider {
                        id: strengthSlider
                        value: 0.8
                        stepSize: 0.01
                        to: 2
                    }

                    Text {
                        id: textGlowStrengthValue
                        color: "#ffffff"
                        text: (sceneEnvironment.glowStrength).toFixed(2)
                        font.pixelSize: 18
                    }
                }
                Text {
                    id: textGlowIntensityLabel
                    color: "#ffffff"
                    text: qsTr("Glow intensity")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }
                Row {
                    Slider {
                        id: intensitySlider
                        value: 2
                        stepSize: 0.01
                        to: 2
                    }

                    Text {
                        id: textGlowIntensityValue
                        color: "#ffffff"
                        text: (sceneEnvironment.glowIntensity).toFixed(2)
                        font.pixelSize: 18
                    }
                }

                Text {
                    id: text4
                    color: "#ffffff"
                    text: qsTr("Glow bloom")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }
                Row {
                    Slider {
                        id: bloomSlider
                        value: 0.2
                        stepSize: 0.01
                    }

                    Text {
                        id: text9
                        color: "#ffffff"
                        text: (sceneEnvironment.glowBloom).toFixed(2)
                        font.pixelSize: 18
                    }
                }

                Switch {
                    id: bicubicUpsamplingSwitch
                    text: qsTr("Bicubic upsampling")
                    checkable: true
                    checked: false
                }
            }
        }

        Pane {
            id: levelsPane
            background: null

            Column {
                id: columnLevels

                Text {
                    id: text5
                    color: "#ffffff"
                    text: qsTr("Glow blur levels")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }

                Grid {
                    id: grid
                    rows: 2
                    columns: 4

                    CheckBox {
                        id: checkBox
                        text: qsTr("1")
                        checked: true
                    }

                    CheckBox {
                        id: checkBox1
                        text: qsTr("2")
                        checked: true
                    }

                    CheckBox {
                        id: checkBox2
                        text: qsTr("3")
                        checked: true
                    }

                    CheckBox {
                        id: checkBox3
                        text: qsTr("4")
                        checked: true
                    }

                    CheckBox {
                        id: checkBox4
                        text: qsTr("5")
                        checked: true
                    }

                    CheckBox {
                        id: checkBox5
                        text: qsTr("6")
                        checked: true
                    }

                    CheckBox {
                        id: checkBox6
                        text: qsTr("7")
                        checked: true
                    }
                }
            }
        }

        Pane {
            id: blendPane
            background: null

            Column {
                id: columnBlend
                width: 200
                height: 400
                spacing: 6

                Text {
                    id: text6
                    color: "#ffffff"
                    text: qsTr("Glow blend mode")
                    font.pixelSize: 18
                    wrapMode: Text.NoWrap
                }

                ComboBox {
                    id: comboBoxBlendMode
                    model: ["Additive", "Screen", "Soft light", "Replace"]
                    displayText: model[comboBoxBlendMode.currentIndex]
                }
            }
        }

        Pane {
            id: helpPane
            background: null

            Column {

                Row {

                    CheckBox {
                        id: computerCheckBox
                        text: qsTr("Computer")
                    }

                    CheckBox {
                        id: candleCheckBox
                        text: qsTr("Candles")
                    }
                }

                Text {
                    id: helpText
                    color: "#ffffff"
                    text: qsTr("Left mouse button - Rotate  camera\nRight mouse button - Move flashlight\nCtrl + left mouse button - Move camera")
                }
            }
        }
    }

    Item {
        id: __materialLibrary__

        Texture {
            id: moonless_golf_4k
            source: "images/moonless_golf_4k.hdr"
        }

        Texture {
            id: basicLights3_4K
            source: "images/BasicLights3_4K.hdr"
        }
    }
}

/*##^##
Designer {
    D{i:0;matPrevEnvDoc:"SkyBox";matPrevEnvValueDoc:"preview_studio";matPrevModelDoc:"#Sphere"}
D{i:5;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/

