import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6

Rectangle {
    id: weathericons
    width: 200
    height: 200
    visible: true
    color: "#00303553"
    property alias rainmoonOpacity: rainmoon.opacity
    property alias rainsunOpacity: rainsun.opacity
    property alias clearOpacity: clear.opacity
    property alias windyOpacity: windy.opacity
    property alias tornadoOpacity: tornado.opacity
    property alias coldOpacity: cold.opacity
    property alias hotOpacity: hot.opacity
    property alias clearnightOpacity: clearnight.opacity
    property alias nightscatteredfogOpacity: nightscatteredfog.opacity
    property alias fogOpacity: fog.opacity
    property alias wintermixOpacity: wintermix.opacity
    property alias blizzardOpacity: blizzard.opacity
    property alias snowOpacity: snow.opacity
    property alias lightsnowOpacity: lightsnow.opacity
    property alias thunderOpacity: thunder.opacity
    property alias hailOpacity: hail.opacity
    property alias heavyrainOpacity: heavyrain.opacity
    property alias rainOpacity: rain.opacity
    property alias lightrainOpacity: lightrain.opacity
    property alias scatteredfogOpacity: scatteredfog.opacity
    property alias brokencloudsOpacity: brokenclouds.opacity
    property alias overcastOpacity: overcast.opacity

    Rectangle {
        id: weatherstates
        width: 200
        height: 200
        color: "#00ffffff"

        Rectangle {
            id: rainmoon
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: moon2
                x: 0
                y: 0
                width: 74
                height: 91
                source: "img/moon.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: clearnight
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: moon1
                x: 40
                y: 46
                width: 88
                height: 109
                source: "img/moon.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: clear
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: sun1
                x: 28
                y: 25
                width: 145
                height: 150
                source: "img/sun.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: rainsun
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: sun3
                x: 0
                y: 0
                source: "img/sun.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: overcast
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            clip: false

            Image {
                id: cloud
                x: 42
                y: 56
                source: "img/cloud.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: brokenclouds
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: cloud1
                x: 8
                y: 102
                width: 73
                height: 55
                source: "img/cloud.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: cloud2
                x: 110
                y: 73
                width: 73
                height: 55
                source: "img/cloud.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: scatteredfog
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: sun2
                x: 46
                y: 44
                source: "img/sun.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: fog1
                x: 20
                y: 106
                source: "img/fog.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: lightrain
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: cloudrain
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water
                x: 91
                y: 123
                width: 19
                height: 31
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: rain
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain1
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water1
                x: 75
                y: 123
                width: 18
                height: 28
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water2
                x: 94
                y: 122
                width: 22
                height: 35
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: heavyrain
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain2
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water3
                x: 61
                y: 123
                width: 18
                height: 28
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water4
                x: 81
                y: 123
                width: 18
                height: 28
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water5
                x: 101
                y: 123
                width: 18
                height: 28
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water8
                x: 120
                y: 123
                width: 18
                height: 28
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: hail
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain3
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: hail1
                x: 55
                y: 129
                source: "img/hail.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: lightsnow
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain4
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake
                x: 86
                y: 123
                width: 29
                height: 29
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: snow
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain5
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake1
                x: 123
                y: 109
                width: 42
                height: 42
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake2
                x: 47
                y: 113
                width: 34
                height: 34
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake3
                x: 88
                y: 129
                width: 24
                height: 24
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: blizzard
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain6
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake4
                x: 111
                y: 112
                width: 35
                height: 35
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: wind
                x: 51
                y: 130
                width: 54
                height: 39
                source: "img/wind.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake5
                x: 101
                y: 153
                width: 25
                height: 25
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake6
                x: 140
                y: 148
                width: 20
                height: 21
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: wintermix
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"
            Image {
                id: cloudrain7
                x: 42
                y: 35
                source: "img/cloudrain.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake7
                x: 48
                y: 115
                width: 35
                height: 35
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water6
                x: 134
                y: 122
                width: 14
                height: 24
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: water7
                x: 92
                y: 123
                width: 16
                height: 27
                source: "img/water.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: snowflake8
                x: 108
                y: 115
                width: 25
                height: 25
                source: "img/snowflake.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: fog
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: fog2
                x: 48
                y: 72
                source: "img/fog.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: nightscatteredfog
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: moon
                x: 67
                y: 69
                source: "img/moon.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: nightfog
                x: 65
                y: 97
                source: "img/nightfog.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: hot
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: hot1
                x: 107
                y: 29
                source: "img/hot.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: cold
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: cold1
                x: 107
                y: 29
                source: "img/cold.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: tornado
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: tornado1
                x: 59
                y: 65
                opacity: 1
                source: "img/tornado.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: thunder
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: cloudstorm
                x: 42
                y: 35
                opacity: 1
                source: "img/cloudstorm.png"
                fillMode: Image.PreserveAspectFit
            }

            Image {
                id: lightning
                x: 88
                y: 104
                opacity: 0
                source: "img/lightning.png"
                fillMode: Image.PreserveAspectFit
            }
        }

        Rectangle {
            id: windy
            width: 200
            height: 200
            opacity: 0
            visible: true
            color: "#00ffffff"

            Image {
                id: wind1
                x: 69
                y: 154
                width: 63
                height: 46
                source: "img/wind.png"
                fillMode: Image.PreserveAspectFit
            }
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                loops: -1
                running: true
                duration: 2000
                to: 2000
                from: 0
            }
        ]
        startFrame: 0
        endFrame: 2000
        enabled: true

        KeyframeGroup {
            target: cloudstorm
            property: "opacity"
            Keyframe {
                frame: 0
                value: 1
            }

            Keyframe {
                frame: 2000
                value: 1
            }
        }

        KeyframeGroup {
            target: lightning
            property: "opacity"
            Keyframe {
                frame: 0
                value: 1
            }

            Keyframe {
                frame: 300
                value: 0
            }

            Keyframe {
                frame: 480
                value: 0
            }

            Keyframe {
                frame: 509
                value: 1
            }

            Keyframe {
                frame: 752
                value: 0
            }

            Keyframe {
                frame: 1354
                value: 0
            }

            Keyframe {
                frame: 1387
                value: 1
            }

            Keyframe {
                frame: 1548
                value: 0
            }

            Keyframe {
                frame: 1715
                value: 0
            }

            Keyframe {
                frame: 1744
                value: 1
            }

            Keyframe {
                frame: 2000
                value: 0
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:4;height:200;width:200}D{i:64}D{i:66}D{i:67}D{i:76;property:"opacity";target:"lightning"}
D{i:77;property:"opacity";target:"lightning"}D{i:78;property:"opacity";target:"lightning"}
D{i:79;property:"opacity";target:"lightning"}D{i:80;property:"opacity";target:"lightning"}
D{i:70}
}
##^##*/

