/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.addons;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ContextProcessingAddon {
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    @Inject
    private ContextManager contextManager;
    private EventHandler additionHandler;

    @PostConstruct
    public void init() {
        this.defineContexts();
        this.registerModelListeners();
    }

    private void defineContexts() {
        Activator.trace("/trace/commands", "Initialize contexts and parents from model", null);
        for (MBindingContext root : this.application.getRootContext()) {
            this.defineContexts(null, root);
        }
    }

    private void defineContexts(MBindingContext parent, MBindingContext current) {
        Context context = this.contextManager.getContext(current.getElementId());
        if (!context.isDefined()) {
            String localizedName = LocalizationHelper.getLocalized((String)current.getName(), (MApplicationElement)current, (IEclipseContext)this.application.getContext());
            String localizedDescriptor = LocalizationHelper.getLocalized((String)current.getDescription(), (MApplicationElement)current, (IEclipseContext)this.application.getContext());
            context.define(localizedName, localizedDescriptor, parent == null ? null : parent.getElementId());
        }
        for (MBindingContext child : current.getChildren()) {
            this.defineContexts(current, child);
        }
    }

    private void undefineContext(MBindingContext current) {
        Context context = this.contextManager.getContext(current.getElementId());
        context.undefine();
    }

    @PreDestroy
    public void dispose() {
        this.unregsiterModelListeners();
    }

    private void registerModelListeners() {
        this.additionHandler = new EventHandler(){

            public void handleEvent(Event event) {
                block2: {
                    block3: {
                        Object elementObj = event.getProperty("ChangedElement");
                        if (!(elementObj instanceof MBindingContext)) break block2;
                        if (!UIEvents.isADD(event)) break block3;
                        for (Object newObj : UIEvents.asIterable(event, "NewValue")) {
                            if (!(newObj instanceof MBindingContext)) continue;
                            MBindingContext newCtx = (MBindingContext)newObj;
                            ContextProcessingAddon.this.defineContexts((MBindingContext)elementObj, newCtx);
                        }
                        break block2;
                    }
                    if (!UIEvents.isREMOVE(event)) break block2;
                    for (Object oldObj : UIEvents.asIterable(event, "OldValue")) {
                        if (!(oldObj instanceof MBindingContext)) continue;
                        MBindingContext oldCtx = (MBindingContext)oldObj;
                        ContextProcessingAddon.this.undefineContext(oldCtx);
                    }
                }
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/BindingContext/children/*", this.additionHandler);
    }

    private void unregsiterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
    }
}

