/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.cms.CMSException;
import iaik.cms.SecurityProvider;
import iaik.cms.attributes.CMSMessageDigest;
import iaik.cms.com.fourthpass.a;
import iaik.security.provider.IAIK;
import iaik.smime.ess.ESSCertID;
import iaik.smime.ess.ESSCertIDv2;
import iaik.smime.ess.SigningCertificate;
import iaik.smime.ess.SigningCertificateV2;
import iaik.utils.CryptoUtils;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils {
    static double a = -1.0;

    static Attribute[] a(Attribute[] attributeArray, byte[] byArray) throws CMSException {
        if (attributeArray != null && attributeArray.length > 0) {
            int n2 = attributeArray.length;
            boolean bl = false;
            int n3 = 0;
            while (n3 < n2) {
                if (attributeArray[n3].getType().equals((Object)ObjectID.messageDigest)) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                try {
                    attributeArray = (Attribute[])Util.resizeArray((Object[])attributeArray, (int)(n2 + 1));
                    attributeArray[n2] = new Attribute((AttributeValue)new CMSMessageDigest(byArray));
                }
                catch (Exception exception) {
                    throw new CMSException("Unable to calculate MessageDigest attribute: " + exception.getMessage());
                }
            }
        }
        return attributeArray;
    }

    static InputStream a(DerInputStream derInputStream) throws IOException {
        InputStream inputStream;
        DerInputStream derInputStream2 = derInputStream;
        while ((inputStream = derInputStream2.readOctetString()) instanceof DerInputStream) {
            derInputStream2 = (DerInputStream)inputStream;
        }
        return inputStream;
    }

    public static void printIndented(String string, boolean bl, StringBuffer stringBuffer) {
        Utils.printIndented(string, bl, " ", stringBuffer);
    }

    public static void printIndented(String string, boolean bl, String string2, StringBuffer stringBuffer) {
        String string3 = string2 == null ? "" : string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string4 = stringTokenizer.nextToken();
        if (!bl) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append(String.valueOf(string3) + string4);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\n" + string3 + stringTokenizer.nextToken());
        }
    }

    public static String printIndented(String string, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Utils.printIndented(string, bl, string2, stringBuffer);
        return stringBuffer.toString();
    }

    public static String printIndented(String string, boolean bl) {
        return Utils.printIndented(string, bl, " ");
    }

    public static SigningCertificateV2 makeSigningCertificateV2(Certificate[] certificateArray, AlgorithmID algorithmID, PolicyInformation[] policyInformationArray, boolean bl, SecurityProvider securityProvider) throws CMSException {
        try {
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(certificateArray, algorithmID, bl, securityProvider);
            signingCertificateV2.setPolicies(policyInformationArray);
            return signingCertificateV2;
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create ESS SigningCertificate: " + exception.getMessage());
        }
    }

    public static SigningCertificateV2 makeSigningCertificateV2(Certificate[] certificateArray, AlgorithmID algorithmID, PolicyInformation[] policyInformationArray, boolean bl) throws CMSException {
        return Utils.makeSigningCertificateV2(certificateArray, algorithmID, policyInformationArray, bl, null);
    }

    public static SigningCertificateV2 makeSigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array, PolicyInformation[] policyInformationArray) {
        SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(eSSCertIDv2Array);
        signingCertificateV2.setPolicies(policyInformationArray);
        return signingCertificateV2;
    }

    public static SigningCertificate makeSigningCertificate(Certificate[] certificateArray, PolicyInformation[] policyInformationArray, boolean bl, SecurityProvider securityProvider) throws CMSException {
        try {
            SigningCertificate signingCertificate = new SigningCertificate(certificateArray, bl, securityProvider);
            signingCertificate.setPolicies(policyInformationArray);
            return signingCertificate;
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create ESS SigningCertificate: " + exception.getMessage());
        }
    }

    public static SigningCertificate makeSigningCertificate(Certificate[] certificateArray, PolicyInformation[] policyInformationArray, boolean bl) throws CMSException {
        return Utils.makeSigningCertificate(certificateArray, policyInformationArray, bl, null);
    }

    public static SigningCertificate makeSigningCertificate(ESSCertID[] eSSCertIDArray, PolicyInformation[] policyInformationArray) {
        SigningCertificate signingCertificate = new SigningCertificate(eSSCertIDArray);
        signingCertificate.setPolicies(policyInformationArray);
        return signingCertificate;
    }

    public static boolean isClassAvailable(String string) {
        try {
            Class clazz = iaik.cms.com.fourthpass.a.a(string);
            return clazz != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static double getIaikProviderVersion() {
        if (a == -1.0) {
            Provider provider = Security.getProvider("IAIK");
            if (provider == null) {
                provider = new IAIK();
            }
            a = provider.getVersion();
        }
        return a;
    }

    static X509Certificate[] a(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) throws CertificateException {
        Object[] objectArray;
        if (x509Certificate == null) {
            throw new NullPointerException("Argument \"userCertificate\" must not be null.");
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return new X509Certificate[]{x509Certificate};
        }
        Vector<Object> vector = new Vector<Object>(4);
        try {
            Object object;
            Name name;
            X509Certificate x509Certificate2;
            objectArray = new Hashtable(x509CertificateArray.length + 2);
            int n2 = 0;
            while (n2 < x509CertificateArray.length) {
                if (x509CertificateArray[n2] instanceof X509Certificate) {
                    x509Certificate2 = x509CertificateArray[n2];
                    name = (Name)x509Certificate2.getSubjectDN();
                    object = name.getRFC2253String();
                    objectArray.put(object, x509Certificate2);
                }
                ++n2;
            }
            vector.addElement(x509Certificate);
            x509Certificate2 = x509Certificate;
            object = (Name)x509Certificate2.getIssuerDN();
            String string = object.getRFC2253String();
            name = (X509Certificate)objectArray.get(string);
            int n3 = 20;
            while (name != null && !x509Certificate2.equals(name) && n3-- > 0) {
                AuthorityKeyIdentifier authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate2.getExtension(AuthorityKeyIdentifier.oid);
                SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)name.getExtension(SubjectKeyIdentifier.oid);
                if (authorityKeyIdentifier == null || subjectKeyIdentifier == null || CryptoUtils.equalsBlock((byte[])authorityKeyIdentifier.getKeyIdentifier(), (byte[])subjectKeyIdentifier.get())) {
                    vector.addElement(name);
                    x509Certificate2 = name;
                    object = (Name)x509Certificate2.getIssuerDN();
                    string = object.getRFC2253String();
                    name = (X509Certificate)objectArray.get(string);
                    continue;
                }
                break;
            }
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new CertificateException("Error parsing dn: " + rFC2253NameParserException.toString());
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CertificateException("Error parsing cert extension: " + x509ExtensionInitException.toString());
        }
        objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Argument \"source\" must not be null.");
        }
        if (byArray == null) {
            byArray = new byte[4096];
        }
        if (outputStream != null) {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
            }
            return;
        }
        while (inputStream.read(byArray) >= 0) {
        }
    }

    private Utils() {
    }
}

