/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DOMURIReferenceImpl
extends DOMStructure
implements DOMURIReference {
    protected String type_;
    protected URI uri_;

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "URI");
        if (attr != null) {
            object = attr.getValue();
            try {
                this.uri_ = new URI((String)object);
            }
            catch (URIException uRIException) {
                throw new MarshalException("URI '" + (String)object + "' is not RFC 2396 compliant.", uRIException);
            }
        }
        if ((object = (Attr)namedNodeMap.getNamedItemNS(null, "Type")) != null) {
            this.type_ = object.getValue();
        }
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        Attr attr;
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        if (this.uri_ != null) {
            attr = document.createAttributeNS("", "URI");
            attr.setValue(this.uri_.toString());
            element.setAttributeNodeNS(attr);
        }
        if (this.type_ != null) {
            attr = document.createAttributeNS("", "Type");
            attr.setValue(this.type_);
            element.setAttributeNodeNS(attr);
        }
    }

    public String getURI() {
        return this.uri_ != null ? this.uri_.toString() : null;
    }

    public String getType() {
        return this.type_;
    }

    public Node getHere() {
        return super.getHere();
    }

    protected DOMURIReferenceImpl(Node node) {
        super(node);
    }

    protected DOMURIReferenceImpl(String string, String string2) {
        if (string != null) {
            try {
                this.uri_ = new URI(string);
            }
            catch (URIException uRIException) {
                throw new IllegalArgumentException("URI '" + string + "' is not RFC 2396 compliant. " + uRIException.getMessage());
            }
        }
        this.type_ = string2;
    }
}

