/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.SizeUnits;
import javafx.scene.text.Font;

public final class Size {
    private final double value;
    private final SizeUnits units;

    public Size(double d, SizeUnits sizeUnits) {
        this.value = d;
        this.units = sizeUnits != null ? sizeUnits : SizeUnits.PX;
    }

    public double getValue() {
        return this.value;
    }

    public SizeUnits getUnits() {
        return this.units;
    }

    public boolean isAbsolute() {
        return this.units.isAbsolute();
    }

    public double points(Font font) {
        return this.points(1.0, font);
    }

    public double points(double d, Font font) {
        return this.units.points(this.value, d, font);
    }

    public double pixels(double d, Font font) {
        return this.units.pixels(this.value, d, font);
    }

    public double pixels(Font font) {
        return this.pixels(1.0, font);
    }

    public double pixels(double d) {
        return this.pixels(d, null);
    }

    public double pixels() {
        return this.pixels(1.0, null);
    }

    public String toString() {
        return Double.toString(this.value) + this.units.toString();
    }

    public int hashCode() {
        long l = 17L;
        l = 37L * l + Double.doubleToLongBits(this.value);
        l = 37L * l + (long)this.units.hashCode();
        return (int)(l ^ l >> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Size) {
            Size size = (Size)object;
            if (this.units == size.units && this.value > 0.0 ? size.value > 0.0 : size.value < 0.0) {
                double d = Math.abs(this.value) - Math.abs(size.value);
                return Math.abs(d) < 1.0E-6;
            }
        }
        return false;
    }
}

