/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.security.ecc.math.ecgroup.ECGroupException;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.ecgroup.FastPrimeCurve;
import iaik.security.ecc.math.ecgroup.SimpleECGroupFactory;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.util.Utils;
import java.math.BigInteger;

public abstract class ECGroupFactory {
    private static ECGroupFactory uniqueInstance_ = null;

    public abstract EllipticCurve getDefault(FieldElement var1, FieldElement var2, BigInteger var3) throws ECGroupException;

    public abstract EllipticCurve getCurve(FieldElement var1, FieldElement var2, BigInteger var3, int var4) throws ECGroupException;

    protected ECGroupFactory() {
    }

    public static void setPrimePrecompWindowSize(int n) {
        if (!Utils.isSpeedUpEnabled()) {
            return;
        }
        FastPrimeCurve.setPrecompWindowSize((int)n);
    }

    public static synchronized void setDefaultFactory(ECGroupFactory eCGroupFactory) {
        uniqueInstance_ = eCGroupFactory;
    }

    public static int getPrimePrecompWindowSize() {
        if (Utils.isSpeedUpEnabled()) {
            return FastPrimeCurve.getPrecompWindowSize();
        }
        return 0;
    }

    public static synchronized ECGroupFactory getInstance() throws ECGroupException {
        if (uniqueInstance_ == null) {
            uniqueInstance_ = new SimpleECGroupFactory();
        }
        return uniqueInstance_;
    }
}

