/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurveImpl;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.PrimeField;
import java.math.BigInteger;

class PrimeAffineCurve
extends EllipticCurveImpl {
    public boolean useAffine() {
        return true;
    }

    public void multiply(ECPoint eCPoint, BigInteger bigInteger) {
        if (this.order_ != null && bigInteger.compareTo(this.order_) >= 0) {
            bigInteger = bigInteger.mod(this.order_);
        }
        ECPoint eCPoint2 = (ECPoint)eCPoint.clone();
        switch (bigInteger.signum()) {
            case 0: {
                eCPoint.setInfinity();
            }
            case -1: {
                bigInteger = bigInteger.negate();
                eCPoint.invert();
            }
            case 1: {
                eCPoint2.invert();
            }
        }
        ECPoint eCPoint3 = (ECPoint)eCPoint.clone();
        BigInteger bigInteger2 = bigInteger.multiply(Constants.BIG_THREE);
        int n = bigInteger2.bitLength() - 2;
        while (n > 0) {
            eCPoint3.doublePoint();
            if (bigInteger2.testBit(n) && !bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint);
            }
            if (!bigInteger2.testBit(n) && bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint2);
            }
            --n;
        }
        if (eCPoint3.isInfinity()) {
            eCPoint.setInfinity();
        } else {
            eCPoint.getCoordinates().setX(eCPoint3.getCoordinates().getX());
            eCPoint.getCoordinates().setY(eCPoint3.getCoordinates().getY());
        }
    }

    public void invert(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        eCPoint.getCoordinates().setY(eCPoint.getCoordinates().getY().negate());
    }

    public Field getField() {
        return this.field_;
    }

    public void doublePoint(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        this.addPoint(eCPoint, eCPoint);
    }

    public void addPoint(ECPoint eCPoint, ECPoint eCPoint2) {
        FieldElement fieldElement;
        if (eCPoint2 == eCPoint) {
            eCPoint2 = (ECPoint)eCPoint2.clone();
        }
        if (eCPoint.isInfinity()) {
            if (eCPoint2.isInfinity()) {
                return;
            }
            Coordinate coordinate = (Coordinate)eCPoint2.getCoordinates().clone();
            eCPoint.setCoordinates(coordinate);
            eCPoint.unsetInfinity();
            return;
        }
        if (eCPoint2.isInfinity()) {
            return;
        }
        if (!eCPoint.getCoordinates().getX().equals(eCPoint2.getCoordinates().getX())) {
            fieldElement = FieldElement.sub(eCPoint.getCoordinates().getY(), eCPoint2.getCoordinates().getY()).divide(FieldElement.sub(eCPoint.getCoordinates().getX(), eCPoint2.getCoordinates().getX()));
        } else {
            if (!eCPoint.getCoordinates().getY().equals(eCPoint2.getCoordinates().getY()) || eCPoint2.getCoordinates().getY().isZero()) {
                eCPoint.setInfinity();
                return;
            }
            fieldElement = ((PrimeField)this.field_).newElement(Constants.BIG_THREE);
            fieldElement.multiply(FieldElement.square(eCPoint2.getCoordinates().getX())).add(this.a_);
            FieldElement fieldElement2 = ((PrimeField)this.field_).newElement(Constants.BIG_TWO);
            fieldElement2.multiply(eCPoint2.getCoordinates().getY()).invert();
            fieldElement.multiply(fieldElement2);
        }
        eCPoint.getCoordinates().setX(FieldElement.sub(FieldElement.square(fieldElement), eCPoint.getCoordinates().getX()).sub(eCPoint2.getCoordinates().getX()));
        eCPoint.getCoordinates().setY(FieldElement.sub(eCPoint2.getCoordinates().getX(), eCPoint.getCoordinates().getX()).multiply(fieldElement).sub(eCPoint2.getCoordinates().getY()));
    }

    PrimeAffineCurve(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) {
        this.a_ = fieldElement;
        this.b_ = fieldElement2;
        this.field_ = fieldElement.getField();
        this.order_ = bigInteger;
    }
}

