/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Component;
import java.awt.event.ComponentListener;
import java.beans.BeanInfo;
import java.beans.Encoder;
import java.beans.EventSetDescriptor;
import java.beans.Expression;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.Objects;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import sun.reflect.misc.MethodUtil;

public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private String[] constructor;
    private Boolean definesEquals;

    public DefaultPersistenceDelegate() {
        this(new String[0]);
    }

    public DefaultPersistenceDelegate(String[] stringArray) {
        this.constructor = stringArray;
    }

    private static boolean definesEquals(Class clazz) {
        try {
            return clazz == clazz.getMethod("equals", Object.class).getDeclaringClass();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private boolean definesEquals(Object object) {
        if (this.definesEquals != null) {
            return this.definesEquals == Boolean.TRUE;
        }
        boolean bl = DefaultPersistenceDelegate.definesEquals(object.getClass());
        this.definesEquals = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl;
    }

    @Override
    protected boolean mutatesTo(Object object, Object object2) {
        return this.constructor.length == 0 || !this.definesEquals(object) ? super.mutatesTo(object, object2) : object.equals(object2);
    }

    @Override
    protected Expression instantiate(Object object, Encoder encoder) {
        int n = this.constructor.length;
        Class<?> clazz = object.getClass();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            try {
                Method method = this.findMethod(clazz, this.constructor[i]);
                objectArray[i] = MethodUtil.invoke(method, object, new Object[0]);
                continue;
            }
            catch (Exception exception) {
                encoder.getExceptionListener().exceptionThrown(exception);
            }
        }
        return new Expression(object, object.getClass(), "new", objectArray);
    }

    private Method findMethod(Class clazz, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        PropertyDescriptor propertyDescriptor = DefaultPersistenceDelegate.getPropertyDescriptor(clazz, string);
        if (propertyDescriptor == null) {
            throw new IllegalStateException("Could not find property by the name " + string);
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new IllegalStateException("Could not find getter for the property " + string);
        }
        return method;
    }

    private void doProperty(Class clazz, PropertyDescriptor propertyDescriptor, Object object, Object object2, Encoder encoder) throws Exception {
        Method method = propertyDescriptor.getReadMethod();
        Method method2 = propertyDescriptor.getWriteMethod();
        if (method != null && method2 != null) {
            Expression expression = new Expression(object, method.getName(), new Object[0]);
            Expression expression2 = new Expression(object2, method.getName(), new Object[0]);
            Object object3 = expression.getValue();
            Object object4 = expression2.getValue();
            encoder.writeExpression(expression);
            if (!Objects.equals(object4, encoder.get(object3))) {
                Object[] objectArray = (Object[])propertyDescriptor.getValue("enumerationValues");
                if (objectArray instanceof Object[] && Array.getLength(objectArray) % 3 == 0) {
                    Object[] objectArray2 = objectArray;
                    for (int i = 0; i < objectArray2.length; i += 3) {
                        try {
                            Field field = clazz.getField((String)objectArray2[i]);
                            if (!field.get(null).equals(object3)) continue;
                            encoder.remove(object3);
                            encoder.writeExpression(new Expression(object3, field, "get", new Object[]{null}));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                DefaultPersistenceDelegate.invokeStatement(object, method2.getName(), new Object[]{object3}, encoder);
            }
        }
    }

    static void invokeStatement(Object object, String string, Object[] objectArray, Encoder encoder) {
        encoder.writeStatement(new Statement(object, string, objectArray));
    }

    private void initBean(Class clazz, Object object, Object object2, Encoder encoder) {
        BeanInfo beanInfo;
        Object object3;
        EventListener[] eventListenerArray;
        EventListener[] eventListenerArray2;
        Object object4;
        for (Field field : clazz.getFields()) {
            int n = field.getModifiers();
            if (Modifier.isFinal(n) || Modifier.isStatic(n) || Modifier.isTransient(n)) continue;
            try {
                object4 = new Expression(field, "get", new Object[]{object});
                eventListenerArray2 = new Expression(field, "get", new Object[]{object2});
                eventListenerArray = ((Expression)object4).getValue();
                object3 = eventListenerArray2.getValue();
                encoder.writeExpression((Expression)object4);
                if (Objects.equals(object3, encoder.get(eventListenerArray))) continue;
                encoder.writeStatement(new Statement(field, "set", new Object[]{object, eventListenerArray}));
            }
            catch (Exception exception) {
                encoder.getExceptionListener().exceptionThrown(exception);
            }
        }
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return;
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (propertyDescriptor.isTransient()) continue;
            try {
                this.doProperty(clazz, propertyDescriptor, object, object2, encoder);
            }
            catch (Exception exception) {
                encoder.getExceptionListener().exceptionThrown(exception);
            }
        }
        if (!Component.class.isAssignableFrom(clazz)) {
            return;
        }
        for (FeatureDescriptor featureDescriptor : beanInfo.getEventSetDescriptors()) {
            Object object5;
            if (featureDescriptor.isTransient() || (object4 = ((EventSetDescriptor)featureDescriptor).getListenerType()) == ComponentListener.class || object4 == ChangeListener.class && clazz == JMenuItem.class) continue;
            eventListenerArray2 = new EventListener[]{};
            eventListenerArray = new EventListener[]{};
            try {
                object3 = ((EventSetDescriptor)featureDescriptor).getGetListenerMethod();
                eventListenerArray2 = (EventListener[])MethodUtil.invoke((Method)object3, object, new Object[0]);
                eventListenerArray = (EventListener[])MethodUtil.invoke((Method)object3, object2, new Object[0]);
            }
            catch (Exception exception) {
                try {
                    object5 = clazz.getMethod("getListeners", Class.class);
                    eventListenerArray2 = (EventListener[])MethodUtil.invoke((Method)object5, object, new Object[]{object4});
                    eventListenerArray = (EventListener[])MethodUtil.invoke((Method)object5, object2, new Object[]{object4});
                }
                catch (Exception exception2) {
                    return;
                }
            }
            object3 = ((EventSetDescriptor)featureDescriptor).getAddListenerMethod().getName();
            for (int i = eventListenerArray.length; i < eventListenerArray2.length; ++i) {
                DefaultPersistenceDelegate.invokeStatement(object, (String)object3, new Object[]{eventListenerArray2[i]}, encoder);
            }
            object5 = ((EventSetDescriptor)featureDescriptor).getRemoveListenerMethod().getName();
            for (int i = eventListenerArray2.length; i < eventListenerArray.length; ++i) {
                DefaultPersistenceDelegate.invokeStatement(object, (String)object5, new Object[]{eventListenerArray[i]}, encoder);
            }
        }
    }

    @Override
    protected void initialize(Class<?> clazz, Object object, Object object2, Encoder encoder) {
        super.initialize(clazz, object, object2, encoder);
        if (object.getClass() == clazz) {
            this.initBean(clazz, object, object2, encoder);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!string.equals(propertyDescriptor.getName())) continue;
                return propertyDescriptor;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return null;
    }
}

