/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentationReferenceImpl
extends XadesDOMStructure
implements DOMURIReference {
    private URI a;

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        String string = DOMUtils.getAllTextFromChildren((Element)element);
        try {
            this.a = new URI(string);
        }
        catch (URIException uRIException) {
            throw new MarshalException("URI reference '" + string + "' is not RFC 2396 complaint. " + uRIException.getMessage());
        }
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        DOMUtils.addTextToElement((Element)element, (String)this.a.toString());
        return element;
    }

    public String getURI() {
        return this.a.toString();
    }

    public String getType() {
        return null;
    }

    public String getLocalName() {
        return "DocumentationReference";
    }

    public Node getHere() {
        return super.getHere();
    }

    public DocumentationReferenceImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.a == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public DocumentationReferenceImpl(String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'uri' must not be null.");
        }
        try {
            this.a = new URI(string);
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException("URI reference '" + string + "' is not RFC 2396 complaint. " + uRIException.getMessage());
        }
    }
}

