/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.modeling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.workbench.modeling.IDelta;

public abstract class ModelDelta
implements IDelta {
    private final Object object;
    private final String attributeName;
    private final Object attributeValue;

    public ModelDelta(Object object, String attributeName, Object attributeValue) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)attributeName);
        this.object = object;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public Object getObject() {
        return this.object;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    protected Object convert(Object value) {
        if (value instanceof IDelta) {
            IDelta delta = (IDelta)value;
            delta.apply();
            return delta.getObject();
        }
        if (value instanceof List) {
            List values = (List)value;
            ArrayList objects = new ArrayList(values.size());
            int i = 0;
            while (i < values.size()) {
                Object object = values.get(i);
                if (object instanceof IDelta) {
                    IDelta delta = (IDelta)object;
                    delta.apply();
                    object = delta.getObject();
                }
                objects.add(object);
                ++i;
            }
            return objects;
        }
        return value;
    }

    public Object getAttributeValue() {
        return this.convert(this.attributeValue);
    }
}

