/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.asn1.OCTET_STRING;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.field.FieldElement;

class ProjectiveCoordinate
extends Coordinate {
    protected FieldElement z_;

    protected void setZ(FieldElement fieldElement) {
        this.z_ = fieldElement;
    }

    public String toString() {
        return "X: " + this.x_.toString() + "\nY: " + this.y_.toString() + "\nZ: " + this.z_.toString();
    }

    public OCTET_STRING toASN1Object() {
        return this.toAffine().toASN1Object();
    }

    public Coordinate toAffine() {
        FieldElement fieldElement = ((FieldElement)this.z_.clone()).invert();
        FieldElement fieldElement2 = ((FieldElement)fieldElement.clone()).square();
        FieldElement fieldElement3 = ((FieldElement)fieldElement.clone()).multiply(fieldElement2);
        return new AffineCoordinate(((FieldElement)this.x_.clone()).multiply(fieldElement2), ((FieldElement)this.y_.clone()).multiply(fieldElement3));
    }

    public int hashCode() {
        return this.coordinateType_ + this.x_.hashCode() + this.y_.hashCode() + this.z_.hashCode();
    }

    public FieldElement getZ() {
        return this.z_;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectiveCoordinate) {
            ProjectiveCoordinate projectiveCoordinate = (ProjectiveCoordinate)object;
            return projectiveCoordinate.x_.equals(this.x_) && projectiveCoordinate.y_.equals(this.y_) && projectiveCoordinate.z_.equals(this.z_);
        }
        return false;
    }

    public Object clone() {
        ProjectiveCoordinate projectiveCoordinate = (ProjectiveCoordinate)super.clone();
        projectiveCoordinate.x_ = (FieldElement)this.x_.clone();
        projectiveCoordinate.y_ = (FieldElement)this.y_.clone();
        projectiveCoordinate.z_ = (FieldElement)this.z_.clone();
        return projectiveCoordinate;
    }

    public ProjectiveCoordinate(FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        super(fieldElement, fieldElement2, 1);
        this.z_ = fieldElement3;
    }
}

