/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarSignature;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.TrustedLibraries;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarAsBLOBVerifier
extends JarVerifier {
    JarSignature js = null;
    public static boolean ENABLED = false;

    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        JarAsBLOBVerifier jarAsBLOBVerifier;
        if (ENABLED && (jarAsBLOBVerifier = new JarAsBLOBVerifier(uRL, string, file, file2)).detectedSignature()) {
            return jarAsBLOBVerifier;
        }
        return null;
    }

    JarAsBLOBVerifier(URL uRL, String string, File file, File file2) {
        super(uRL, string, file, file2);
        this.init();
    }

    private void init() {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.jarFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry != null && "META-INF/".equals(zipEntry.getName())) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null && zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null && JarSignature.BLOB_SIGNATURE.equals(zipEntry.getName())) {
                byte[] byArray = JarAsBLOBVerifier.getBytes(zipInputStream);
                this.js = new JarSignature(byArray);
            }
        }
        catch (Exception exception) {
            this.js = null;
        }
    }

    private boolean detectedSignature() {
        return this.js != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(DownloadEngine.DownloadDelegate downloadDelegate) throws IOException, JARSigningException {
        JarFile jarFile = new JarFile(this.jarFile);
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n;
            Object object;
            CodeSigner[] codeSignerArray;
            int n2 = jarFile.size();
            int n3 = 0;
            this.manifest = jarFile.getManifest();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, 0, n2);
            }
            while (enumeration.hasMoreElements()) {
                ++n3;
                codeSignerArray = null;
                object = null;
                object = enumeration.nextElement();
                codeSignerArray = ((ZipEntry)object).getName();
                if (!bl) {
                    try {
                        bl = BlackList.checkJarEntry(jarFile, (JarEntry)object);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new JARSigningException(this.jarLocation, this.jarVersion, 5, generalSecurityException);
                    }
                }
                if (!bl2) {
                    try {
                        bl2 = TrustedLibraries.checkJarEntry(jarFile, (JarEntry)object);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        Attributes attributes = this.manifest.getMainAttributes();
                        attributes.putValue("Trusted-Library", Boolean.TRUE.toString());
                    }
                }
                if (JarSignature.BLOB_SIGNATURE.equals(codeSignerArray) || codeSignerArray.endsWith("/")) continue;
                this.authenticateJarEntry(jarFile, (JarEntry)object);
            }
            if (!this.js.isValid()) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 2);
            }
            this.hasOnlySignedEntries = true;
            this.hasSingleCodeSource = true;
            this.hasMissingSignedEntries = false;
            codeSignerArray = this.js.getCodeSigners();
            object = new CodeSource(this.jarLocation, codeSignerArray);
            Certificate[] certificateArray = ((CodeSource)object).getCertificates();
            this.singleSignerIndicesCert = new int[certificateArray.length];
            for (n = 0; n < certificateArray.length; ++n) {
                this.signerCerts.add(certificateArray[n]);
                this.singleSignerIndicesCert[n] = n;
            }
            this.codeSourceCertCache.put(this.singleSignerIndicesCert, object);
            if (Config.isJavaVersionAtLeast15()) {
                this.singleSignerIndicesCS = new int[codeSignerArray.length];
                for (n = 0; n < codeSignerArray.length; ++n) {
                    this.signersCS.add(codeSignerArray[n]);
                    this.singleSignerIndicesCS[n] = n;
                }
                this.codeSourceCache.put(this.singleSignerIndicesCS, object);
            }
            this.signerMap.put(null, this.singleSignerIndicesCS);
            this.signerMapCert.put(null, this.singleSignerIndicesCert);
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    protected void authenticateJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, JARSigningException {
        String string = jarEntry.getName();
        boolean bl = this.nativePath != null && string.indexOf("/") == -1 && string.indexOf("\\") == -1;
        try {
            InputStream inputStream = this.js.updateWithZipEntry(string, jarFile.getInputStream(jarEntry));
            JarAsBLOBVerifier.readAndMaybeSaveStreamTo(inputStream, bl, string, this.nativePath);
        }
        catch (SignatureException signatureException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, signatureException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, securityException);
        }
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

