/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.objects;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.utils.FastStringBuffer;
import com.sun.org.apache.xml.internal.utils.XMLCharacterRecognizer;
import com.sun.org.apache.xml.internal.utils.XMLString;
import com.sun.org.apache.xml.internal.utils.XMLStringFactory;
import com.sun.org.apache.xpath.internal.objects.XMLStringFactoryImpl;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.objects.XNumber;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.objects.XString;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XStringForFSB
extends XString {
    static final long serialVersionUID = -1533039186550674548L;
    int m_start;
    int m_length;
    protected String m_strCache = null;
    protected int m_hash = 0;

    public XStringForFSB(FastStringBuffer fastStringBuffer, int n, int n2) {
        super(fastStringBuffer);
        this.m_start = n;
        this.m_length = n2;
        if (null == fastStringBuffer) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage("ER_FASTSTRINGBUFFER_CANNOT_BE_NULL", null));
        }
    }

    private XStringForFSB(String string) {
        super(string);
        throw new IllegalArgumentException(XSLMessages.createXPATHMessage("ER_FSB_CANNOT_TAKE_STRING", null));
    }

    public FastStringBuffer fsb() {
        return (FastStringBuffer)this.m_obj;
    }

    @Override
    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append(this.str());
    }

    @Override
    public boolean hasString() {
        return null != this.m_strCache;
    }

    @Override
    public Object object() {
        return this.str();
    }

    @Override
    public String str() {
        if (null == this.m_strCache) {
            this.m_strCache = this.fsb().getString(this.m_start, this.m_length);
        }
        return this.m_strCache;
    }

    @Override
    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        this.fsb().sendSAXcharacters(contentHandler, this.m_start, this.m_length);
    }

    @Override
    public void dispatchAsComment(LexicalHandler lexicalHandler) throws SAXException {
        this.fsb().sendSAXComment(lexicalHandler, this.m_start, this.m_length);
    }

    @Override
    public int length() {
        return this.m_length;
    }

    @Override
    public char charAt(int n) {
        return this.fsb().charAt(this.m_start + n);
    }

    @Override
    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4 = n2 - n;
        if (n4 > this.m_length) {
            n4 = this.m_length;
        }
        if (n4 > cArray.length - n3) {
            n4 = cArray.length - n3;
        }
        int n5 = n + this.m_start + n4;
        int n6 = n3;
        FastStringBuffer fastStringBuffer = this.fsb();
        for (int i = n + this.m_start; i < n5; ++i) {
            cArray[n6++] = fastStringBuffer.charAt(i);
        }
    }

    @Override
    public boolean equals(XMLString xMLString) {
        if (this == xMLString) {
            return true;
        }
        int n = this.m_length;
        if (n == xMLString.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n2 = this.m_start;
            int n3 = 0;
            while (n-- != 0) {
                if (fastStringBuffer.charAt(n2) != xMLString.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(XObject xObject) {
        if (this == xObject) {
            return true;
        }
        if (xObject.getType() == 2) {
            return xObject.equals(this);
        }
        int n = this.m_length;
        String string = xObject.str();
        if (n == string.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n2 = this.m_start;
            int n3 = 0;
            while (n-- != 0) {
                if (fastStringBuffer.charAt(n2) != string.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean equals(String string) {
        int n = this.m_length;
        if (n == string.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n2 = this.m_start;
            int n3 = 0;
            while (n-- != 0) {
                if (fastStringBuffer.charAt(n2) != string.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof XNumber) {
            return object.equals(this);
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        if (object instanceof XStringForFSB) {
            return this.equals((XMLString)object);
        }
        return this.equals(object.toString());
    }

    @Override
    public boolean equalsIgnoreCase(String string) {
        return this.m_length == string.length() ? this.str().equalsIgnoreCase(string) : false;
    }

    @Override
    public int compareTo(XMLString xMLString) {
        int n = this.m_length;
        int n2 = xMLString.length();
        int n3 = Math.min(n, n2);
        FastStringBuffer fastStringBuffer = this.fsb();
        int n4 = this.m_start;
        int n5 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = fastStringBuffer.charAt(n4);
            if (c2 != (c = xMLString.charAt(n5))) {
                return c2 - c;
            }
            ++n4;
            ++n5;
        }
        return n - n2;
    }

    @Override
    public int compareToIgnoreCase(XMLString xMLString) {
        int n = this.m_length;
        int n2 = xMLString.length();
        int n3 = Math.min(n, n2);
        FastStringBuffer fastStringBuffer = this.fsb();
        int n4 = this.m_start;
        int n5 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = Character.toLowerCase(fastStringBuffer.charAt(n4));
            if (c2 != (c = Character.toLowerCase(xMLString.charAt(n5)))) {
                return c2 - c;
            }
            ++n4;
            ++n5;
        }
        return n - n2;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean startsWith(XMLString xMLString, int n) {
        FastStringBuffer fastStringBuffer = this.fsb();
        int n2 = this.m_start + n;
        int n3 = this.m_start + this.m_length;
        int n4 = 0;
        int n5 = xMLString.length();
        if (n < 0 || n > this.m_length - n5) {
            return false;
        }
        while (--n5 >= 0) {
            if (fastStringBuffer.charAt(n2) != xMLString.charAt(n4)) {
                return false;
            }
            ++n2;
            ++n4;
        }
        return true;
    }

    @Override
    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    @Override
    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    @Override
    public int indexOf(int n, int n2) {
        int n3 = this.m_start + this.m_length;
        FastStringBuffer fastStringBuffer = this.fsb();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.m_length) {
            return -1;
        }
        for (int i = this.m_start + n2; i < n3; ++i) {
            if (fastStringBuffer.charAt(i) != n) continue;
            return i - this.m_start;
        }
        return -1;
    }

    @Override
    public XMLString substring(int n) {
        int n2 = this.m_length - n;
        if (n2 <= 0) {
            return XString.EMPTYSTRING;
        }
        int n3 = this.m_start + n;
        return new XStringForFSB(this.fsb(), n3, n2);
    }

    @Override
    public XMLString substring(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > this.m_length) {
            n3 = this.m_length;
        }
        if (n3 <= 0) {
            return XString.EMPTYSTRING;
        }
        int n4 = this.m_start + n;
        return new XStringForFSB(this.fsb(), n4, n3);
    }

    @Override
    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    @Override
    public XMLString trim() {
        return this.fixWhiteSpace(true, true, false);
    }

    private static boolean isSpace(char c) {
        return XMLCharacterRecognizer.isWhiteSpace(c);
    }

    @Override
    public XMLString fixWhiteSpace(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = this.m_length + this.m_start;
        char[] cArray = new char[this.m_length];
        FastStringBuffer fastStringBuffer = this.fsb();
        boolean bl4 = false;
        int n3 = 0;
        boolean bl5 = false;
        for (n = this.m_start; n < n2; ++n) {
            char c = fastStringBuffer.charAt(n);
            if (XStringForFSB.isSpace(c)) {
                if (!bl5) {
                    if (' ' != c) {
                        bl4 = true;
                    }
                    cArray[n3++] = 32;
                    if (bl3 && n3 != 0) {
                        char c2 = cArray[n3 - 1];
                        if (c2 == '.' || c2 == '!' || c2 == '?') continue;
                        bl5 = true;
                        continue;
                    }
                    bl5 = true;
                    continue;
                }
                bl4 = true;
                bl5 = true;
                continue;
            }
            cArray[n3++] = c;
            bl5 = false;
        }
        if (bl2 && 1 <= n3 && ' ' == cArray[n3 - 1]) {
            bl4 = true;
            --n3;
        }
        n = 0;
        if (bl && 0 < n3 && ' ' == cArray[0]) {
            bl4 = true;
            ++n;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl4 ? xMLStringFactory.newstr(cArray, n, n3 - n) : this;
    }

    @Override
    public double toDouble() {
        char c;
        int n;
        if (this.m_length == 0) {
            return Double.NaN;
        }
        String string = this.fsb().getString(this.m_start, this.m_length);
        for (n = 0; n < this.m_length && XMLCharacterRecognizer.isWhiteSpace(string.charAt(n)); ++n) {
        }
        if (n == this.m_length) {
            return Double.NaN;
        }
        if (string.charAt(n) == '-') {
            ++n;
        }
        while (n < this.m_length && ((c = string.charAt(n)) == '.' || c >= '0' && c <= '9')) {
            ++n;
        }
        while (n < this.m_length && XMLCharacterRecognizer.isWhiteSpace(string.charAt(n))) {
            ++n;
        }
        if (n != this.m_length) {
            return Double.NaN;
        }
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }
}

