/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.ntlm;

import com.sun.security.sasl.ntlm.NTLMClient;
import com.sun.security.sasl.ntlm.NTLMServer;
import com.sun.security.sasl.util.PolicyUtils;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class FactoryImpl
implements SaslClientFactory,
SaslServerFactory {
    private static final String[] myMechs = new String[]{"NTLM"};
    private static final int[] mechPolicies = new int[]{17};

    @Override
    public SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("NTLM") || !PolicyUtils.checkPolicy(mechPolicies[0], map)) continue;
            return new NTLMClient(stringArray[i], string, string2, string3, map, callbackHandler);
        }
        return null;
    }

    @Override
    public SaslServer createSaslServer(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (string.equals("NTLM") && PolicyUtils.checkPolicy(mechPolicies[0], map)) {
            String string4;
            if (map != null && (string4 = (String)map.get("javax.security.sasl.qop")) != null && !string4.equals("auth")) {
                throw new SaslException("NTLM only support auth");
            }
            if (callbackHandler == null) {
                throw new SaslException("Callback handler with support for AuthorizeCallback, RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new NTLMServer(string, string2, string3, map, callbackHandler);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> map) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, map);
    }
}

