/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.MultipartDataSource;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.SharedInputStream;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.UniqueValue;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.ASCIIUtility;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.LineInputStream;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.messaging.saaj.util.FinalArrayList;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class MimeMultipart {
    protected DataSource ds = null;
    protected boolean parsed = true;
    protected FinalArrayList parts = new FinalArrayList();
    protected ContentType contentType;
    protected MimeBodyPart parent;
    protected static boolean ignoreMissingEndBoundary = true;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        this.contentType = new ContentType("multipart", string, null);
        this.contentType.setParameter("boundary", string2);
    }

    public MimeMultipart(DataSource dataSource, ContentType contentType) throws MessagingException {
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = contentType == null ? new ContentType(dataSource.getContentType()) : contentType;
    }

    public void setSubType(String string) {
        this.contentType.setSubType(string);
    }

    public int getCount() throws MessagingException {
        this.parse();
        if (this.parts == null) {
            return 0;
        }
        return this.parts.size();
    }

    public MimeBodyPart getBodyPart(int n) throws MessagingException {
        this.parse();
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        return (MimeBodyPart)this.parts.get(n);
    }

    public MimeBodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            MimeBodyPart mimeBodyPart = this.getBodyPart(i);
            String string2 = mimeBodyPart.getContentID();
            if (string2 == null || !string2.equals(string)) continue;
            return mimeBodyPart;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        for (int i = 0; i < this.parts.size(); ++i) {
            ((MimeBodyPart)this.parts.get(i)).updateHeaders();
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + this.contentType.getParameter("boundary");
        for (int i = 0; i < this.parts.size(); ++i) {
            OutputUtil.writeln(string, outputStream);
            this.getBodyPart(i).writeTo(outputStream);
            OutputUtil.writeln(outputStream);
        }
        OutputUtil.writeAsAscii(string, outputStream);
        OutputUtil.writeAsAscii("--", outputStream);
        outputStream.flush();
    }

    protected void parse() throws MessagingException {
        InputStream inputStream;
        if (this.parsed) {
            return;
        }
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        String string = "--" + this.contentType.getParameter("boundary");
        byte[] byArray = ASCIIUtility.getBytes(string);
        int n = byArray.length;
        try {
            int n2;
            String string2;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string2 = lineInputStream.readLine()) != null) {
                char c;
                for (n2 = string2.length() - 1; n2 >= 0 && ((c = string2.charAt(n2)) == ' ' || c == '\t'); --n2) {
                }
                if (!(string2 = string2.substring(0, n2 + 1)).equals(string)) continue;
                break;
            }
            if (string2 == null) {
                throw new MessagingException("Missing start boundary");
            }
            n2 = 0;
            while (n2 == 0) {
                InternetHeaders internetHeaders = null;
                if (sharedInputStream != null) {
                    l = sharedInputStream.getPosition();
                    while ((string2 = lineInputStream.readLine()) != null && string2.length() > 0) {
                    }
                    if (string2 == null) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("Missing End Boundary for Mime Package : EOF while skipping headers");
                        }
                        break;
                    }
                } else {
                    internetHeaders = this.createInternetHeaders(inputStream);
                }
                if (!inputStream.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteOutputStream byteOutputStream = null;
                if (sharedInputStream == null) {
                    byteOutputStream = new ByteOutputStream();
                }
                boolean bl2 = true;
                int n3 = -1;
                int n4 = -1;
                while (true) {
                    int n5;
                    if (bl2) {
                        int n6;
                        inputStream.mark(n + 4 + 1000);
                        for (n6 = 0; n6 < n && inputStream.read() == byArray[n6]; ++n6) {
                        }
                        if (n6 == n) {
                            int n7 = inputStream.read();
                            if (n7 == 45 && inputStream.read() == 45) {
                                n2 = 1;
                                bl = true;
                                break;
                            }
                            while (n7 == 32 || n7 == 9) {
                                n7 = inputStream.read();
                            }
                            if (n7 == 10) break;
                            if (n7 == 13) {
                                inputStream.mark(1);
                                if (inputStream.read() == 10) break;
                                inputStream.reset();
                                break;
                            }
                        }
                        inputStream.reset();
                        if (byteOutputStream != null && n3 != -1) {
                            byteOutputStream.write(n3);
                            if (n4 != -1) {
                                byteOutputStream.write(n4);
                            }
                            n4 = -1;
                            n3 = -1;
                        }
                    }
                    if ((n5 = inputStream.read()) < 0) {
                        n2 = 1;
                        break;
                    }
                    if (n5 == 13 || n5 == 10) {
                        bl2 = true;
                        if (sharedInputStream != null) {
                            l2 = sharedInputStream.getPosition() - 1L;
                        }
                        n3 = n5;
                        if (n5 != 13) continue;
                        inputStream.mark(1);
                        n5 = inputStream.read();
                        if (n5 == 10) {
                            n4 = n5;
                            continue;
                        }
                        inputStream.reset();
                        continue;
                    }
                    bl2 = false;
                    if (byteOutputStream == null) continue;
                    byteOutputStream.write(n5);
                }
                MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l, l2)) : this.createMimeBodyPart(internetHeaders, byteOutputStream.getBytes(), byteOutputStream.getCount());
                this.addBodyPart(mimeBodyPart);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IO Error", iOException);
        }
        if (!ignoreMissingEndBoundary && !bl && sharedInputStream == null) {
            throw new MessagingException("Missing End Boundary for Mime Package : EOF while skipping headers");
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray, int n) {
        return new MimeBodyPart(internetHeaders, byArray, n);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }

    protected void setMultipartDataSource(MultipartDataSource multipartDataSource) throws MessagingException {
        this.contentType = new ContentType(multipartDataSource.getContentType());
        int n = multipartDataSource.getCount();
        for (int i = 0; i < n; ++i) {
            this.addBodyPart(multipartDataSource.getBodyPart(i));
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public boolean removeBodyPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        if (this.parts == null) {
            throw new MessagingException("No such body part");
        }
        boolean bl = this.parts.remove(mimeBodyPart);
        mimeBodyPart.setParent(null);
        return bl;
    }

    public void removeBodyPart(int n) {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        MimeBodyPart mimeBodyPart = (MimeBodyPart)this.parts.get(n);
        this.parts.remove(n);
        mimeBodyPart.setParent(null);
    }

    public synchronized void addBodyPart(MimeBodyPart mimeBodyPart) {
        if (this.parts == null) {
            this.parts = new FinalArrayList();
        }
        this.parts.add(mimeBodyPart);
        mimeBodyPart.setParent(this);
    }

    public synchronized void addBodyPart(MimeBodyPart mimeBodyPart, int n) {
        if (this.parts == null) {
            this.parts = new FinalArrayList();
        }
        this.parts.add(n, mimeBodyPart);
        mimeBodyPart.setParent(this);
    }

    MimeBodyPart getParent() {
        return this.parent;
    }

    void setParent(MimeBodyPart mimeBodyPart) {
        this.parent = mimeBodyPart;
    }

    static {
        ignoreMissingEndBoundary = Boolean.getBoolean("saaj.mime.multipart.ignoremissingendboundary");
    }
}

