/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.Reflection;

public class MethodHandles {
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();

    private MethodHandles() {
    }

    public static Lookup lookup() {
        return new Lookup();
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static MethodHandle arrayElementGetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(clazz, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(clazz, true);
    }

    public static MethodHandle spreadInvoker(MethodType methodType, int n) {
        if (n < 0 || n > methodType.parameterCount()) {
            throw new IllegalArgumentException("bad argument count " + n);
        }
        return methodType.invokers().spreadInvoker(n);
    }

    public static MethodHandle exactInvoker(MethodType methodType) {
        return methodType.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType methodType) {
        return methodType.invokers().generalInvoker();
    }

    static <T0, T1> T1 checkValue(Class<T0> clazz, Class<T1> clazz2, Object object) throws ClassCastException {
        if (clazz == clazz2) {
            if (clazz.isPrimitive()) {
                return Wrapper.asPrimitiveType(clazz2).cast(object);
            }
            return Wrapper.OBJECT.convert(object, clazz2);
        }
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (!bl) {
            Wrapper.OBJECT.convert(object, clazz);
            if (!bl2) {
                return Wrapper.OBJECT.convert(object, clazz2);
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
            return wrapper.convert(object, clazz2);
        }
        Wrapper.asWrapperType(clazz).cast(object);
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
        return wrapper.convert(object, clazz2);
    }

    static Object checkValue(Class<?> clazz, Object object) throws ClassCastException {
        Class clazz2 = object == null ? Object.class : object.getClass();
        return MethodHandles.checkValue(clazz2, clazz, object);
    }

    public static MethodHandle explicitCastArguments(MethodHandle methodHandle, MethodType methodType) {
        return MethodHandleImpl.convertArguments(methodHandle, methodType, 2);
    }

    public static MethodHandle permuteArguments(MethodHandle methodHandle, MethodType methodType, int ... nArray) {
        MethodType methodType2 = methodHandle.type();
        MethodHandles.checkReorder(nArray, methodType, methodType2);
        return MethodHandleImpl.permuteArguments(methodHandle, methodType, methodType2, nArray);
    }

    private static void checkReorder(int[] nArray, MethodType methodType, MethodType methodType2) {
        if (methodType.returnType() != methodType2.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", methodType2, methodType);
        }
        if (nArray.length == methodType2.parameterCount()) {
            int n = methodType.parameterCount();
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                Class<?> clazz;
                int n2 = nArray[i];
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                    break;
                }
                Class<?> clazz2 = methodType.parameterType(n2);
                if (clazz2 == (clazz = methodType2.parameterType(i))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", methodType2, methodType);
            }
            if (!bl) {
                return;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(nArray));
    }

    public static MethodHandle constant(Class<?> clazz, Object object) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            return MethodHandles.insertArguments(MethodHandles.identity(clazz), 0, wrapper.convert(object, clazz));
        }
        return MethodHandles.identity(clazz).bindTo(clazz.cast(object));
    }

    public static MethodHandle identity(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("void type");
        }
        if (clazz == Object.class) {
            return ValueConversions.identity();
        }
        if (clazz.isPrimitive()) {
            return ValueConversions.identity(Wrapper.forPrimitiveType(clazz));
        }
        return AdapterMethodHandle.makeRetypeRaw(MethodType.methodType(clazz, clazz), ValueConversions.identity());
    }

    public static MethodHandle insertArguments(MethodHandle methodHandle, int n, Object ... objectArray) {
        int n2 = objectArray.length;
        MethodType methodType = methodHandle.type();
        int n3 = methodType.parameterCount();
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (n < 0 || n > n4) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        MethodHandle methodHandle2 = methodHandle;
        for (int i = 0; i < n2; ++i) {
            MethodHandle methodHandle3;
            Object object = objectArray[i];
            Class<?> clazz = methodType.parameterType(n + i);
            object = MethodHandles.checkValue(clazz, object);
            methodHandle2 = n == 0 && !clazz.isPrimitive() && (methodHandle3 = MethodHandleImpl.bindReceiver(methodHandle2, object)) != null ? methodHandle3 : MethodHandleImpl.bindArgument(methodHandle2, n, object);
        }
        return methodHandle2;
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, List<Class<?>> list) {
        MethodType methodType = methodHandle.type();
        if (list.size() == 0) {
            return methodHandle;
        }
        int n2 = methodType.parameterCount();
        int n3 = n2 + list.size();
        if (n < 0 || n >= n3) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove");
        }
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        arrayList.addAll(n, list);
        MethodType methodType2 = MethodType.methodType(methodType.returnType(), arrayList);
        return MethodHandleImpl.dropArguments(methodHandle, methodType2, n);
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, Class<?> ... classArray) {
        return MethodHandles.dropArguments(methodHandle, n, Arrays.asList(classArray));
    }

    public static MethodHandle filterArguments(MethodHandle methodHandle, int n, MethodHandle ... methodHandleArray) {
        MethodType methodType = methodHandle.type();
        MethodHandle methodHandle2 = methodHandle;
        MethodType methodType2 = null;
        assert ((methodType2 = methodType) != null);
        int n2 = methodType.parameterCount();
        if (n + methodHandleArray.length > n2) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
        int n3 = n - 1;
        for (MethodHandle methodHandle3 : methodHandleArray) {
            ++n3;
            if (methodHandle3 == null) continue;
            methodHandle2 = MethodHandles.filterArgument(methodHandle2, n3, methodHandle3);
            assert ((methodType2 = methodType2.changeParameterType(n3, methodHandle3.type().parameterType(0))) != null);
        }
        assert (methodType2.equals((Object)methodHandle2.type()));
        return methodHandle2;
    }

    static MethodHandle filterArgument(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        if (methodType2.parameterCount() != 1 || methodType2.returnType() != methodType.parameterType(n)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", methodType, methodType2);
        }
        return MethodHandleImpl.filterArgument(methodHandle, n, methodHandle2);
    }

    public static MethodHandle filterReturnValue(MethodHandle methodHandle, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        Class<?> clazz = methodType.returnType();
        int n = methodType2.parameterCount();
        if (n == 0 ? clazz != Void.TYPE : clazz != methodType2.parameterType(0)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", methodHandle, methodHandle2);
        }
        MethodType methodType3 = methodType.changeReturnType(methodType2.returnType());
        MethodHandle methodHandle3 = null;
        if (AdapterMethodHandle.canCollectArguments(methodType2, methodType, 0, false) && (methodHandle3 = AdapterMethodHandle.makeCollectArguments(methodHandle2, methodHandle, 0, false)) != null) {
            return methodHandle3;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodHandle methodHandle4 = MethodHandles.dropArguments(methodHandle2, n, methodType.parameterList());
        methodHandle3 = MethodHandles.foldArguments(methodHandle4, methodHandle);
        assert (methodHandle3.type().equals((Object)methodType3));
        return methodHandle3;
    }

    public static MethodHandle foldArguments(MethodHandle methodHandle, MethodHandle methodHandle2) {
        boolean bl;
        int n = 0;
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        int n2 = n;
        int n3 = methodType2.parameterCount();
        int n4 = methodType2.returnType() == Void.TYPE ? 0 : 1;
        int n5 = n2 + n4;
        boolean bl2 = bl = methodType.parameterCount() >= n5 + n3;
        if (bl && !methodType2.parameterList().equals(methodType.parameterList().subList(n5, n5 + n3))) {
            bl = false;
        }
        if (bl && n4 != 0 && !methodType2.returnType().equals(methodType.parameterType(0))) {
            bl = false;
        }
        if (!bl) {
            throw MethodHandles.misMatchedTypes("target and combiner types", methodType, methodType2);
        }
        MethodType methodType3 = methodType.dropParameterTypes(n2, n5);
        MethodHandle methodHandle3 = MethodHandleImpl.foldArguments(methodHandle, methodType3, n2, methodHandle2);
        if (methodHandle3 == null) {
            throw MethodHandleStatics.newIllegalArgumentException("cannot fold from " + methodType3 + " to " + methodType);
        }
        return methodHandle3;
    }

    public static MethodHandle guardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        List<Class<?>> list;
        MethodType methodType;
        MethodType methodType2 = methodHandle.type();
        MethodType methodType3 = methodHandle2.type();
        if (!methodType3.equals((Object)(methodType = methodHandle3.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", methodType3, methodType);
        }
        if (methodType2.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + methodType2);
        }
        List<Class<?>> list2 = methodType3.parameterList();
        if (!list2.equals(list = methodType2.parameterList())) {
            int n;
            int n2 = list.size();
            if (n2 >= (n = list2.size()) || !list2.subList(0, n2).equals(list)) {
                throw MethodHandles.misMatchedTypes("target and test types", methodType3, methodType2);
            }
            methodHandle = MethodHandles.dropArguments(methodHandle, n2, list2.subList(n2, n));
            methodType2 = methodHandle.type();
        }
        return MethodHandleImpl.makeGuardWithTest(methodHandle, methodHandle2, methodHandle3);
    }

    static RuntimeException misMatchedTypes(String string, MethodType methodType, MethodType methodType2) {
        return MethodHandleStatics.newIllegalArgumentException(string + " must match: " + methodType + " != " + methodType2);
    }

    public static MethodHandle catchException(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        if (methodType2.parameterCount() < 1 || !methodType2.parameterType(0).isAssignableFrom(clazz)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + clazz);
        }
        if (methodType2.returnType() != methodType.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", methodType, methodType2);
        }
        List<Class<?>> list = methodType.parameterList();
        List<Class<?>> list2 = methodType2.parameterList();
        if (!list.equals(list2 = list2.subList(1, list2.size()))) {
            int n;
            int n2 = list2.size();
            if (n2 >= (n = list.size()) || !list.subList(0, n2).equals(list2)) {
                throw MethodHandles.misMatchedTypes("target and handler types", methodType, methodType2);
            }
            methodHandle2 = MethodHandles.dropArguments(methodHandle2, 1 + n2, list.subList(n2, n));
            methodType2 = methodHandle2.type();
        }
        return MethodHandleImpl.makeGuardWithCatch(methodHandle, clazz, methodHandle2);
    }

    public static MethodHandle throwException(Class<?> clazz, Class<? extends Throwable> clazz2) {
        return MethodHandleImpl.throwException(MethodType.methodType(clazz, clazz2));
    }

    static {
        MethodHandleImpl.initStatics();
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int ALL_MODES = 15;
        private static final int TRUSTED = -1;
        static final Lookup PUBLIC_LOOKUP;
        static final Lookup IMPL_LOOKUP;
        private static final boolean ALLOW_NESTMATE_ACCESS = false;

        private static int fixmods(int n) {
            return (n &= 7) != 0 ? n : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup() {
            this(Lookup.getCallerClassAtEntryPoint(), 15);
            Lookup.checkUnprivilegedlookupClass(this.lookupClass);
        }

        Lookup(Class<?> clazz) {
            this(clazz, 15);
        }

        private Lookup(Class<?> clazz, int n) {
            this.lookupClass = clazz;
            this.allowedModes = n;
        }

        public Lookup in(Class<?> clazz) {
            clazz.getClass();
            if (this.allowedModes == -1) {
                return new Lookup(clazz, 15);
            }
            if (clazz == this.lookupClass) {
                return this;
            }
            int n = this.allowedModes & 0xB;
            if ((n & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, clazz)) {
                n &= 0xFFFFFFF5;
            }
            if ((n & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, clazz)) {
                n &= 0xFFFFFFFD;
            }
            if (n == 1 && !VerifyAccess.isClassAccessible(clazz, this.lookupClass)) {
                n = 0;
            }
            Lookup.checkUnprivilegedlookupClass(clazz);
            return new Lookup(clazz, n);
        }

        private static void checkUnprivilegedlookupClass(Class<?> clazz) {
            String string = clazz.getName();
            if (string.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + clazz);
            }
        }

        public String toString() {
            String string = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return string + "/noaccess";
                }
                case 1: {
                    return string + "/public";
                }
                case 9: {
                    return string + "/package";
                }
                case 11: {
                    return string + "/private";
                }
                case 15: {
                    return string;
                }
                case -1: {
                    return "/trusted";
                }
            }
            string = string + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : string;
            return string;
        }

        private static Class<?> getCallerClassAtEntryPoint() {
            assert (Reflection.getCallerClass(3) == MethodHandles.class);
            return Reflection.getCallerClass(4);
        }

        public MethodHandle findStatic(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, true);
            this.checkSecurityManager(clazz, memberName);
            return this.accessStatic(clazz, memberName);
        }

        private MethodHandle accessStatic(Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            this.checkMethod(clazz, memberName, true);
            return MethodHandleImpl.findMethod(memberName, false, this.lookupClassOrNull());
        }

        private MethodHandle resolveStatic(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, true);
            return this.accessStatic(clazz, memberName);
        }

        public MethodHandle findVirtual(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false);
            this.checkSecurityManager(clazz, memberName);
            return this.accessVirtual(clazz, memberName);
        }

        private MethodHandle resolveVirtual(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false);
            return this.accessVirtual(clazz, memberName);
        }

        private MethodHandle accessVirtual(Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            this.checkMethod(clazz, memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, true, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(memberName, methodHandle);
        }

        public MethodHandle findConstructor(Class<?> clazz, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            String string = "<init>";
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false, false, this.lookupClassOrNull());
            this.checkSecurityManager(clazz, memberName);
            return this.accessConstructor(clazz, memberName);
        }

        private MethodHandle accessConstructor(Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            assert (memberName.isConstructor());
            this.checkAccess(clazz, memberName);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, false, this.lookupClassOrNull());
            MethodHandle methodHandle2 = MethodHandleImpl.makeAllocator(methodHandle);
            return Lookup.fixVarargs(methodHandle2, methodHandle);
        }

        private MethodHandle resolveConstructor(Class<?> clazz, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            String string = "<init>";
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false, false, this.lookupClassOrNull());
            return this.accessConstructor(clazz, memberName);
        }

        private static MethodHandle fixVarargs(MethodHandle methodHandle, MethodHandle methodHandle2) {
            boolean bl;
            boolean bl2 = methodHandle.isVarargsCollector();
            if (bl2 == (bl = methodHandle2.isVarargsCollector())) {
                return methodHandle;
            }
            if (bl) {
                MethodType methodType = methodHandle.type();
                int n = methodType.parameterCount();
                return methodHandle.asVarargsCollector(methodType.parameterType(n - 1));
            }
            return methodHandle.asFixedArity();
        }

        public MethodHandle findSpecial(Class<?> clazz, String string, MethodType methodType, Class<?> clazz2) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(clazz2);
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false, false, clazz2);
            this.checkSecurityManager(clazz, memberName);
            return this.accessSpecial(clazz, memberName, clazz2);
        }

        private MethodHandle accessSpecial(Class<?> clazz, MemberName memberName, Class<?> clazz2) throws NoSuchMethodException, IllegalAccessException {
            this.checkMethod(clazz, memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, false, clazz2);
            return this.restrictReceiver(memberName, methodHandle, clazz2);
        }

        private MethodHandle resolveSpecial(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            Class<?> clazz2 = this.lookupClass();
            this.checkSpecialCaller(clazz2);
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false, false, clazz2);
            return this.accessSpecial(clazz, memberName, clazz2);
        }

        public MethodHandle findGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, false);
            this.checkSecurityManager(clazz, memberName);
            return this.makeAccessor(clazz, memberName, false, false, 0);
        }

        private MethodHandle resolveGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, false);
            return this.makeAccessor(clazz, memberName, false, false, 0);
        }

        public MethodHandle findSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, false);
            this.checkSecurityManager(clazz, memberName);
            return this.makeAccessor(clazz, memberName, false, true, 0);
        }

        private MethodHandle resolveSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, false);
            return this.makeAccessor(clazz, memberName, false, true, 0);
        }

        public MethodHandle findStaticGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, true);
            this.checkSecurityManager(clazz, memberName);
            return this.makeAccessor(clazz, memberName, false, false, 1);
        }

        private MethodHandle resolveStaticGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, true);
            return this.makeAccessor(clazz, memberName, false, false, 1);
        }

        public MethodHandle findStaticSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, true);
            this.checkSecurityManager(clazz, memberName);
            return this.makeAccessor(clazz, memberName, false, true, 1);
        }

        private MethodHandle resolveStaticSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, true);
            return this.makeAccessor(clazz, memberName, false, true, 1);
        }

        public MethodHandle bind(Object object, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            Class<?> clazz = object.getClass();
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false);
            this.checkSecurityManager(clazz, memberName);
            this.checkMethod(clazz, memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, true, this.lookupClassOrNull());
            MethodHandle methodHandle2 = MethodHandleImpl.bindReceiver(methodHandle, object);
            if (methodHandle2 == null) {
                throw memberName.makeAccessException("no access", this);
            }
            return Lookup.fixVarargs(methodHandle2, methodHandle);
        }

        public MethodHandle unreflect(Method method) throws IllegalAccessException {
            MemberName memberName = new MemberName(method);
            assert (memberName.isMethod());
            if (!method.isAccessible()) {
                this.checkMethod(memberName.getDeclaringClass(), memberName, memberName.isStatic());
            }
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, true, this.lookupClassOrNull());
            if (!method.isAccessible()) {
                methodHandle = this.restrictProtectedReceiver(memberName, methodHandle);
            }
            return methodHandle;
        }

        public MethodHandle unreflectSpecial(Method method, Class<?> clazz) throws IllegalAccessException {
            this.checkSpecialCaller(clazz);
            MemberName memberName = new MemberName(method);
            assert (memberName.isMethod());
            this.checkMethod(method.getDeclaringClass(), memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, false, this.lookupClassOrNull());
            return this.restrictReceiver(memberName, methodHandle, clazz);
        }

        public MethodHandle unreflectConstructor(Constructor constructor) throws IllegalAccessException {
            MemberName memberName = new MemberName(constructor);
            assert (memberName.isConstructor());
            if (!constructor.isAccessible()) {
                this.checkAccess(constructor.getDeclaringClass(), memberName);
            }
            MethodHandle methodHandle = MethodHandleImpl.findMethod(memberName, false, this.lookupClassOrNull());
            MethodHandle methodHandle2 = MethodHandleImpl.makeAllocator(methodHandle);
            return Lookup.fixVarargs(methodHandle2, methodHandle);
        }

        public MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
            return this.makeAccessor(field.getDeclaringClass(), new MemberName(field), field.isAccessible(), false, -1);
        }

        public MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
            return this.makeAccessor(field.getDeclaringClass(), new MemberName(field), field.isAccessible(), true, -1);
        }

        MemberName resolveOrFail(Class<?> clazz, String string, Class<?> clazz2, boolean bl) throws NoSuchFieldException, IllegalAccessException {
            this.checkSymbolicClass(clazz);
            string.getClass();
            clazz2.getClass();
            int n = bl ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, clazz2, n), true, this.lookupClassOrNull(), NoSuchFieldException.class);
        }

        MemberName resolveOrFail(Class<?> clazz, String string, MethodType methodType, boolean bl) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(clazz);
            string.getClass();
            methodType.getClass();
            int n = bl ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType, n), true, this.lookupClassOrNull(), NoSuchMethodException.class);
        }

        MemberName resolveOrFail(Class<?> clazz, String string, MethodType methodType, boolean bl, boolean bl2, Class<?> clazz2) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(clazz);
            string.getClass();
            methodType.getClass();
            int n = bl ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType, n), bl2, clazz2, NoSuchMethodException.class);
        }

        void checkSymbolicClass(Class<?> clazz) throws IllegalAccessException {
            Class<?> clazz2 = this.lookupClassOrNull();
            if (clazz2 != null && !VerifyAccess.isClassAccessible(clazz, clazz2)) {
                throw new MemberName(clazz).makeAccessException("symbolic reference class is not public", this);
            }
        }

        void checkSecurityManager(Class<?> clazz, MemberName memberName) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (this.allowedModes == -1) {
                return;
            }
            securityManager.checkMemberAccess(clazz, 0);
            if (!VerifyAccess.classLoaderIsAncestor(this.lookupClass, clazz)) {
                securityManager.checkPackageAccess(VerifyAccess.getPackageName(clazz));
            }
            if (memberName.isPublic()) {
                return;
            }
            Class<?> clazz2 = memberName.getDeclaringClass();
            securityManager.checkMemberAccess(clazz2, 1);
            if (clazz2 != clazz) {
                securityManager.checkPackageAccess(VerifyAccess.getPackageName(clazz2));
            }
        }

        void checkMethod(Class<?> clazz, MemberName memberName, boolean bl) throws IllegalAccessException {
            String string;
            if (memberName.isConstructor()) {
                string = "expected a method, not a constructor";
            } else if (!memberName.isMethod()) {
                string = "expected a method";
            } else if (bl != memberName.isStatic()) {
                string = bl ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(clazz, memberName);
                return;
            }
            throw memberName.makeAccessException(string, this);
        }

        void checkAccess(Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            int n = this.allowedModes;
            if (n == -1) {
                return;
            }
            int n2 = memberName.getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isPublic(clazz.getModifiers()) && n != 0) {
                return;
            }
            int n3 = Lookup.fixmods(n2);
            if ((n3 & n) != 0 && VerifyAccess.isMemberAccessible(clazz, memberName.getDeclaringClass(), n2, this.lookupClass())) {
                return;
            }
            if ((n3 & ~n & 4) != 0 && VerifyAccess.isSamePackage(memberName.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw memberName.makeAccessException(this.accessFailedMessage(clazz, memberName), this);
        }

        String accessFailedMessage(Class<?> clazz, MemberName memberName) {
            boolean bl;
            Class<?> clazz2 = memberName.getDeclaringClass();
            int n = memberName.getModifiers();
            boolean bl2 = bl = Modifier.isPublic(clazz2.getModifiers()) && (clazz2 == clazz || Modifier.isPublic(clazz.getModifiers()));
            if (!bl && (this.allowedModes & 8) != 0) {
                boolean bl3 = bl = VerifyAccess.isClassAccessible(clazz2, this.lookupClass()) && (clazz2 == clazz || VerifyAccess.isClassAccessible(clazz, this.lookupClass()));
            }
            if (!bl) {
                return "class is not public";
            }
            if (Modifier.isPublic(n)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(n)) {
                return "member is private";
            }
            if (Modifier.isProtected(n)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        void checkSpecialCaller(Class<?> clazz) throws IllegalAccessException {
            if (this.allowedModes == -1) {
                return;
            }
            if ((this.allowedModes & 2) == 0 || clazz != this.lookupClass()) {
                throw new MemberName(clazz).makeAccessException("no private access for invokespecial", this);
            }
        }

        MethodHandle restrictProtectedReceiver(MemberName memberName, MethodHandle methodHandle) throws IllegalAccessException {
            if (!memberName.isProtected() || memberName.isStatic() || this.allowedModes == -1 || memberName.getDeclaringClass() == this.lookupClass() || VerifyAccess.isSamePackage(memberName.getDeclaringClass(), this.lookupClass())) {
                return methodHandle;
            }
            return this.restrictReceiver(memberName, methodHandle, this.lookupClass());
        }

        MethodHandle restrictReceiver(MemberName memberName, MethodHandle methodHandle, Class<?> clazz) throws IllegalAccessException {
            assert (!memberName.isStatic());
            Class<?> clazz2 = memberName.getDeclaringClass();
            if (clazz2.isInterface() || !clazz2.isAssignableFrom(clazz)) {
                throw memberName.makeAccessException("caller class must be a subclass below the method", clazz);
            }
            MethodType methodType = methodHandle.type();
            if (methodType.parameterType(0) == clazz) {
                return methodHandle;
            }
            MethodType methodType2 = methodType.changeParameterType(0, clazz);
            MethodHandle methodHandle2 = MethodHandleImpl.convertArguments(methodHandle, methodType2, methodType, 0);
            return Lookup.fixVarargs(methodHandle2, methodHandle);
        }

        MethodHandle makeAccessor(Class<?> clazz, MemberName memberName, boolean bl, boolean bl2, int n) throws IllegalAccessException {
            assert (memberName.isField());
            if (n >= 0 && n != 0 != memberName.isStatic()) {
                throw memberName.makeAccessException(n != 0 ? "expected a static field" : "expected a non-static field", this);
            }
            if (bl) {
                return MethodHandleImpl.accessField(memberName, bl2, this.lookupClassOrNull());
            }
            this.checkAccess(clazz, memberName);
            MethodHandle methodHandle = MethodHandleImpl.accessField(memberName, bl2, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(memberName, methodHandle);
        }

        MethodHandle linkMethodHandleConstant(int n, Class<?> clazz, String string, Object object) throws ReflectiveOperationException {
            switch (n) {
                case 1: {
                    return this.resolveGetter(clazz, string, (Class)object);
                }
                case 2: {
                    return this.resolveStaticGetter(clazz, string, (Class)object);
                }
                case 3: {
                    return this.resolveSetter(clazz, string, (Class)object);
                }
                case 4: {
                    return this.resolveStaticSetter(clazz, string, (Class)object);
                }
                case 5: {
                    return this.resolveVirtual(clazz, string, (MethodType)object);
                }
                case 6: {
                    return this.resolveStatic(clazz, string, (MethodType)object);
                }
                case 7: {
                    return this.resolveSpecial(clazz, string, (MethodType)object);
                }
                case 8: {
                    return this.resolveConstructor(clazz, (MethodType)object);
                }
                case 9: {
                    return this.resolveVirtual(clazz, string, (MethodType)object);
                }
            }
            throw new ReflectiveOperationException("bad MethodHandle constant #" + n + " " + string + " : " + object);
        }

        static {
            IMPL_NAMES.getClass();
            PUBLIC_LOOKUP = new Lookup(Object.class, 1);
            IMPL_LOOKUP = new Lookup(Object.class, -1);
        }
    }
}

