/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import sun.net.httpserver.ServerImpl;

class Request {
    static final int BUF_LEN = 2048;
    static final byte CR = 13;
    static final byte LF = 10;
    private String startLine;
    private SocketChannel chan;
    private InputStream is;
    private OutputStream os;
    char[] buf = new char[2048];
    int pos;
    StringBuffer lineBuf;
    Headers hdrs = null;

    Request(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.chan = this.chan;
        this.is = inputStream;
        this.os = outputStream;
        do {
            this.startLine = this.readLine();
            if (this.startLine != null) continue;
            return;
        } while (this.startLine != null && this.startLine.equals(""));
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    public String readLine() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        this.pos = 0;
        this.lineBuf = new StringBuffer();
        while (!bl2) {
            int n = this.is.read();
            if (n == -1) {
                return null;
            }
            if (bl) {
                if (n == 10) {
                    bl2 = true;
                    continue;
                }
                bl = false;
                this.consume(13);
                this.consume(n);
                continue;
            }
            if (n == 13) {
                bl = true;
                continue;
            }
            this.consume(n);
        }
        this.lineBuf.append(this.buf, 0, this.pos);
        return new String(this.lineBuf);
    }

    private void consume(int n) {
        if (this.pos == 2048) {
            this.lineBuf.append(this.buf);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)n;
    }

    public String requestLine() {
        return this.startLine;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    Headers headers() throws IOException {
        int n;
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        char[] cArray = new char[10];
        int n2 = 0;
        int n3 = this.is.read();
        if (n3 == 13 || n3 == 10) {
            n = this.is.read();
            if (n == 13 || n == 10) {
                return this.hdrs;
            }
            cArray[0] = (char)n3;
            n2 = 1;
            n3 = n;
        }
        while (true) {
            Object object;
            void var1_2;
            block22: {
                int n4;
                boolean bl;
                if (n3 != 10 && n3 != 13 && n3 >= 0) {
                    n = -1;
                    bl = n3 > 32;
                    var1_2[n2++] = (char)n3;
                } else {
                    return this.hdrs;
                }
                while ((n4 = this.is.read()) >= 0) {
                    switch (n4) {
                        case 58: {
                            if (bl && n2 > 0) {
                                n = n2;
                            }
                            bl = false;
                            break;
                        }
                        case 9: {
                            n4 = 32;
                        }
                        case 32: {
                            bl = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n3 = this.is.read();
                            if (n4 == 13 && n3 == 10 && (n3 = this.is.read()) == 13) {
                                n3 = this.is.read();
                            }
                            if (n3 == 10 || n3 == 13 || n3 > 32) break block22;
                            n4 = 32;
                        }
                    }
                    if (n2 >= ((void)var1_2).length) {
                        object = new char[((void)var1_2).length * 2];
                        System.arraycopy(var1_2, 0, object, 0, n2);
                        Object object2 = object;
                    }
                    var1_2[n2++] = (char)n4;
                }
                n3 = -1;
            }
            while (n2 > 0 && var1_2[n2 - 1] <= 32) {
                --n2;
            }
            if (n <= 0) {
                object = null;
                n = 0;
            } else {
                object = String.copyValueOf((char[])var1_2, 0, n);
                if (n < n2 && var1_2[n] == 58) {
                    ++n;
                }
                while (n < n2 && var1_2[n] <= 32) {
                    ++n;
                }
            }
            String string = n >= n2 ? new String() : String.copyValueOf((char[])var1_2, n, n2 - n);
            this.hdrs.add((String)object, string);
            n2 = 0;
        }
    }

    static class ReadStream
    extends InputStream {
        SocketChannel channel;
        ByteBuffer chanbuf;
        byte[] one;
        private boolean closed = false;
        private boolean eof = false;
        ByteBuffer markBuf;
        boolean marked;
        boolean reset;
        int readlimit;
        static long readTimeout;
        ServerImpl server;
        static final int BUFSIZE = 8192;

        public ReadStream(ServerImpl serverImpl, SocketChannel socketChannel) throws IOException {
            this.channel = socketChannel;
            this.server = serverImpl;
            this.chanbuf = ByteBuffer.allocate(8192);
            this.chanbuf.clear();
            this.one = new byte[1];
            this.reset = false;
            this.marked = false;
            this.closed = false;
        }

        @Override
        public synchronized int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public synchronized int read() throws IOException {
            int n = this.read(this.one, 0, 1);
            if (n == 1) {
                return this.one[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.eof) {
                return -1;
            }
            assert (this.channel.isBlocking());
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (this.reset) {
                int n4 = this.markBuf.remaining();
                n3 = n4 > n2 ? n2 : n4;
                this.markBuf.get(byArray, n, n3);
                if (n4 == n3) {
                    this.reset = false;
                }
            } else {
                this.chanbuf.clear();
                if (n2 < 8192) {
                    this.chanbuf.limit(n2);
                }
                while ((n3 = this.channel.read(this.chanbuf)) == 0) {
                }
                if (n3 == -1) {
                    this.eof = true;
                    return -1;
                }
                this.chanbuf.flip();
                this.chanbuf.get(byArray, n, n3);
                if (this.marked) {
                    try {
                        this.markBuf.put(byArray, n, n3);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        this.marked = false;
                    }
                }
            }
            return n3;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            if (this.reset) {
                return this.markBuf.remaining();
            }
            return this.chanbuf.remaining();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.closed = true;
        }

        @Override
        public synchronized void mark(int n) {
            if (this.closed) {
                return;
            }
            this.readlimit = n;
            this.markBuf = ByteBuffer.allocate(n);
            this.marked = true;
            this.reset = false;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.marked) {
                throw new IOException("Stream not marked");
            }
            this.marked = false;
            this.reset = true;
            this.markBuf.flip();
        }
    }

    static class WriteStream
    extends OutputStream {
        SocketChannel channel;
        ByteBuffer buf;
        SelectionKey key;
        boolean closed;
        byte[] one;
        ServerImpl server;

        public WriteStream(ServerImpl serverImpl, SocketChannel socketChannel) throws IOException {
            this.channel = socketChannel;
            this.server = serverImpl;
            assert (socketChannel.isBlocking());
            this.closed = false;
            this.one = new byte[1];
            this.buf = ByteBuffer.allocate(4096);
        }

        @Override
        public synchronized void write(int n) throws IOException {
            this.one[0] = (byte)n;
            this.write(this.one, 0, 1);
        }

        @Override
        public synchronized void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n2;
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            int n5 = this.buf.capacity();
            if (n5 < n2) {
                n3 = n2 - n5;
                this.buf = ByteBuffer.allocate(2 * (n5 + n3));
            }
            this.buf.clear();
            this.buf.put(byArray, n, n2);
            this.buf.flip();
            while ((n3 = this.channel.write(this.buf)) < n4) {
                if ((n4 -= n3) != 0) continue;
                return;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.closed = true;
        }
    }
}

