/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.core;

import org.eclipse.compare.internal.core.ComparePlugin;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class LCS {
    public static final double TOO_LONG = 1.0E7;
    private static final double POW_LIMIT = 1.5;
    private int max_differences;
    private int length;

    public void longestCommonSubsequence(SubMonitor subMonitor) {
        int length1 = this.getLength1();
        int length2 = this.getLength2();
        if (length1 == 0 || length2 == 0) {
            this.length = 0;
            return;
        }
        this.max_differences = (length1 + length2 + 1) / 2;
        if (!this.isCappingDisabled() && (double)length1 * (double)length2 > 1.0E7) {
            this.max_differences = (int)Math.pow(this.max_differences, 0.5);
        }
        this.initializeLcs(length1);
        subMonitor.beginTask(null, length1);
        int max = Math.min(length1, length2);
        int forwardBound = 0;
        while (forwardBound < max && this.isRangeEqual(forwardBound, forwardBound)) {
            this.setLcs(forwardBound, forwardBound);
            this.worked(subMonitor, 1);
            ++forwardBound;
        }
        int backBoundL1 = length1 - 1;
        int backBoundL2 = length2 - 1;
        while (backBoundL1 >= forwardBound && backBoundL2 >= forwardBound && this.isRangeEqual(backBoundL1, backBoundL2)) {
            this.setLcs(backBoundL1, backBoundL2);
            --backBoundL1;
            --backBoundL2;
            this.worked(subMonitor, 1);
        }
        this.length = forwardBound + length1 - backBoundL1 - 1 + this.lcs_rec(forwardBound, backBoundL1, forwardBound, backBoundL2, new int[2][length1 + length2 + 1], new int[3], subMonitor);
    }

    private boolean isCappingDisabled() {
        return ComparePlugin.getDefault().isCappingDisabled();
    }

    private int lcs_rec(int bottoml1, int topl1, int bottoml2, int topl2, int[][] V, int[] snake, SubMonitor subMonitor) {
        if (bottoml1 > topl1 || bottoml2 > topl2) {
            return 0;
        }
        int d = this.find_middle_snake(bottoml1, topl1, bottoml2, topl2, V, snake, subMonitor);
        int len = snake[2];
        int startx = snake[0];
        int starty = snake[1];
        int i = 0;
        while (i < len) {
            this.setLcs(startx + i, starty + i);
            this.worked(subMonitor, 1);
            ++i;
        }
        if (d > 1) {
            return len + this.lcs_rec(bottoml1, startx - 1, bottoml2, starty - 1, V, snake, subMonitor) + this.lcs_rec(startx + len, topl1, starty + len, topl2, V, snake, subMonitor);
        }
        if (d == 1) {
            int max = Math.min(startx - bottoml1, starty - bottoml2);
            int i2 = 0;
            while (i2 < max) {
                this.setLcs(bottoml1 + i2, bottoml2 + i2);
                this.worked(subMonitor, 1);
                ++i2;
            }
            return max + len;
        }
        return len;
    }

    private void worked(SubMonitor subMonitor, int work) {
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.worked(work);
    }

    private int find_middle_snake(int bottoml1, int topl1, int bottoml2, int topl2, int[][] V, int[] snake, SubMonitor subMonitor) {
        int N = topl1 - bottoml1 + 1;
        int M = topl2 - bottoml2 + 1;
        int delta = N - M;
        boolean isEven = (delta & 1) != 1;
        int limit = Math.min(this.max_differences, (N + M + 1) / 2);
        int value_to_add_forward = (M & 1) == 1 ? 1 : 0;
        int value_to_add_backward = (N & 1) == 1 ? 1 : 0;
        int start_forward = -M;
        int end_forward = N;
        int start_backward = -N;
        int end_backward = M;
        V[0][limit + 1] = 0;
        V[1][limit - 1] = N;
        int d = 0;
        while (d <= limit) {
            int y;
            int x;
            int start_diag = Math.max(value_to_add_forward + start_forward, -d);
            int end_diag = Math.min(end_forward, d);
            value_to_add_forward = 1 - value_to_add_forward;
            int k = start_diag;
            while (k <= end_diag) {
                x = k == -d || k < d && V[0][limit + k - 1] < V[0][limit + k + 1] ? V[0][limit + k + 1] : V[0][limit + k - 1] + 1;
                y = x - k;
                snake[0] = x + bottoml1;
                snake[1] = y + bottoml2;
                snake[2] = 0;
                while (x < N && y < M && this.isRangeEqual(x + bottoml1, y + bottoml2)) {
                    ++x;
                    ++y;
                    snake[2] = snake[2] + 1;
                }
                V[0][limit + k] = x;
                if (!isEven && k >= delta - d + 1 && k <= delta + d - 1 && x >= V[1][limit + k - delta]) {
                    return 2 * d - 1;
                }
                if (x >= N && end_forward > k - 1) {
                    end_forward = k - 1;
                } else if (y >= M) {
                    start_forward = k + 1;
                    value_to_add_forward = 0;
                }
                k += 2;
            }
            start_diag = Math.max(value_to_add_backward + start_backward, -d);
            end_diag = Math.min(end_backward, d);
            value_to_add_backward = 1 - value_to_add_backward;
            k = start_diag;
            while (k <= end_diag) {
                x = k == d || k != -d && V[1][limit + k - 1] < V[1][limit + k + 1] ? V[1][limit + k - 1] : V[1][limit + k + 1] - 1;
                y = x - k - delta;
                snake[2] = 0;
                while (x > 0 && y > 0 && this.isRangeEqual(x - 1 + bottoml1, y - 1 + bottoml2)) {
                    --x;
                    --y;
                    snake[2] = snake[2] + 1;
                }
                V[1][limit + k] = x;
                if (isEven && k >= -delta - d && k <= d - delta && x <= V[0][limit + k + delta]) {
                    snake[0] = bottoml1 + x;
                    snake[1] = bottoml2 + y;
                    return 2 * d;
                }
                if (x <= 0) {
                    start_backward = k + 1;
                    value_to_add_backward = 0;
                } else if (y <= 0 && end_backward > k - 1) {
                    end_backward = k - 1;
                }
                k += 2;
            }
            this.worked(subMonitor, 1);
            ++d;
        }
        int[] most_progress = LCS.findMostProgress(M, N, limit, V);
        snake[0] = bottoml1 + most_progress[0];
        snake[1] = bottoml2 + most_progress[1];
        snake[2] = 0;
        return 5;
    }

    private static int[] findMostProgress(int M, int N, int limit, int[][] V) {
        int delta = N - M;
        int forward_start_diag = (M & 1) == (limit & 1) ? Math.max(-M, -limit) : Math.max(1 - M, -limit);
        int forward_end_diag = Math.min(N, limit);
        int backward_start_diag = (N & 1) == (limit & 1) ? Math.max(-N, -limit) : Math.max(1 - N, -limit);
        int backward_end_diag = Math.min(M, limit);
        int[][] max_progress = new int[Math.max(forward_end_diag - forward_start_diag, backward_end_diag - backward_start_diag) / 2 + 1][3];
        int num_progress = 0;
        int k = forward_start_diag;
        while (k <= forward_end_diag) {
            int x = V[0][limit + k];
            int y = x - k;
            if (x <= N && y <= M) {
                int progress = x + y;
                if (progress > max_progress[0][2]) {
                    num_progress = 0;
                    max_progress[0][0] = x;
                    max_progress[0][1] = y;
                    max_progress[0][2] = progress;
                } else if (progress == max_progress[0][2]) {
                    max_progress[++num_progress][0] = x;
                    max_progress[num_progress][1] = y;
                    max_progress[num_progress][2] = progress;
                }
            }
            k += 2;
        }
        boolean max_progress_forward = true;
        int k2 = backward_start_diag;
        while (k2 <= backward_end_diag) {
            int x = V[1][limit + k2];
            int y = x - k2 - delta;
            if (x >= 0 && y >= 0) {
                int progress = N - x + M - y;
                if (progress > max_progress[0][2]) {
                    num_progress = 0;
                    max_progress_forward = false;
                    max_progress[0][0] = x;
                    max_progress[0][1] = y;
                    max_progress[0][2] = progress;
                } else if (progress == max_progress[0][2] && !max_progress_forward) {
                    max_progress[++num_progress][0] = x;
                    max_progress[num_progress][1] = y;
                    max_progress[num_progress][2] = progress;
                }
            }
            k2 += 2;
        }
        return max_progress[num_progress / 2];
    }

    protected abstract int getLength2();

    protected abstract int getLength1();

    protected abstract boolean isRangeEqual(int var1, int var2);

    protected abstract void setLcs(int var1, int var2);

    protected abstract void initializeLcs(int var1);

    public int getLength() {
        return this.length;
    }
}

