/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.swt.AnimationEngine;
import org.eclipse.e4.ui.internal.workbench.swt.AnimationFeedbackBase;
import org.eclipse.e4.ui.internal.workbench.swt.FaderAnimationFeedback;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MinMaxAddon {
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    private static final String GLOBAL_CACHE_ID = "Global";
    static String ID_SUFFIX = "(minimized)";
    private static String MINIMIZED = "Minimized";
    private static String MAXIMIZED = "Maximized";
    private static String MINIMIZED_BY_ZOOM = "MinimizedByZoom";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private IEclipseContext context;
    @Inject
    private EPartService partService;
    private boolean ignoreTagChanges = false;
    @Inject
    MAddon minMaxAddon;
    private EventHandler perspSavedListener = new EventHandler(){

        public void handleEvent(Event event) {
            MPerspective savedPersp = (MPerspective)event.getProperty("ChangedElement");
            String cache = this.getTrimCache(savedPersp);
            MinMaxAddon.this.minMaxAddon.getPersistedState().put(savedPersp.getElementId(), cache);
        }

        private String getTrimCache(MPerspective savedPersp) {
            MWindow topWin = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)savedPersp);
            String perspIdStr = String.valueOf('(') + savedPersp.getElementId() + ')';
            String cache = this.getWinCache(topWin, perspIdStr);
            for (MWindow dw : savedPersp.getWindows()) {
                cache = String.valueOf(cache) + this.getWinCache(dw, perspIdStr);
            }
            return cache;
        }

        private String getWinCache(MWindow win, String perspIdStr) {
            String winStr = "";
            List stackList = MinMaxAddon.this.modelService.findElements((MUIElement)win, null, MPartStack.class, null);
            for (MPartStack stack : stackList) {
                winStr = String.valueOf(winStr) + this.getStackTrimLoc(stack, perspIdStr);
            }
            return winStr;
        }

        private String getStackTrimLoc(MPartStack stack, String perspIdStr) {
            MWindow stackWin = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)stack);
            MUIElement tcElement = MinMaxAddon.this.modelService.find(String.valueOf(stack.getElementId()) + perspIdStr, (MUIElement)stackWin);
            if (tcElement == null) {
                return "";
            }
            MTrimBar bar = (MTrimBar)tcElement.getParent();
            int sideVal = bar.getSide().getValue();
            int index = bar.getChildren().indexOf(tcElement);
            return String.valueOf(stack.getElementId()) + ' ' + sideVal + ' ' + index + "#";
        }
    };
    private EventHandler perspOpenedListener = new EventHandler(){

        public void handleEvent(Event event) {
            MPerspective openedPersp = (MPerspective)event.getProperty("ChangedElement");
            MWindow topWin = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)openedPersp);
            this.showMinimizedTrim(topWin);
            for (MWindow dw : openedPersp.getWindows()) {
                this.showMinimizedTrim(dw);
            }
        }

        private void showMinimizedTrim(MWindow win) {
            List stackList = MinMaxAddon.this.modelService.findElements((MUIElement)win, null, MPartStack.class, null);
            for (MPartStack stack : stackList) {
                if (!stack.getTags().contains("Minimized")) continue;
                MinMaxAddon.this.createTrim((MUIElement)stack);
            }
        }
    };
    private CTabFolder2Adapter CTFButtonListener = new CTabFolder2Adapter(){

        private MUIElement getElementToChange(CTabFolderEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void maximize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MAXIMIZED);
        }

        public void minimize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MINIMIZED);
        }

        public void restore(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), null);
        }
    };
    private MouseListener CTFDblClickListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            MWindow window;
            CTabFolder ctf = (CTabFolder)e.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MPartStack && ctf.getItemCount() == 0 && (window = MinMaxAddon.this.modelService.getTopLevelWindowFor(element)) != null) {
                List tcList = MinMaxAddon.this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack)) continue;
                    TrimStack ts = (TrimStack)tc.getObject();
                    ts.showStack(false);
                }
            }
        }

        private MUIElement getElementToChange(MouseEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                CTabFolder ctf = (CTabFolder)e.widget;
                if (!ctf.getMaximizeVisible()) {
                    return;
                }
                if (e.y > ctf.getTabHeight()) {
                    return;
                }
                MUIElement elementToChange = this.getElementToChange(e);
                if (!elementToChange.getTags().contains(MAXIMIZED)) {
                    MinMaxAddon.this.setState(elementToChange, MAXIMIZED);
                } else {
                    MinMaxAddon.this.setState(elementToChange, null);
                }
            }
        }
    };
    private EventHandler widgetListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
                return;
            }
            CTabFolder ctf = MinMaxAddon.this.getCTFFor(changedElement);
            if (ctf == null) {
                return;
            }
            MUIElement stateElement = changedElement;
            if (changedElement instanceof MPartStack) {
                MPartStack stack = (MPartStack)changedElement;
                MArea area = MinMaxAddon.this.getAreaFor(stack);
                if (area != null && !(area.getWidget() instanceof CTabFolder)) {
                    stateElement = area.getCurSharedRef();
                }
            } else if (changedElement instanceof MArea) {
                stateElement = changedElement.getCurSharedRef();
            }
            MinMaxAddon.this.adjustCTFButtons(stateElement);
            ctf.removeCTabFolder2Listener((CTabFolder2Listener)MinMaxAddon.this.CTFButtonListener);
            ctf.addCTabFolder2Listener((CTabFolder2Listener)MinMaxAddon.this.CTFButtonListener);
            ctf.removeMouseListener(MinMaxAddon.this.CTFDblClickListener);
            ctf.addMouseListener(MinMaxAddon.this.CTFDblClickListener);
        }
    };
    private EventHandler perspectiveChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack ps = (MPerspectiveStack)changedElement;
            MWindow window = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)ps);
            List tcList = MinMaxAddon.this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
            MPerspective curPersp = (MPerspective)ps.getSelectedElement();
            if (curPersp != null) {
                String perspId = String.valueOf('(') + curPersp.getElementId() + ')';
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack) || !tc.getElementId().contains(perspId)) continue;
                    tc.setVisible(true);
                }
                MPlaceholder eaPlaceholder = (MPlaceholder)MinMaxAddon.this.modelService.find(MinMaxAddon.ID_EDITOR_AREA, (MUIElement)curPersp);
                MinMaxAddon.this.adjustCTFButtons((MUIElement)eaPlaceholder);
            }
            if (event.getProperty("OldValue") instanceof MPerspective) {
                MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
                String perspId = String.valueOf('(') + oldPersp.getElementId() + ')';
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack) || !tc.getElementId().contains(perspId)) continue;
                    TrimStack ts = (TrimStack)tc.getObject();
                    ts.showStack(false);
                    tc.setVisible(false);
                }
            }
            final Shell winShell = (Shell)window.getWidget();
            winShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!winShell.isDisposed()) {
                        winShell.layout(true, true);
                    }
                }
            });
        }
    };
    private EventHandler idChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedObject = event.getProperty("ChangedElement");
            if (!(changedObject instanceof MPerspective)) {
                return;
            }
            MPerspective perspective = (MPerspective)changedObject;
            String newID = (String)event.getProperty("NewValue");
            String oldID = (String)event.getProperty("OldValue");
            newID = String.valueOf('(') + newID + ')';
            oldID = String.valueOf('(') + oldID + ')';
            MWindow perspWin = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)perspective);
            if (perspWin == null) {
                return;
            }
            List trimStacks = MinMaxAddon.this.modelService.findElements((MUIElement)perspWin, null, MToolControl.class, null);
            for (MToolControl trimStack : trimStacks) {
                if (!TrimStack.CONTRIBUTION_URI.equals(trimStack.getContributionURI())) continue;
                trimStack.setElementId(trimStack.getElementId().replace(oldID, newID));
            }
        }
    };
    private EventHandler tagChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            if (MinMaxAddon.this.ignoreTagChanges) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            if (!(changedObj instanceof MUIElement)) {
                return;
            }
            MUIElement changedElement = (MUIElement)changedObj;
            if (UIEvents.isADD((Event)event)) {
                if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MINIMIZED)) {
                    MinMaxAddon.this.minimize(changedElement);
                } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MAXIMIZED)) {
                    MinMaxAddon.this.maximize(changedElement);
                }
            } else if (UIEvents.isREMOVE((Event)event)) {
                if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MINIMIZED)) {
                    MinMaxAddon.this.restore(changedElement);
                } else if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MAXIMIZED)) {
                    MinMaxAddon.this.unzoom(changedElement);
                }
            }
        }
    };
    private EventHandler perspectiveRemovedListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack) || MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement) == null) {
                return;
            }
            if (UIEvents.isREMOVE((Event)event)) {
                for (Object removedElement : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                    MUIElement removed = (MUIElement)removedElement;
                    String perspectiveId = removed.getElementId();
                    MWindow window = MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                    MTrimBar bar = MinMaxAddon.this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                    ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                    for (MUIElement child : bar.getChildren()) {
                        String trimElementId = child.getElementId();
                        if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                        toRemove.add((MToolControl)child);
                    }
                    for (MToolControl minStack : toRemove) {
                        minStack.setToBeRendered(false);
                        bar.getChildren().remove(minStack);
                    }
                }
            }
        }
    };

    private void setState(MUIElement element, String state) {
        element.getTags().remove(MINIMIZED_BY_ZOOM);
        if (MINIMIZED.equals(state)) {
            element.getTags().remove(MAXIMIZED);
            element.getTags().add(MINIMIZED);
        } else if (MAXIMIZED.equals(state)) {
            element.getTags().remove(MINIMIZED);
            element.getTags().add(MAXIMIZED);
        } else {
            element.getTags().remove(MINIMIZED);
            element.getTags().remove(MAXIMIZED);
        }
    }

    @PostConstruct
    void hookListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetListener);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.perspectiveRemovedListener);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.perspectiveChangeListener);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this.tagChangeListener);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*", this.idChangeListener);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/perpSaved", this.perspSavedListener);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/perspOpened", this.perspOpenedListener);
    }

    @PreDestroy
    void unhookListeners() {
        this.eventBroker.unsubscribe(this.widgetListener);
        this.eventBroker.unsubscribe(this.perspectiveRemovedListener);
        this.eventBroker.unsubscribe(this.perspectiveChangeListener);
        this.eventBroker.unsubscribe(this.tagChangeListener);
        this.eventBroker.unsubscribe(this.idChangeListener);
        this.eventBroker.unsubscribe(this.perspSavedListener);
        this.eventBroker.unsubscribe(this.perspOpenedListener);
    }

    private MArea getAreaFor(MPartStack stack) {
        MElementContainer parent = stack.getParent();
        while (parent != null) {
            if (parent instanceof MArea) {
                return (MArea)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void setCTFButtons(CTabFolder ctf, MUIElement stateElement, boolean hideButtons) {
        if (hideButtons) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(false);
        } else if (stateElement.getTags().contains(MINIMIZED)) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else if (stateElement.getTags().contains(MAXIMIZED)) {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMinimized(false);
            ctf.setMaximized(false);
            ctf.layout();
        }
    }

    private void adjustCTFButtons(MUIElement element) {
        if (!(element instanceof MPartStack) && !(element instanceof MPlaceholder)) {
            return;
        }
        CTabFolder ctf = this.getCTFFor(element);
        if (ctf == null) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.setCTFButtons(ctf, element, false);
        } else {
            MArea area = this.getAreaFor((MPartStack)element);
            if (area == null) {
                this.setCTFButtons(ctf, element, false);
            }
        }
    }

    private CTabFolder getCTFFor(MUIElement element) {
        if (element instanceof MArea) {
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            List stacks = this.modelService.findElements(element, null, MPartStack.class, null);
            for (MPartStack stack : stacks) {
                if (!(stack.getWidget() instanceof CTabFolder)) continue;
                return (CTabFolder)stack.getWidget();
            }
        } else {
            MPlaceholder ph;
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() instanceof MArea) {
                return this.getCTFFor(ph.getRef());
            }
        }
        return null;
    }

    boolean isEmptyPerspectiveStack(MUIElement element) {
        if (!(element instanceof MPerspectiveStack)) {
            return false;
        }
        MPerspectiveStack ps = (MPerspectiveStack)element;
        return ps.getChildren().size() == 0;
    }

    void minimize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (this.isEmptyPerspectiveStack(element)) {
            element.setVisible(false);
            return;
        }
        this.createTrim(element);
        element.setVisible(false);
        this.adjustCTFButtons(element);
        this.partService.requestActivation();
    }

    void restore(MUIElement element) {
        if (this.isEmptyPerspectiveStack(element)) {
            element.setVisible(true);
            element.getTags().remove(MINIMIZED_BY_ZOOM);
            return;
        }
        MWindow window = this.modelService.getTopLevelWindowFor(element);
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            return;
        }
        TrimStack ts = (TrimStack)trimStack.getObject();
        ts.restoreStack();
        this.adjustCTFButtons(element);
        element.getTags().remove(MINIMIZED_BY_ZOOM);
    }

    void maximize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        MWindow win = this.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<Object> elementsToMinimize = new ArrayList<Object>();
        int loc = this.modelService.getElementLocation(element);
        if ((loc & 1) != 0) {
            Object pStacks;
            List globalStacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null, 1);
            for (MPartStack gStack : globalStacks) {
                if (gStack == element || !gStack.isToBeRendered() || gStack.getWidget() == null || gStack.getTags().contains(MINIMIZED)) continue;
                elementsToMinimize.add(gStack);
            }
            Object perspStack = null;
            perspStack = persp == null ? ((pStacks = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() > 0 ? (MPerspectiveStack)pStacks.get(0) : null) : persp.getParent();
            if (perspStack != null) {
                if (perspStack.getElementId() == null || perspStack.getElementId().length() == 0) {
                    perspStack.setElementId("PerspectiveStack");
                }
                elementsToMinimize.add(perspStack);
            }
        } else {
            MPlaceholder eaPlaceholder;
            List stacks = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPartStack.class, null, 11);
            for (MPartStack theStack : stacks) {
                if (theStack == element || !theStack.isToBeRendered() || this.getWindowFor((MUIElement)theStack) != win || (loc = this.modelService.getElementLocation((MUIElement)theStack)) == 8 || theStack.getWidget() == null || !theStack.isVisible() || theStack.getTags().contains(MINIMIZED)) continue;
                elementsToMinimize.add(theStack);
            }
            if (persp != null && element != (eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)persp)) && eaPlaceholder != null && eaPlaceholder.getWidget() != null && eaPlaceholder.isVisible()) {
                elementsToMinimize.add(eaPlaceholder);
            }
        }
        Shell hostShell = (Shell)this.modelService.getTopLevelWindowFor(element).getWidget();
        FaderAnimationFeedback fader = new FaderAnimationFeedback(hostShell);
        AnimationEngine engine = new AnimationEngine(win.getContext(), (AnimationFeedbackBase)fader, 300);
        engine.schedule();
        this.restoreMaximizedElement(element, win);
        for (MUIElement mUIElement : elementsToMinimize) {
            mUIElement.getTags().add(MINIMIZED);
            mUIElement.getTags().add(MINIMIZED_BY_ZOOM);
        }
        this.adjustCTFButtons(element);
    }

    private void restoreMaximizedElement(MUIElement element, MWindow win) {
        MPerspective elePersp = this.modelService.getPerspectiveFor(element);
        ArrayList<String> maxTag = new ArrayList<String>();
        maxTag.add(MAXIMIZED);
        List curMax = this.modelService.findElements((MUIElement)win, null, MUIElement.class, maxTag);
        if (curMax.size() > 0) {
            for (MUIElement maxElement : curMax) {
                MPerspective maxPersp = this.modelService.getPerspectiveFor(maxElement);
                if (maxPersp != elePersp || maxElement == element) continue;
                this.ignoreTagChanges = true;
                try {
                    maxElement.getTags().remove(MAXIMIZED);
                }
                finally {
                    this.ignoreTagChanges = false;
                }
            }
        }
    }

    private MWindow getWindowFor(MUIElement element) {
        MElementContainer parent = element.getParent();
        while (parent != null && !(parent instanceof MWindow)) {
            parent = parent.getParent();
        }
        return (MWindow)parent;
    }

    void unzoom(MUIElement element) {
        MPerspectiveStack perspStack;
        List psList;
        int loc;
        MWindow win = this.modelService.getTopLevelWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        Shell hostShell = (Shell)win.getWidget();
        FaderAnimationFeedback fader = new FaderAnimationFeedback(hostShell);
        AnimationEngine engine = new AnimationEngine(win.getContext(), (AnimationFeedbackBase)fader, 300);
        engine.schedule();
        List stacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null, 11);
        for (MPartStack theStack : stacks) {
            if (theStack.getWidget() == null || !theStack.getTags().contains(MINIMIZED) || !theStack.getTags().contains(MINIMIZED_BY_ZOOM)) continue;
            theStack.getTags().remove(MINIMIZED);
        }
        MPlaceholder eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)(persp == null ? win : persp));
        if (element != eaPlaceholder && eaPlaceholder != null && eaPlaceholder.getTags().contains(MINIMIZED_BY_ZOOM)) {
            eaPlaceholder.getTags().remove(MINIMIZED);
        }
        if (((loc = this.modelService.getElementLocation(element)) & 1) != 0 && (psList = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() == 1 && element != (perspStack = (MPerspectiveStack)psList.get(0)) && perspStack != null && perspStack.getTags().contains(MINIMIZED_BY_ZOOM)) {
            perspStack.getTags().remove(MINIMIZED);
        }
        this.adjustCTFButtons(element);
    }

    private void createTrim(MUIElement element) {
        MTrimmedWindow window = (MTrimmedWindow)this.getWindowFor(element);
        Shell winShell = (Shell)window.getWidget();
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(TrimStack.CONTRIBUTION_URI);
            trimStack.getTags().add("TrimStack");
            MTrimBar bar = this.getBarForElement(element, window);
            int index = this.getCachedIndex(element);
            if (index == -1 || index >= bar.getChildren().size()) {
                bar.getChildren().add(trimStack);
            } else {
                bar.getChildren().add(index, trimStack);
            }
            bar.setVisible(true);
            if (bar.getWidget() == null) {
                bar.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)bar, (Object)winShell, window.getContext());
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
            trimStack.setToBeRendered(true);
        }
    }

    private String getCachedInfo(MUIElement element) {
        String cacheId = GLOBAL_CACHE_ID;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            cacheId = persp.getElementId();
        }
        String cacheInfo = (String)this.minMaxAddon.getPersistedState().get(cacheId);
        return cacheInfo;
    }

    private int getCachedIndex(MUIElement element) {
        String[] stacks;
        String cache = this.getCachedInfo(element);
        if (cache == null) {
            return -1;
        }
        String[] stringArray = stacks = cache.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                return Integer.parseInt(vals[2]);
            }
            ++n2;
        }
        return -1;
    }

    private SideValue getCachedBar(MUIElement element) {
        String[] stacks;
        String cache = this.getCachedInfo(element);
        if (cache == null) {
            return null;
        }
        String[] stringArray = stacks = cache.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                int sideVal = Integer.parseInt(vals[1]);
                return SideValue.get((int)sideVal);
            }
            ++n2;
        }
        return null;
    }

    private MTrimBar getBarForElement(MUIElement element, MTrimmedWindow window) {
        SideValue side = this.getCachedBar(element);
        if (side == null) {
            Shell winShell = (Shell)window.getWidget();
            Rectangle winBounds = winShell.getBounds();
            int winCenterX = winBounds.width / 2;
            Control stackCtrl = (Control)element.getWidget();
            Rectangle stackBounds = stackCtrl.getBounds();
            stackBounds = winShell.getDisplay().map(stackCtrl, (Control)winShell, stackBounds);
            int stackCenterX = stackBounds.x + stackBounds.width / 2;
            side = stackCenterX < winCenterX ? SideValue.LEFT : SideValue.RIGHT;
        }
        MTrimBar bar = this.modelService.getTrim(window, side);
        return bar;
    }

    private String getMinimizedElementSuffix(MUIElement element) {
        String id = ID_SUFFIX;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            id = String.valueOf('(') + persp.getElementId() + ')';
        }
        return id;
    }
}

