/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.controlli;

import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.controlli.GericoControllo;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class ControlloQuadroMultiplo
extends GericoControllo {
    protected Hashtable componentiModel = null;
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    protected ControlloQuadroMultiplo(String spec_line, Hashtable componentiModel, String nomeQuadro) {
        this.componentiModel = componentiModel;
        this.nomeQuadro = nomeQuadro;
        this.initialize(spec_line);
    }

    protected GericoModel getGericoModel(int indiceCodice, int indiceModel) {
        GericoModel gm = (GericoModel)this.listaModel.elementAt(indiceModel);
        if (indiceCodice > 0) {
            String codice = ControlloQuadroMultiplo.modificaColonnaCodice(gm.getCode(), indiceCodice + 1);
            gm = (GericoModel)this.componentiModel.get(codice);
        }
        return gm;
    }

    protected int getNumeroQuadriMultipli() {
        return Integer.parseInt(((GericoModel)this.listaModel.elementAt(0)).getValue());
    }

    protected Object[][] getParametriMarginali() {
        int numeroQuadriMultipli = this.getNumeroQuadriMultipli();
        Object[][] obj = new Object[numeroQuadriMultipli][3];
        int i = 0;
        while (i < obj.length) {
            String progressivo = this.getGericoModel(i, 1).getValue();
            String codice = this.getGericoModel(i, 2).getValue();
            String ricavi = this.getGericoModel(i, 3).getValue();
            obj[i][0] = new Double(progressivo);
            obj[i][1] = new Double(ricavi);
            obj[i][2] = codice;
            ++i;
        }
        return obj;
    }

    protected void initialize(String spec_line) {
        StringTokenizer strTok = new StringTokenizer(spec_line, "%");
        StringTokenizer strTok2 = new StringTokenizer(strTok.nextToken(), "*");
        strTok2.nextToken();
        while (strTok2.hasMoreTokens()) {
            this.addModel((GericoModel)this.componentiModel.get(strTok2.nextToken()));
        }
        try {
            strTok2 = new StringTokenizer(strTok.nextToken(), "&");
            this.codErrore = Integer.parseInt(strTok2.nextToken());
            while (strTok2.hasMoreTokens()) {
                StringTokenizer strTok3 = new StringTokenizer(strTok2.nextToken(), "*");
                String[] campiMsg = new String[strTok3.countTokens()];
                int j = 0;
                int size = campiMsg.length;
                while (j < size) {
                    campiMsg[j] = strTok3.nextToken();
                    ++j;
                }
                this.campiMsg.addElement(campiMsg);
            }
        }
        catch (Exception exception) {}
    }

    public static String modificaColonnaCodice(String codice, int indice) {
        if (codice.endsWith("M00000")) {
            return codice;
        }
        numberFormat.setMinimumIntegerDigits(3);
        String temp1 = codice.substring(0, codice.length() - 5);
        String temp2 = codice.substring(codice.length() - 2);
        return String.valueOf(temp1) + numberFormat.format(indice) + temp2;
    }
}

