/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.util;

import it.sogei.rcp.interfaces.IRelativePath;
import it.sogei.rcp.util.RCPException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class RelativePath
implements IRelativePath {
    private String absolutePath = null;
    private String relativePath = null;
    private IPath iPath;
    private String workspacePortablePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().addTrailingSeparator().toPortableString();

    private RelativePath() {
    }

    public RelativePath(String path) throws RCPException {
        path = path.replace('\\', '/');
        if (!this.checkPath(path)) {
            throw new RCPException("il path non \u00e8 relativo");
        }
        this.relativePath = path;
        this.absolutePath = String.valueOf(this.workspacePortablePath) + this.relativePath;
        this.iPath = Path.fromPortableString((String)path);
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    private String getWorkspacePath() {
        return this.workspacePortablePath;
    }

    public String getFileName() {
        if (this.iPath.getFileExtension() != null) {
            return this.iPath.lastSegment();
        }
        return null;
    }

    public String getFolderPath() {
        String filename = this.getFileName();
        String folderPath = filename != null ? this.relativePath.substring(0, this.relativePath.indexOf(filename)) : this.relativePath;
        return this.addFinalSlash(folderPath);
    }

    public String getAbsoluteFolderPath() {
        String filename = this.getFileName();
        String folderPath = filename != null ? this.absolutePath.substring(0, this.absolutePath.indexOf(filename)) : this.absolutePath;
        return this.addFinalSlash(folderPath);
    }

    private boolean checkPath(String path) {
        IPath iPath = Path.fromPortableString((String)path);
        if (iPath.isAbsolute()) {
            return false;
        }
        if (iPath.getDevice() != null) {
            return false;
        }
        return !iPath.isEmpty();
    }

    private String addFinalSlash(String path) {
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }
}

